/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFactorySpi;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.util.logging.Logging;

public class FileDataStoreFinder {
    protected static final Logger LOGGER = Logging.getLogger(FileDataStoreFinder.class);

    private FileDataStoreFinder() {
    }

    public static FileDataStore getDataStore(File file) throws IOException {
        return FileDataStoreFinder.getDataStore(file.toURI().toURL());
    }

    public static FileDataStore getDataStore(URL url) throws IOException {
        Iterator<FileDataStoreFactorySpi> ps = FileDataStoreFinder.getAvailableDataStores();
        while (ps.hasNext()) {
            FileDataStoreFactorySpi fac = ps.next();
            if (!fac.isAvailable()) continue;
            try {
                if (!fac.canProcess(url)) continue;
                return fac.createDataStore(url);
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Could not aquire " + fac.getDescription() + ":" + t, t);
            }
        }
        return null;
    }

    public static FileDataStoreFactorySpi getDataStoreFactory(String extension) {
        String extension2 = null;
        if (!extension.startsWith(".")) {
            extension2 = "." + extension;
        }
        Iterator<FileDataStoreFactorySpi> ps = FileDataStoreFinder.getAvailableDataStores();
        while (ps.hasNext()) {
            FileDataStoreFactorySpi fac = ps.next();
            if (!fac.isAvailable()) continue;
            try {
                for (String ext : fac.getFileExtensions()) {
                    if (extension.equalsIgnoreCase(ext)) {
                        return fac;
                    }
                    if (extension2 == null || !extension2.equalsIgnoreCase(ext)) continue;
                    return fac;
                }
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Could not aquire " + fac.getDescription() + ":" + t, t);
            }
        }
        return null;
    }

    public static Iterator<FileDataStoreFactorySpi> getAvailableDataStores() {
        HashSet<FileDataStoreFactorySpi> availableDS = new HashSet<FileDataStoreFactorySpi>();
        Set<FileDataStoreFactorySpi> all = CommonFactoryFinder.getFileDataStoreFactories(null);
        for (FileDataStoreFactorySpi dsFactory : all) {
            if (!dsFactory.isAvailable()) continue;
            availableDS.add(dsFactory);
        }
        return availableDS.iterator();
    }

    public static Set<String> getAvailableFileExtentions() {
        HashSet<String> extentions = new HashSet<String>();
        Iterator<FileDataStoreFactorySpi> ps = FileDataStoreFinder.getAvailableDataStores();
        while (ps.hasNext()) {
            FileDataStoreFactorySpi fac = ps.next();
            try {
                for (String fileExtention : fac.getFileExtensions()) {
                    extentions.add(fileExtention);
                }
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Could not aquire " + fac.getDescription() + ":" + t, t);
            }
        }
        return extentions;
    }
}

