/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.memory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.memory.MemoryEntry;
import org.geotools.data.store.ContentState;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class MemoryFeatureReader
implements FeatureReader<SimpleFeatureType, SimpleFeature> {
    SimpleFeatureType featureType;
    Iterator<SimpleFeature> iterator;

    public MemoryFeatureReader(ContentState state, Query query) throws IOException {
        this.featureType = state.getFeatureType();
        MemoryEntry entry = (MemoryEntry)state.getEntry();
        ArrayList<SimpleFeature> internalCollection = new ArrayList<SimpleFeature>(entry.getMemory().values());
        this.iterator = internalCollection.iterator();
    }

    @Override
    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    @Override
    public SimpleFeature next() throws IOException, IllegalAttributeException, NoSuchElementException {
        if (this.iterator == null) {
            throw new IOException("Feature Reader has been closed");
        }
        try {
            return SimpleFeatureBuilder.copy((SimpleFeature)this.iterator.next());
        }
        catch (NoSuchElementException end) {
            throw new DataSourceException("There are no more Features", end);
        }
    }

    @Override
    public boolean hasNext() {
        return this.iterator != null && this.iterator.hasNext();
    }

    @Override
    public void close() {
        if (this.iterator != null) {
            this.iterator = null;
        }
        if (this.featureType != null) {
            this.featureType = null;
        }
    }
}

