/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ows;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.geotools.ows.ServiceException;

public class ServiceExceptionParser {
    public static ServiceException parse(InputStream inputStream) throws IOException {
        ArrayList<ServiceException> exceptions = new ArrayList<ServiceException>();
        try {
            int tag;
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setProperty("javax.xml.stream.isCoalescing", false);
            inputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
            inputFactory.setProperty("javax.xml.stream.supportDTD", false);
            XMLStreamReader reader = inputFactory.createXMLStreamReader(inputStream, "UTF-8");
            while ((tag = reader.next()) != 8) {
                if (tag != 1 || !reader.getLocalName().equals("ServiceException")) continue;
                String code = ServiceExceptionParser.parseServiceExceptionCode(reader);
                String errorMessage = ServiceExceptionParser.parseServiceExceptionMessage(reader);
                exceptions.add(new ServiceException(errorMessage, code));
            }
        }
        catch (XMLStreamException e2) {
            throw new IOException(e2);
        }
        Collections.sort(exceptions, ServiceExceptionParser::compare);
        for (int i = 0; i < exceptions.size() - 1; ++i) {
            ((ServiceException)exceptions.get(i)).setNext((ServiceException)exceptions.get(i + 1));
        }
        return exceptions.isEmpty() ? null : (ServiceException)exceptions.get(0);
    }

    private static String parseServiceExceptionMessage(XMLStreamReader reader) throws XMLStreamException {
        reader.require(1, null, "ServiceException");
        return reader.getElementText();
    }

    private static String parseServiceExceptionCode(XMLStreamReader reader) throws XMLStreamException {
        reader.require(1, null, "ServiceException");
        String value = null;
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            if (!"code".equals(reader.getAttributeLocalName(i))) continue;
            value = reader.getAttributeValue(i);
            break;
        }
        return value;
    }

    private static int sortValue(ServiceException exception) {
        return exception.getCode() != null && !exception.getCode().isEmpty() ? 0 : 1;
    }

    private static int compare(ServiceException exception1, ServiceException exception2) {
        return ServiceExceptionParser.sortValue(exception1) - ServiceExceptionParser.sortValue(exception2);
    }
}

