/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.palette;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageTypeSpecifier;
import javax.media.jai.ImageLayout;
import org.geotools.util.logging.Logging;

public final class CustomPaletteBuilder {
    public static final int DEFAULT_ALPHA_TH = 1;
    private static final Logger LOGGER = Logging.getLogger(CustomPaletteBuilder.class);
    protected int maxLevel;
    protected RenderedImage src;
    protected ColorModel srcColorModel;
    protected int requiredSize;
    protected ColorNode root;
    protected int numNodes;
    protected int maxNodes;
    protected int currLevel;
    protected int currSize;
    protected ColorNode[] reduceList;
    protected ColorNode[] palette;
    protected int transparency;
    protected ColorNode transColor;
    protected int subsampleX;
    protected int subsampley;
    protected int numBands;
    protected int alphaThreshold;

    public static boolean canCreatePalette(ImageTypeSpecifier type) {
        if (type == null) {
            throw new IllegalArgumentException("type == null");
        }
        return true;
    }

    public static boolean canCreatePalette(RenderedImage image) {
        if (image == null) {
            throw new IllegalArgumentException("image == null");
        }
        ImageTypeSpecifier type = new ImageTypeSpecifier(image);
        return CustomPaletteBuilder.canCreatePalette(type);
    }

    public RenderedImage getIndexedImage() {
        IndexColorModel icm = this.getIndexColorModel();
        WritableRaster destWr = icm.createCompatibleWritableRaster(this.src.getWidth(), this.src.getHeight());
        BufferedImage dst = new BufferedImage(icm, destWr, false, null);
        int numBands = this.src.getSampleModel().getNumBands();
        int[] rgba = new int[numBands];
        boolean sourceHasAlpha = numBands % 2 == 0;
        int alphaBand = sourceHasAlpha ? numBands - 1 : -1;
        int minx_ = this.src.getMinX();
        int miny_ = this.src.getMinY();
        int srcW_ = this.src.getWidth();
        int srcH_ = this.src.getHeight();
        int maxx_ = minx_ + srcW_;
        int maxy_ = miny_ + srcH_;
        int minTileX = this.src.getMinTileX();
        int minTileY = this.src.getMinTileY();
        int maxTileX = minTileX + this.src.getNumXTiles();
        int maxTileY = minTileY + this.src.getNumYTiles();
        int dstTempX = 0;
        int dstTempY = 0;
        for (int ty = minTileY; ty < maxTileY; ++ty) {
            dstTempX = 0;
            int actualWidth = 0;
            int actualHeight = 0;
            for (int tx = minTileX; tx < maxTileX; ++tx) {
                Raster r = this.src.getTile(tx, ty);
                int minx = r.getMinX();
                int miny = r.getMinY();
                int maxx = minx + r.getWidth();
                int maxy = miny + r.getHeight();
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("minx:" + minx + " miny:" + miny);
                    LOGGER.fine("maxx:" + maxx + " maxy:" + maxy);
                }
                minx = minx < minx_ ? minx_ : minx;
                miny = miny < miny_ ? miny_ : miny;
                maxx = maxx > maxx_ ? maxx_ : maxx;
                maxy = maxy > maxy_ ? maxy_ : maxy;
                actualWidth = maxx - minx;
                actualHeight = maxy - miny;
                int j = miny;
                int jj = dstTempY;
                while (j < maxy) {
                    int i = minx;
                    int ii = dstTempX;
                    while (i < maxx) {
                        r.getPixel(i, j, rgba);
                        destWr.setSample(ii, jj, 0, this.findColorIndex(this.root, rgba, alphaBand));
                        ++i;
                        ++ii;
                    }
                    ++j;
                    ++jj;
                }
                dstTempX += actualWidth;
            }
            dstTempY += actualHeight;
        }
        return dst;
    }

    public CustomPaletteBuilder(RenderedImage src) {
        this(src, 256, 1, 1, 1);
    }

    public CustomPaletteBuilder(RenderedImage src, int size, int subsx, int subsy, int alpha_th) {
        if (subsx <= 0 || subsx >= src.getWidth()) {
            throw new IllegalArgumentException("Invalid subsample x size");
        }
        if (subsy <= 0 || subsy >= src.getWidth()) {
            throw new IllegalArgumentException("Invalid subsample y size");
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("Working on RenderedImage:" + src.toString());
            LOGGER.finer("ImageLayout:" + new ImageLayout(src).toString());
            LOGGER.finer("MapSize:" + size + " subsx=" + subsx + ",subsy=" + subsy);
        }
        this.alphaThreshold = alpha_th;
        this.src = src;
        this.srcColorModel = src.getColorModel();
        this.numBands = this.srcColorModel.getNumComponents();
        this.subsampleX = subsx;
        this.subsampley = subsy;
        this.transparency = this.srcColorModel.getTransparency();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("Transparency is: " + this.transparency);
        }
        if (this.transparency != 1) {
            this.transparency = 2;
            this.requiredSize = size - 1;
            this.transColor = new ColorNode();
            this.transColor.isLeaf = true;
        } else {
            this.requiredSize = size;
        }
        if (this.requiredSize > 256) {
            throw new IllegalArgumentException("Unvalid number of colors required.");
        }
        this.maxLevel = (int)Math.ceil(Math.log(this.requiredSize) / Math.log(2.0));
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("MaxLevel is: " + this.maxLevel);
        }
    }

    protected int findColorIndex(ColorNode aNode, int[] rgba, int transpBand) {
        if (this.transparency != 1 && rgba[transpBand] < this.alphaThreshold) {
            return 0;
        }
        try {
            if (aNode.isLeaf) {
                return aNode.paletteIndex;
            }
            int childIndex = this.getBranchIndex(rgba, aNode.level);
            if (aNode.children[childIndex] == null) {
                for (int i = 1; i < 8; ++i) {
                    if (childIndex + i < 8 && aNode.children[childIndex + i] != null) {
                        childIndex += i;
                        break;
                    }
                    if (childIndex - i < 0 || aNode.children[childIndex - i] == null) continue;
                    childIndex -= i;
                    break;
                }
            }
            return this.findColorIndex(aNode.children[childIndex], rgba, transpBand);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public CustomPaletteBuilder buildPalette() {
        this.reduceList = new ColorNode[this.maxLevel + 1];
        for (int i = 0; i < this.reduceList.length; ++i) {
            this.reduceList[i] = null;
        }
        this.numNodes = 0;
        this.maxNodes = 0;
        this.root = null;
        this.currSize = 0;
        this.currLevel = this.maxLevel;
        int numBands = this.src.getSampleModel().getNumBands();
        int[] rgba = new int[numBands];
        boolean discriminantTransparency = this.transparency != 1;
        int transpBand = numBands - 1;
        int minx_ = this.src.getMinX();
        int miny_ = this.src.getMinY();
        int srcW_ = this.src.getWidth();
        int srcH_ = this.src.getHeight();
        int maxx_ = minx_ + srcW_;
        int maxy_ = miny_ + srcH_;
        int minTileX = this.src.getMinTileX();
        int minTileY = this.src.getMinTileY();
        int maxTileX = minTileX + this.src.getNumXTiles();
        int maxTileY = minTileY + this.src.getNumYTiles();
        for (int ty = minTileY; ty < maxTileY; ++ty) {
            for (int tx = minTileX; tx < maxTileX; ++tx) {
                Raster r = this.src.getTile(tx, ty);
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.fine("Working on tile tx:" + tx + "ty:" + ty);
                }
                int minx = r.getMinX();
                int miny = r.getMinY();
                int maxx = minx + r.getWidth();
                int maxy = miny + r.getHeight();
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("minx:" + minx + " miny:" + miny);
                    LOGGER.finer("maxx:" + maxx + " maxy:" + maxy);
                }
                minx = minx < minx_ ? minx_ : minx;
                miny = miny < miny_ ? miny_ : miny;
                maxx = maxx > maxx_ ? maxx_ : maxx;
                maxy = maxy > maxy_ ? maxy_ : maxy;
                for (int j = miny; j < maxy; ++j) {
                    if (this.subsampley > 1 && j % this.subsampley != 0) {
                        if (!LOGGER.isLoggable(Level.FINER)) continue;
                        LOGGER.finer("Skipping J:" + j + " due to subsy:" + this.subsampley);
                        continue;
                    }
                    for (int i = minx; i < maxx; ++i) {
                        if (this.subsampleX > 1 && i % this.subsampleX != 0) {
                            if (!LOGGER.isLoggable(Level.FINER)) continue;
                            LOGGER.finer("Skipping I:" + j + " due to subsx:" + this.subsampleX);
                            continue;
                        }
                        r.getPixel(i, j, rgba);
                        if (discriminantTransparency && rgba[transpBand] < this.alphaThreshold) {
                            this.transColor = this.insertNode(this.transColor, rgba, 0);
                            if (LOGGER.isLoggable(Level.FINER)) {
                                LOGGER.finer("Transparent color!");
                            }
                        } else {
                            this.root = this.insertNode(this.root, rgba, 0);
                        }
                        if (this.currSize <= this.requiredSize) continue;
                        this.reduceTree();
                    }
                }
            }
        }
        return this;
    }

    protected ColorNode insertNode(ColorNode aNode, int[] rgba, int aLevel) {
        if (aNode == null) {
            aNode = new ColorNode();
            ++this.numNodes;
            if (this.numNodes > this.maxNodes) {
                this.maxNodes = this.numNodes;
            }
            aNode.level = aLevel;
            boolean bl = aNode.isLeaf = aLevel > this.maxLevel;
            if (aNode.isLeaf) {
                ++this.currSize;
            }
        }
        int numBands = rgba.length;
        ++aNode.colorCount;
        aNode.red += (long)rgba[0];
        aNode.green = aNode.green + (long)rgba[numBands < 3 ? 0 : 1];
        aNode.blue = aNode.blue + (long)rgba[numBands < 3 ? 0 : 2];
        if (!aNode.isLeaf) {
            int branchIndex = this.getBranchIndex(rgba, aLevel);
            if (aNode.children[branchIndex] == null) {
                ++aNode.childCount;
                if (aNode.childCount == 2) {
                    aNode.nextReducible = this.reduceList[aLevel];
                    this.reduceList[aLevel] = aNode;
                }
            }
            aNode.children[branchIndex] = this.insertNode(aNode.children[branchIndex], rgba, aLevel + 1);
        }
        return aNode;
    }

    public IndexColorModel getIndexColorModel() {
        int size = this.currSize;
        if (this.transparency == 2) {
            ++size;
        }
        if (size < 2) {
            size = 2;
        }
        byte[] red = new byte[size];
        byte[] green = new byte[size];
        byte[] blue = new byte[size];
        int index = 0;
        this.palette = new ColorNode[size];
        if (this.transparency == 2) {
            ++index;
        }
        this.findPaletteEntry(this.root, index, red, green, blue);
        if (this.transparency == 2) {
            return new IndexColorModel(8, size, red, green, blue, 0);
        }
        return new IndexColorModel(8, this.currSize, red, green, blue);
    }

    protected int findPaletteEntry(ColorNode aNode, int index, byte[] red, byte[] green, byte[] blue) {
        if (aNode == null) {
            return index;
        }
        if (aNode.isLeaf) {
            red[index] = (byte)(aNode.red / (long)aNode.colorCount);
            green[index] = (byte)(aNode.green / (long)aNode.colorCount);
            blue[index] = (byte)(aNode.blue / (long)aNode.colorCount);
            aNode.paletteIndex = index;
            this.palette[index] = aNode;
            ++index;
        } else {
            for (int i = 0; i < 8; ++i) {
                if (aNode.children[i] == null) continue;
                index = this.findPaletteEntry(aNode.children[i], index, red, green, blue);
            }
        }
        return index;
    }

    protected int getBranchIndex(int[] rgba, int aLevel) {
        if (aLevel > this.maxLevel || aLevel < 0) {
            throw new IllegalArgumentException("Invalid octree node depth: " + aLevel);
        }
        int numBands = rgba.length;
        int shift = this.maxLevel - aLevel;
        int red_index = 1 & (0xFF & rgba[0]) >> shift;
        int green_index = 1 & (0xFF & rgba[numBands < 3 ? 0 : 1]) >> shift;
        int blue_index = 1 & (0xFF & rgba[numBands < 3 ? 0 : 2]) >> shift;
        int index = red_index << 2 | green_index << 1 | blue_index;
        return index;
    }

    protected void reduceTree() {
        int level;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("reduceTree called");
        }
        for (level = this.reduceList.length - 1; this.reduceList[level] == null && level >= 0; --level) {
        }
        ColorNode thisNode = this.reduceList[level];
        if (thisNode == null) {
            return;
        }
        ColorNode pList = thisNode;
        int minColorCount = pList.colorCount;
        while (pList.nextReducible != null) {
            if (minColorCount > pList.nextReducible.colorCount) {
                thisNode = pList;
                minColorCount = pList.colorCount;
            }
            pList = pList.nextReducible;
        }
        if (thisNode == this.reduceList[level]) {
            this.reduceList[level] = thisNode.nextReducible;
        } else {
            pList = thisNode.nextReducible;
            thisNode.nextReducible = pList.nextReducible;
            thisNode = pList;
        }
        if (thisNode.isLeaf) {
            return;
        }
        int leafChildCount = thisNode.getLeafChildCount();
        thisNode.isLeaf = true;
        this.currSize -= leafChildCount - 1;
        for (int i = 0; i < 8; ++i) {
            thisNode.children[i] = this.freeTree(thisNode.children[i]);
        }
        thisNode.childCount = 0;
    }

    protected ColorNode freeTree(ColorNode aNode) {
        if (aNode == null) {
            return null;
        }
        for (int i = 0; i < 8; ++i) {
            aNode.children[i] = this.freeTree(aNode.children[i]);
        }
        --this.numNodes;
        return null;
    }

    public int findNearestColorIndex(int[] rgba, int transparentBand) {
        return this.findColorIndex(this.root, rgba, transparentBand);
    }

    protected class ColorNode {
        public boolean isLeaf = false;
        public int childCount = 0;
        public ColorNode[] children = new ColorNode[8];
        public int colorCount;
        public long red;
        public long blue;
        public long green;
        public int paletteIndex;
        public int level = 0;
        public ColorNode nextReducible;

        public ColorNode() {
            for (int i = 0; i < 8; ++i) {
                this.children[i] = null;
            }
            this.colorCount = 0;
            this.blue = 0L;
            this.green = 0L;
            this.red = 0L;
            this.paletteIndex = 0;
        }

        public int getLeafChildCount() {
            if (this.isLeaf) {
                return 0;
            }
            int cnt = 0;
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i] == null) continue;
                if (this.children[i].isLeaf) {
                    ++cnt;
                    continue;
                }
                cnt += this.children[i].getLeafChildCount();
            }
            return cnt;
        }

        public int getRGB() {
            int r = (int)this.red / this.colorCount;
            int g2 = (int)this.green / this.colorCount;
            int b2 = (int)this.blue / this.colorCount;
            int c2 = 0xFF000000 | (0xFF & r) << 16 | (0xFF & g2) << 8 | 0xFF & b2;
            return c2;
        }
    }
}

