/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.math;

import java.io.Serializable;
import org.opengis.util.Cloneable;

public class Plane
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 2956201711131316723L;
    public double c;
    public double cx;
    public double cy;

    public final double z(double x, double y) {
        return this.c + this.cx * x + this.cy * y;
    }

    public final double y(double x, double z) {
        return (z - (this.c + this.cx * x)) / this.cy;
    }

    public final double x(double y, double z) {
        return (z - (this.c + this.cy * y)) / this.cx;
    }

    public void setPlane(double[][] points) throws ArithmeticException {
        if (points == null) {
            throw new NullPointerException("Points array required");
        }
        if (points.length != 3) {
            throw new IllegalArgumentException("Three points are required to determine plane");
        }
        double[] P1 = points[0];
        double[] P2 = points[1];
        double[] P3 = points[2];
        if (P1.length != 3 || P2.length != 3 || P3.length != 3) {
            throw new IllegalArgumentException("3D points required");
        }
        boolean X2 = false;
        boolean Y = true;
        int Z = 2;
        double m00 = P2[0] * P3[1] - P3[0] * P2[1];
        double m01 = P3[0] * P1[1] - P1[0] * P3[1];
        double m02 = P1[0] * P2[1] - P2[0] * P1[1];
        double det = m00 + m01 + m02;
        if (det == 0.0) {
            throw new ArithmeticException("Points are colinear");
        }
        this.c = (m00 * P1[2] + m01 * P2[2] + m02 * P3[2]) / det;
        this.cx = ((P2[1] - P3[1]) * P1[2] + (P3[1] - P1[1]) * P2[2] + (P1[1] - P2[1]) * P3[2]) / det;
        this.cy = ((P3[0] - P2[0]) * P1[2] + (P1[0] - P3[0]) * P2[2] + (P2[0] - P1[0]) * P3[2]) / det;
    }

    public void setPlane(double[] x, double[] y, double[] z) throws IllegalArgumentException {
        int N = x.length;
        if (N != y.length || N != z.length) {
            throw new IllegalArgumentException("Vector x (length " + N + "), Vector y (length:" + y.length + ") and Vector (length:" + z.length + ") are not the same length");
        }
        double sum_x = 0.0;
        double sum_y = 0.0;
        double sum_z = 0.0;
        double sum_xx = 0.0;
        double sum_yy = 0.0;
        double sum_xy = 0.0;
        double sum_zx = 0.0;
        double sum_zy = 0.0;
        for (int i = 0; i < N; ++i) {
            double xi = x[i];
            double yi = y[i];
            double zi = z[i];
            sum_x += xi;
            sum_y += yi;
            sum_z += zi;
            sum_xx += xi * xi;
            sum_yy += yi * yi;
            sum_xy += xi * yi;
            sum_zx += zi * xi;
            sum_zy += zi * yi;
        }
        double ZX = sum_zx - sum_z * sum_x / (double)N;
        double ZY = sum_zy - sum_z * sum_y / (double)N;
        double XX = sum_xx - sum_x * sum_x / (double)N;
        double XY = sum_xy - sum_x * sum_y / (double)N;
        double YY = sum_yy - sum_y * sum_y / (double)N;
        double den = XY * XY - XX * YY;
        this.cy = (ZX * XY - ZY * XX) / den;
        this.cx = (ZY * XY - ZX * YY) / den;
        this.c = (sum_z - (this.cx * sum_x + this.cy * sum_y)) / (double)N;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("z(x,y)= ");
        if (this.c == 0.0 && this.cx == 0.0 && this.cy == 0.0) {
            buffer.append(0);
        } else {
            if (this.c != 0.0) {
                buffer.append(this.c).append(" + ");
            }
            if (this.cx != 0.0) {
                buffer.append(this.cx).append("*x");
                if (this.cy != 0.0) {
                    buffer.append(" + ");
                }
            }
            if (this.cy != 0.0) {
                buffer.append(this.cy).append("*y");
            }
        }
        return buffer.toString();
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass().equals(object.getClass())) {
            Plane that = (Plane)object;
            return Double.doubleToLongBits(this.c) == Double.doubleToLongBits(that.c) && Double.doubleToLongBits(this.cx) == Double.doubleToLongBits(that.cx) && Double.doubleToLongBits(this.cy) == Double.doubleToLongBits(that.cy);
        }
        return false;
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.c) + 37L * (Double.doubleToLongBits(this.cx) + 37L * Double.doubleToLongBits(this.cy));
        return (int)code ^ (int)(code >>> 32);
    }

    @Override
    public Plane clone() {
        try {
            return (Plane)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError((Object)exception);
        }
    }
}

