/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.geotools.metadata.i18n.Loggings;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.factory.BackingStoreException;
import org.geotools.referencing.operation.AbstractCoordinateOperation;
import org.geotools.referencing.operation.DefaultCoordinateOperationFactory;
import org.geotools.referencing.operation.DefaultOperationMethod;
import org.geotools.referencing.operation.ForcedCRSOperation;
import org.geotools.util.factory.FactoryRegistryException;
import org.geotools.util.factory.Hints;
import org.geotools.util.factory.OptionalFactory;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.Operation;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;

public class AuthorityBackedFactory
extends DefaultCoordinateOperationFactory
implements OptionalFactory {
    static final int PRIORITY = 60;
    private static final String DEFAULT_AUTHORITY = "EPSG";
    private CoordinateOperationAuthorityFactory authorityFactory;
    private final ThreadLocal<Boolean> processing = new ThreadLocal();

    public AuthorityBackedFactory() {
        this(null);
    }

    public AuthorityBackedFactory(Hints userHints) {
        super(userHints, 60);
        userHints = new Hints(userHints);
        userHints.keySet().removeAll(this.hints.keySet());
        userHints.remove(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER);
        userHints.remove(Hints.FORCE_STANDARD_AXIS_DIRECTIONS);
        userHints.remove(Hints.FORCE_STANDARD_AXIS_UNITS);
        if (!userHints.isEmpty()) {
            AuthorityBackedFactory.noForce(userHints);
            this.authorityFactory = ReferencingFactoryFinder.getCoordinateOperationAuthorityFactory(DEFAULT_AUTHORITY, userHints);
        }
    }

    private static void noForce(Hints userHints) {
        userHints.put(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.FALSE);
        userHints.put(Hints.FORCE_STANDARD_AXIS_DIRECTIONS, Boolean.FALSE);
        userHints.put(Hints.FORCE_STANDARD_AXIS_UNITS, Boolean.FALSE);
    }

    protected CoordinateOperationAuthorityFactory getAuthorityFactory() {
        if (this.authorityFactory == null) {
            Hints hints = new Hints();
            AuthorityBackedFactory.noForce(hints);
            this.authorityFactory = ReferencingFactoryFinder.getCoordinateOperationAuthorityFactory(DEFAULT_AUTHORITY, hints);
        }
        return this.authorityFactory;
    }

    @Override
    protected CoordinateOperation createFromDatabase(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) {
        Set<CoordinateOperation> operations = this.findFromDatabase(sourceCRS, targetCRS, 1);
        Iterator<CoordinateOperation> iterator = operations.iterator();
        if (iterator.hasNext()) {
            CoordinateOperation op = iterator.next();
            return op;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CoordinateOperation validateCandidate(CoordinateOperation candidate, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, boolean inverse) {
        try {
            if (inverse) {
                candidate = this.inverse(candidate);
            }
        }
        catch (NoninvertibleTransformException e2) {
            return null;
        }
        catch (FactoryException exception) {
            AuthorityBackedFactory.log(exception, this.authorityFactory);
            return null;
        }
        CoordinateReferenceSystem source = candidate.getSourceCRS();
        CoordinateReferenceSystem target = candidate.getTargetCRS();
        try {
            MathTransform append;
            MathTransform prepend;
            if (!CRS.equalsIgnoreMetadata(sourceCRS, source)) {
                try {
                    this.processing.set(Boolean.TRUE);
                    prepend = this.createOperation(sourceCRS, source).getMathTransform();
                    source = sourceCRS;
                }
                finally {
                    this.processing.remove();
                }
            } else {
                prepend = null;
            }
            if (!CRS.equalsIgnoreMetadata(target, targetCRS)) {
                try {
                    this.processing.set(Boolean.TRUE);
                    append = this.createOperation(target, targetCRS).getMathTransform();
                    target = targetCRS;
                }
                finally {
                    this.processing.remove();
                }
            } else {
                append = null;
            }
            candidate = this.transform(source, prepend, candidate, append, target);
        }
        catch (FactoryException exception) {
            AuthorityBackedFactory.log(exception, this.authorityFactory);
            return null;
        }
        if (this.accept(candidate)) {
            return candidate;
        }
        return null;
    }

    @Override
    protected Set<CoordinateOperation> findFromDatabase(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, int limit) {
        boolean inverse;
        String targetCode;
        HashSet<CoordinateOperation> result = new HashSet<CoordinateOperation>();
        if (Boolean.TRUE.equals(this.processing.get())) {
            return result;
        }
        CoordinateOperationAuthorityFactory authorityFactory = this.getAuthorityFactory();
        Citation authority = authorityFactory.getAuthority();
        ReferenceIdentifier sourceID = AbstractIdentifiedObject.getIdentifier(sourceCRS, authority);
        if (sourceID == null) {
            return result;
        }
        ReferenceIdentifier targetID = AbstractIdentifiedObject.getIdentifier(targetCRS, authority);
        if (targetID == null) {
            return result;
        }
        String sourceCode = sourceID.getCode().trim();
        if (sourceCode.equals(targetCode = targetID.getCode().trim())) {
            return result;
        }
        Set<CoordinateOperation> operations = null;
        try {
            operations = authorityFactory.createFromCoordinateReferenceSystemCodes(sourceCode, targetCode);
            boolean bl = inverse = operations == null || operations.isEmpty();
            if (inverse) {
                operations = authorityFactory.createFromCoordinateReferenceSystemCodes(targetCode, sourceCode);
            }
        }
        catch (NoSuchAuthorityCodeException exception) {
            return result;
        }
        catch (FactoryException exception) {
            AuthorityBackedFactory.log(exception, authorityFactory, Level.FINER);
            return result;
        }
        Iterator<CoordinateOperation> it = operations.iterator();
        int i = 0;
        while ((limit < 0 || i < limit) && it.hasNext()) {
            try {
                CoordinateOperation candidate = it.next();
                if ((candidate = this.validateCandidate(candidate, sourceCRS, targetCRS, inverse)) == null) continue;
                ++i;
                result.add(candidate);
            }
            catch (BackingStoreException exc) {
                AuthorityBackedFactory.log(exc, authorityFactory);
            }
        }
        return result;
    }

    private CoordinateOperation transform(CoordinateReferenceSystem sourceCRS, MathTransform prepend, CoordinateOperation operation, MathTransform append, CoordinateReferenceSystem targetCRS) throws FactoryException {
        List<SingleOperation> c2;
        CoordinateOperation[] op;
        if ((prepend == null || prepend.isIdentity()) && (append == null || append.isIdentity())) {
            if (!CRS.equalsIgnoreMetadata(sourceCRS, operation.getSourceCRS()) || !CRS.equalsIgnoreMetadata(targetCRS, operation.getTargetCRS())) {
                return new ForcedCRSOperation(operation, sourceCRS, targetCRS);
            }
            return operation;
        }
        Map<String, ?> properties = AbstractIdentifiedObject.getProperties(operation);
        if (operation instanceof ConcatenatedOperation && (op = (c2 = ((ConcatenatedOperation)operation).getOperations()).toArray(new CoordinateOperation[c2.size()])).length != 0) {
            CoordinateOperation first = op[0];
            if (op.length == 1) {
                op[0] = this.transform(sourceCRS, prepend, first, append, targetCRS);
            } else {
                CoordinateOperation last = op[op.length - 1];
                op[0] = this.transform(sourceCRS, prepend, first, null, first.getTargetCRS());
                op[op.length - 1] = this.transform(last.getSourceCRS(), null, last, append, targetCRS);
            }
            return this.createConcatenatedOperation(properties, op);
        }
        MathTransform transform = operation.getMathTransform();
        MathTransformFactory mtFactory = this.getMathTransformFactory();
        if (prepend != null) {
            transform = mtFactory.createConcatenatedTransform(prepend, transform);
        }
        if (append != null) {
            transform = mtFactory.createConcatenatedTransform(transform, append);
        }
        assert (!transform.equals(operation.getMathTransform())) : transform;
        Class<? extends CoordinateOperation> type = AbstractCoordinateOperation.getType(operation);
        OperationMethod method = null;
        if (operation instanceof Operation && (method = ((Operation)operation).getMethod()) != null) {
            int sourceDimensions = transform.getSourceDimensions();
            int targetDimensions = transform.getTargetDimensions();
            if (sourceDimensions != method.getSourceDimensions() || targetDimensions != method.getTargetDimensions()) {
                method = new DefaultOperationMethod(method, sourceDimensions, targetDimensions);
            }
        }
        return this.createFromMathTransform(properties, sourceCRS, targetCRS, transform, method, type);
    }

    private static void log(Exception exception, AuthorityFactory factory) {
        AuthorityBackedFactory.log(exception, factory, Level.WARNING);
    }

    private static void log(Exception exception, AuthorityFactory factory, Level level) {
        LogRecord record = Loggings.format(level, 6, factory.getAuthority().getTitle());
        record.setSourceClassName(AuthorityBackedFactory.class.getName());
        record.setSourceMethodName("createFromDatabase");
        record.setThrown(exception);
        record.setLoggerName(LOGGER.getName());
        LOGGER.log(record);
    }

    protected boolean accept(CoordinateOperation operation) {
        return true;
    }

    @Override
    public boolean isAvailable() {
        try {
            CoordinateOperationAuthorityFactory authorityFactory = this.getAuthorityFactory();
            if (authorityFactory instanceof OptionalFactory) {
                return ((OptionalFactory)((Object)authorityFactory)).isAvailable();
            }
            return true;
        }
        catch (FactoryRegistryException exception) {
            return false;
        }
    }
}

