/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.imageutils;

import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jaitools.CollectionFactory;
import org.jaitools.imageutils.iterator.SimpleIterator;
import org.jaitools.numeric.NumberOperations;

public class ImageSet<K> {
    private final Map<K, Element> elements = CollectionFactory.orderedMap();

    public static <K> ImageSet<K> copy(ImageSet<K> set) {
        ImageSet<K> newSet = new ImageSet<K>();
        if (set != null && !set.isEmpty()) {
            for (K key : set.keySet()) {
                RenderedImage image = set.get(key);
                Number outsideValue = set.getOutsideValue(key);
                newSet.add(key, image, outsideValue);
            }
        }
        return newSet;
    }

    public void add(K key, RenderedImage image, Number outsideValue) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (image == null) {
            throw new IllegalArgumentException("image must not be null");
        }
        this.elements.put(key, new Element(image, outsideValue));
    }

    public int size() {
        return this.elements.size();
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public boolean containsKey(K key) {
        return this.elements.containsKey(key);
    }

    public boolean containsImage(RenderedImage image) {
        for (Element e2 : this.elements.values()) {
            if (e2.getImage() != image) continue;
            return true;
        }
        return false;
    }

    public RenderedImage get(K key) {
        return this.elements.get(key).getImage();
    }

    public RenderedImage remove(K key) {
        return this.elements.remove(key).getImage();
    }

    public void putAll(ImageSet<? extends K> otherSet) {
        if (otherSet != this) {
            this.elements.putAll(otherSet.elements);
        }
    }

    public void clear() {
        this.elements.clear();
    }

    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.elements.keySet());
    }

    public Set<RenderedImage> values() {
        Set set = CollectionFactory.orderedSet();
        for (Element e2 : this.elements.values()) {
            set.add(e2.getImage());
        }
        return Collections.unmodifiableSet(set);
    }

    public Iterator<K> getIterator() {
        return this.getIterator(this.elements.keySet().iterator().next());
    }

    public Iterator<K> getIterator(K referenceImageKey) {
        if (this.elements.isEmpty()) {
            throw new IllegalArgumentException("This image set is empty");
        }
        Rectangle bounds = this.getBounds(referenceImageKey);
        return this.getIterator(bounds);
    }

    public Iterator<K> getIterator(Rectangle bounds) {
        return new Iterator(this, bounds);
    }

    public Rectangle getBounds(K key) {
        Element e2 = this.elements.get(key);
        return e2 == null ? null : e2.getBounds();
    }

    public Rectangle getUnionBounds() {
        Rectangle r = new Rectangle();
        for (Element e2 : this.elements.values()) {
            r = r.union(e2.getBounds());
        }
        return r;
    }

    public Rectangle getIntersectionBounds() {
        Rectangle r = null;
        for (Element e2 : this.elements.values()) {
            if (!(r = r == null ? e2.getBounds() : r.intersection(e2.getBounds())).isEmpty()) continue;
            break;
        }
        return r;
    }

    public Number getOutsideValue(K key) {
        this.assertKey(key);
        return this.elements.get(key).getOutsideValue();
    }

    private void assertKey(K key) {
        if (!this.elements.containsKey(key)) {
            throw new IllegalArgumentException("The key does not match an image in this set");
        }
    }

    public static class Iterator<K> {
        private final List<K> keys;
        private final List<SimpleIterator> delegates;

        private Iterator(ImageSet set, Rectangle bounds) {
            if (set == null || set.isEmpty()) {
                throw new IllegalArgumentException("The ImageSet must not be null or empty");
            }
            this.keys = CollectionFactory.list();
            this.delegates = CollectionFactory.list();
            Set keySet = set.keySet();
            for (Object key : keySet) {
                this.keys.add(key);
                this.delegates.add(new SimpleIterator(set.get(key), bounds, set.getOutsideValue(key)));
            }
        }

        public Map<K, Number> getSample() {
            return this.getSample(0);
        }

        public Map<K, Number> getSample(int band) {
            Map<K, Number> sample = CollectionFactory.map();
            for (int i = 0; i < this.keys.size(); ++i) {
                K key = this.keys.get(i);
                Number value = this.delegates.get(i).getSample(band);
                sample.put(key, value);
            }
            return sample;
        }

        public boolean hasNext() {
            return this.delegates.get(0).hasNext();
        }

        public boolean next() {
            if (this.hasNext()) {
                for (SimpleIterator iter : this.delegates) {
                    iter.next();
                }
                return true;
            }
            return false;
        }
    }

    public static class Element {
        private final RenderedImage image;
        private final Number outsideValue;

        public Element(RenderedImage image, Number outsideValue) {
            this.image = image;
            this.outsideValue = NumberOperations.copy(outsideValue);
        }

        private RenderedImage getImage() {
            return this.image;
        }

        private Number getOutsideValue() {
            return NumberOperations.copy(this.outsideValue);
        }

        private Rectangle getBounds() {
            return new Rectangle(this.image.getMinX(), this.image.getMinY(), this.image.getWidth(), this.image.getHeight());
        }
    }
}

