/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.numeric;

import java.util.HashMap;
import java.util.Map;

public enum Statistic {
    MEAN("mean", "arithmetic mean", false),
    MEDIAN("median", "median sample value", false),
    APPROX_MEDIAN("approx. median", "approximate median (remedian algorithm)", true),
    MIN("min", "minimum value", true),
    MAX("max", "maximum value", true),
    RANGE("range", "sample range", true),
    SDEV("sdev", "sample standard deviation", false),
    SUM("sum", "sum of valid values", true),
    VARIANCE("variance", "sample variance", false);

    private static final Map<String, Statistic> lookup;
    private String name;
    private String desc;
    private boolean supportsIntResult;

    private Statistic(String name, String desc, boolean supportsIntResult) {
        this.name = name;
        this.desc = desc;
        this.supportsIntResult = supportsIntResult;
    }

    public String toString() {
        return this.name;
    }

    public String getDescription() {
        return this.desc;
    }

    public boolean supportsIntegralResult() {
        return this.supportsIntResult;
    }

    public static Statistic get(String name) {
        return lookup.get(name.toLowerCase());
    }

    static {
        lookup = new HashMap<String, Statistic>();
        for (Statistic stat : Statistic.values()) {
            lookup.put(stat.name, stat);
        }
    }
}

