/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.tiledimage;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderableImage;
import java.lang.reflect.Method;
import java.text.AttributedCharacterIterator;
import java.util.Hashtable;
import java.util.Map;
import javax.media.jai.PlanarImage;
import org.jaitools.tiledimage.DiskMemImage;

public class DiskMemImageGraphics
extends Graphics2D {
    private DiskMemImage targetImage;
    private ColorModel colorModel;
    private Hashtable<String, Object> properties;
    private RenderingHints renderingHints;
    private Point origin;
    private Shape compClip;
    private Shape devClip;
    private Shape usrClip;
    private Color color;
    private Font font;
    private PaintMode paintMode;
    private Color XORColor;
    private Color background;
    private Composite composite;
    private Paint paint;
    private Stroke stroke;
    private AffineTransform transform;

    DiskMemImageGraphics(DiskMemImage targetImage) {
        this.targetImage = targetImage;
        this.renderingHints = new RenderingHints(null);
        this.setColorModel();
        this.setProperties();
        this.setGraphicsParams();
    }

    @Override
    public void draw(Shape s2) {
        this.doDraw(OpType.DRAW_SHAPE, this.correctForStroke(s2.getBounds2D()), s2);
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        Rectangle bounds = new Rectangle(0, 0, img.getWidth(obs), img.getHeight(obs));
        Rectangle2D trBounds = xform.createTransformedShape(bounds).getBounds2D();
        return this.doDraw(OpType.DRAW_IMAGE_TRANSFORM, trBounds, img, xform, obs);
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        Rectangle2D bounds = op.getBounds2D(img);
        this.doDraw(OpType.DRAW_BUFFERED_IMAGE, bounds, img, op, x, y);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        Rectangle bounds = new Rectangle(img.getMinX(), img.getMinY(), img.getWidth(), img.getHeight());
        Rectangle2D trBounds = xform.createTransformedShape(bounds).getBounds2D();
        this.doDraw(OpType.DRAW_RENDERED_IMAGE, trBounds, img, xform);
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        Rectangle2D.Float bounds = new Rectangle2D.Float(img.getMinX(), img.getMinY(), img.getWidth(), img.getHeight());
        Rectangle2D trBounds = xform.createTransformedShape(bounds).getBounds2D();
        this.doDraw(OpType.DRAW_RENDERABLE_IMAGE, trBounds, img, xform);
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.drawString(str, (float)x, (float)y);
    }

    @Override
    public void drawString(String str, float x, float y) {
        Rectangle2D bounds = this.getFontMetrics().getStringBounds(str, this);
        bounds.setRect(x, (double)y - bounds.getHeight() + 1.0, bounds.getWidth(), bounds.getHeight());
        this.doDraw(OpType.DRAW_STRING_XY, bounds, str, Float.valueOf(x), Float.valueOf(y));
    }

    @Override
    public void drawString(AttributedCharacterIterator iter, int x, int y) {
        this.drawString(iter, (float)x, (float)y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iter, float x, float y) {
        Rectangle2D bounds = this.getFontMetrics().getStringBounds(iter, iter.getBeginIndex(), iter.getEndIndex(), (Graphics)this);
        bounds.setRect(x, (double)y - bounds.getHeight() + 1.0, bounds.getWidth(), bounds.getHeight());
        this.doDraw(OpType.DRAW_STRING_ITER_XY, bounds, iter, Float.valueOf(x), Float.valueOf(y));
    }

    @Override
    public void drawGlyphVector(GlyphVector g2, float x, float y) {
        Rectangle2D bounds = g2.getVisualBounds();
        bounds.setFrame(bounds.getMinX() - 1.0, bounds.getMinY() - 1.0, bounds.getWidth() + 2.0, bounds.getHeight() + 2.0);
        this.doDraw(OpType.DRAW_GLYPH_VECTOR, bounds, g2, Float.valueOf(x), Float.valueOf(y));
    }

    @Override
    public void fill(Shape s2) {
        this.doDraw(OpType.FILL, s2.getBounds2D(), s2);
    }

    @Override
    public boolean hit(Rectangle rect, Shape s2, boolean onStroke) {
        Graphics2D gr = this.getProxy();
        this.copyGraphicsParams(gr);
        boolean rtnVal = gr.hit(rect, s2, onStroke);
        gr.dispose();
        return rtnVal;
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        Graphics2D gr = this.getProxy();
        this.copyGraphicsParams(gr);
        GraphicsConfiguration gc = gr.getDeviceConfiguration();
        gr.dispose();
        return gc;
    }

    @Override
    public void setComposite(Composite comp) {
        this.composite = comp;
    }

    @Override
    public void setPaint(Paint p) {
        this.paint = p;
    }

    @Override
    public void setStroke(Stroke s2) {
        this.stroke = s2;
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.renderingHints.put(hintKey, hintValue);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.renderingHints.get(hintKey);
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.renderingHints = new RenderingHints(null);
        this.renderingHints.putAll(hints);
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this.renderingHints.putAll(hints);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    @Override
    public void translate(int x, int y) {
        this.origin.setLocation(x, y);
        this.transform.translate(x, y);
    }

    @Override
    public void translate(double tx, double ty) {
        this.transform.translate(tx, ty);
    }

    @Override
    public void rotate(double theta) {
        this.transform.rotate(theta);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.transform.rotate(theta, x, y);
    }

    @Override
    public void scale(double sx, double sy) {
        this.transform.scale(sx, sy);
    }

    @Override
    public void shear(double shx, double shy) {
        this.transform.shear(shx, shy);
    }

    @Override
    public void transform(AffineTransform Tx) {
        this.transform.concatenate(Tx);
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        this.transform = Tx;
    }

    @Override
    public AffineTransform getTransform() {
        return this.transform;
    }

    @Override
    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public Composite getComposite() {
        return this.composite;
    }

    @Override
    public void setBackground(Color color) {
        this.background = color;
    }

    @Override
    public Color getBackground() {
        return this.background;
    }

    @Override
    public Stroke getStroke() {
        return this.stroke;
    }

    @Override
    public void clip(Shape s2) {
        if (s2 != null) {
            s2 = this.transformShape(s2);
            if (this.usrClip != null) {
                Area a1 = this.usrClip instanceof Area ? (Area)this.usrClip : new Area(this.usrClip);
                Area a2 = s2 instanceof Area ? (Area)s2 : new Area(s2);
                a2.intersect(a1);
                s2 = a2;
            }
        }
        this.usrClip = s2;
        this.validateCompClip();
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        Graphics2D gr = this.getProxy();
        this.copyGraphicsParams(gr);
        FontRenderContext frc = gr.getFontRenderContext();
        gr.dispose();
        return frc;
    }

    @Override
    public Graphics create() {
        DiskMemImageGraphics gr = new DiskMemImageGraphics(this.targetImage);
        this.copyGraphicsParams(gr);
        return gr;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color c2) {
        this.color = c2;
    }

    @Override
    public void setPaintMode() {
        this.paintMode = PaintMode.PAINT;
    }

    @Override
    public void setXORMode(Color color) {
        this.paintMode = PaintMode.XOR;
        this.XORColor = color;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFont(Font font) {
        if (font != null) {
            this.font = font;
        }
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        Graphics2D gr = this.getProxy();
        this.copyGraphicsParams(gr);
        FontMetrics fm = gr.getFontMetrics(f);
        gr.dispose();
        return fm;
    }

    @Override
    public Rectangle getClipBounds() {
        Shape s2 = this.getClip();
        return s2 == null ? null : s2.getBounds();
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.clip(new Rectangle(x, y, width, height));
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.setClip(new Rectangle(x, y, width, height));
    }

    @Override
    public Shape getClip() {
        return this.untransformShape(this.usrClip);
    }

    @Override
    public void setClip(Shape clip) {
        this.usrClip = clip;
        this.validateCompClip();
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.doDraw(OpType.COPY_AREA, new Rectangle(x + dx, y + dy, width, height), x, y, width, height, dx, dy);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        Rectangle bounds = new Rectangle();
        bounds.setFrameFromDiagonal(x1, y1, x2, y2);
        this.doDraw(OpType.DRAW_LINE, this.correctForStroke(bounds), x1, y1, x2, y2);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.doDraw(OpType.FILL_RECT, new Rectangle(x, y, width, height), x, y, width, height);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        this.doDraw(OpType.CLEAR_RECT, new Rectangle(x, y, width, height), x, y, width, height);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        Rectangle bounds = new Rectangle(x - arcWidth, y - arcHeight, width + 2 * arcWidth, height + 2 * arcHeight);
        this.doDraw(OpType.DRAW_ROUND_RECT, this.correctForStroke(bounds), x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        Rectangle bounds = new Rectangle(x - arcWidth, y - arcHeight, width + 2 * arcWidth, height + 2 * arcHeight);
        this.doDraw(OpType.FILL_ROUND_RECT, bounds, x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        Rectangle bounds = new Rectangle(x, y, width, height);
        this.doDraw(OpType.DRAW_OVAL, this.correctForStroke(bounds), x, y, width, height);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        Rectangle bounds = new Rectangle(x, y, width, height);
        this.doDraw(OpType.FILL_OVAL, bounds, x, y, width, height);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        Rectangle bounds = new Rectangle(x, y, width, height);
        this.doDraw(OpType.DRAW_ARC, this.correctForStroke(bounds), x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        Rectangle bounds = new Rectangle(x, y, width, height);
        this.doDraw(OpType.FILL_ARC, bounds, x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.doDraw(OpType.DRAW_POLYLINE, this.correctForStroke(this.getPolyBounds(xPoints, yPoints, nPoints)), xPoints, yPoints, nPoints);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.doDraw(OpType.DRAW_POLYGON, this.correctForStroke(this.getPolyBounds(xPoints, yPoints, nPoints)), xPoints, yPoints, nPoints);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.doDraw(OpType.FILL_POLYGON, this.getPolyBounds(xPoints, yPoints, nPoints), xPoints, yPoints, nPoints);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver obs) {
        Rectangle bounds = new Rectangle(x, y, img.getWidth(obs), img.getHeight(obs));
        return this.doDraw(OpType.DRAW_IMAGE_XY, bounds, img, x, y, obs);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver obs) {
        Rectangle bounds = new Rectangle(x, y, width, height);
        return this.doDraw(OpType.DRAW_IMAGE_XYWH, bounds, img, x, y, width, height, obs);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver obs) {
        Rectangle bounds = new Rectangle(x, y, img.getWidth(obs), img.getHeight(obs));
        return this.doDraw(OpType.DRAW_IMAGE_XY_COL, bounds, img, x, y, bgcolor, obs);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver obs) {
        Rectangle bounds = new Rectangle(x, y, width, height);
        return this.doDraw(OpType.DRAW_IMAGE_XYWH_COL, bounds, img, x, y, width, height, bgcolor, obs);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver obs) {
        Rectangle bounds = new Rectangle(dx1, dy1, dx2 - dx1 + 1, dy2 - dy1 + 1);
        return this.doDraw(OpType.DRAW_IMAGE_DEST_SRC, bounds, img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, obs);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver obs) {
        Rectangle bounds = new Rectangle(dx1, dy1, dx2 - dx1 + 1, dy2 - dy1 + 1);
        return this.doDraw(OpType.DRAW_IMAGE_DEST_SRC_COL, bounds, img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, obs);
    }

    @Override
    public void dispose() {
    }

    private Shape transformShape(Shape s2) {
        if (s2 == null) {
            return null;
        }
        if (this.transform == null) {
            return s2;
        }
        return this.transform.createTransformedShape(s2);
    }

    private Shape untransformShape(Shape s2) {
        if (s2 == null) {
            return null;
        }
        if (this.transform == null) {
            return s2;
        }
        try {
            return this.transform.createInverse().createTransformedShape(s2);
        }
        catch (NoninvertibleTransformException e2) {
            return null;
        }
    }

    private void validateCompClip() {
        if (this.usrClip == null) {
            this.compClip = this.devClip;
        } else {
            Area a1 = new Area(this.devClip);
            Area a2 = this.usrClip instanceof Area ? (Area)this.usrClip : new Area(this.usrClip);
            a1.intersect(a2);
            this.compClip = a1;
        }
    }

    private boolean doDraw(OpType opType, Rectangle2D bounds, Object ... args) {
        Method method = null;
        boolean rtnVal = false;
        bounds = this.getTransform().createTransformedShape(bounds).getBounds();
        try {
            method = Graphics2D.class.getMethod(opType.getMethodName(), opType.getArgTypes());
        }
        catch (NoSuchMethodException nsmEx) {
            throw new RuntimeException("No such method: " + opType.getFullMethodName());
        }
        int minTileX = Math.max(this.targetImage.XToTileX((int)bounds.getMinX()), this.targetImage.getMinTileX());
        int maxTileX = Math.min(this.targetImage.XToTileX((int)(bounds.getMaxX() + 0.5)), this.targetImage.getMaxTileX());
        int minTileY = Math.max(this.targetImage.YToTileY((int)bounds.getMinY()), this.targetImage.getMinTileY());
        int maxTileY = Math.min(this.targetImage.YToTileY((int)(bounds.getMaxY() + 0.5)), this.targetImage.getMaxTileY());
        for (int tileY = minTileY; tileY <= maxTileY; ++tileY) {
            int minY = this.targetImage.tileYToY(tileY);
            for (int tileX = minTileX; tileX <= maxTileX; ++tileX) {
                int minX = this.targetImage.tileXToX(tileX);
                WritableRaster tile = this.targetImage.getWritableTile(tileX, tileY);
                WritableRaster copy = tile.createWritableTranslatedChild(0, 0);
                BufferedImage bufImg = new BufferedImage(this.colorModel, copy, this.colorModel.isAlphaPremultiplied(), this.properties);
                Graphics2D gr = bufImg.createGraphics();
                this.copyGraphicsParams(gr, new Point(minX, minY));
                try {
                    Point2D p2d = gr.getTransform().transform(new Point2D.Double(0.0, 0.0), null);
                    Point p = new Point((int)p2d.getX() - minX, (int)p2d.getY() - minY);
                    p2d = gr.getTransform().inverseTransform(p, null);
                    gr.translate(p2d.getX(), p2d.getY());
                }
                catch (NoninvertibleTransformException nte) {
                    throw new RuntimeException(nte);
                }
                try {
                    Object oRtnVal = method.invoke((Object)gr, args);
                    if (oRtnVal != null && oRtnVal.getClass() == Boolean.TYPE) {
                        rtnVal = (Boolean)oRtnVal;
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                gr.dispose();
                this.targetImage.releaseWritableTile(tileX, tileY);
            }
        }
        return rtnVal;
    }

    private Rectangle2D correctForStroke(Rectangle2D rect) {
        if (this.stroke != null) {
            Shape shp = this.stroke.createStrokedShape(rect);
            return shp.getBounds2D();
        }
        return rect;
    }

    private Rectangle2D getPolyBounds(int[] xPoints, int[] yPoints, int nPoints) {
        Rectangle bounds = new Rectangle();
        if (nPoints > 0) {
            int minY;
            int minX;
            int maxX = minX = xPoints[0];
            int maxY = minY = yPoints[0];
            for (int i = 1; i < nPoints; ++i) {
                if (xPoints[i] < minX) {
                    minX = xPoints[i];
                } else if (xPoints[i] > maxX) {
                    maxX = xPoints[i];
                }
                if (yPoints[i] < minY) {
                    minY = yPoints[i];
                    continue;
                }
                if (yPoints[i] <= maxY) continue;
                maxY = yPoints[i];
            }
            bounds.setBounds(minX, minY, maxX - minX + 1, maxY - minY + 1);
        }
        return bounds;
    }

    private void setColorModel() {
        assert (this.targetImage != null);
        this.colorModel = this.targetImage.getColorModel();
        if (this.colorModel == null) {
            SampleModel sm = this.targetImage.getSampleModel();
            this.colorModel = PlanarImage.createColorModel(sm);
            if (this.colorModel == null) {
                if (ColorModel.getRGBdefault().isCompatibleSampleModel(sm)) {
                    this.colorModel = ColorModel.getRGBdefault();
                } else {
                    throw new UnsupportedOperationException("Failed to get or construct a ColorModel for the image");
                }
            }
        }
    }

    private void setProperties() {
        assert (this.targetImage != null);
        this.properties = new Hashtable();
        String[] propertyNames = this.targetImage.getPropertyNames();
        if (propertyNames != null) {
            for (String name : propertyNames) {
                this.properties.put(name, this.targetImage.getProperty(name));
            }
        }
    }

    private void setGraphicsParams() {
        assert (this.targetImage != null);
        assert (this.colorModel != null);
        assert (this.properties != null);
        Graphics2D gr = this.getProxy();
        this.origin = new Point(0, 0);
        this.devClip = this.targetImage.getBounds();
        this.usrClip = null;
        this.compClip = null;
        this.validateCompClip();
        this.color = gr.getColor();
        this.font = gr.getFont();
        this.paintMode = PaintMode.PAINT;
        this.XORColor = null;
        this.background = gr.getBackground();
        this.composite = gr.getComposite();
        this.paint = null;
        this.stroke = gr.getStroke();
        this.transform = gr.getTransform();
        gr.dispose();
    }

    private void copyGraphicsParams(Graphics2D gr) {
        this.copyGraphicsParams(gr, null);
    }

    private void copyGraphicsParams(Graphics2D gr, Point workingOrigin) {
        gr.translate(this.origin.x, this.origin.y);
        gr.setColor(this.getColor());
        if (workingOrigin == null) {
            gr.setClip(this.compClip);
        } else {
            AffineTransform tr = AffineTransform.getTranslateInstance(-workingOrigin.x, -workingOrigin.y);
            Shape trclip = tr.createTransformedShape(this.compClip);
            gr.setClip(trclip);
        }
        if (this.paintMode == PaintMode.PAINT) {
            gr.setPaintMode();
        } else if (this.XORColor != null) {
            gr.setXORMode(this.XORColor);
        }
        gr.setFont(this.font);
        gr.setBackground(this.background);
        gr.setComposite(this.composite);
        if (this.paint != null) {
            gr.setPaint(this.paint);
        }
        if (this.renderingHints != null) {
            gr.setRenderingHints(this.renderingHints);
        }
        gr.setStroke(this.stroke);
        gr.setTransform(new AffineTransform(this.transform));
    }

    private Graphics2D getProxy() {
        Raster tile = this.targetImage.getTile(this.targetImage.getMinTileX(), this.targetImage.getMinTileY());
        WritableRaster tiny = tile.createCompatibleWritableRaster(1, 1);
        BufferedImage img = new BufferedImage(this.colorModel, tiny, this.colorModel.isAlphaPremultiplied(), this.properties);
        return img.createGraphics();
    }

    public static enum OpType {
        CLEAR_RECT("clearRect", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE),
        COPY_AREA("copyArea", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE),
        DRAW_ARC("drawArc", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE),
        DRAW_BUFFERED_IMAGE("drawImage", BufferedImage.class, BufferedImageOp.class, Integer.TYPE, Integer.TYPE),
        DRAW_GLYPH_VECTOR("drawGlyphVector", GlyphVector.class, Float.TYPE, Float.TYPE),
        DRAW_IMAGE_DEST_SRC("drawImage", Image.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, ImageObserver.class),
        DRAW_IMAGE_DEST_SRC_COL("drawImage", Image.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Color.class, ImageObserver.class),
        DRAW_IMAGE_TRANSFORM("drawImage", Image.class, AffineTransform.class, ImageObserver.class),
        DRAW_IMAGE_XY("drawImage", Image.class, Integer.TYPE, Integer.TYPE, ImageObserver.class),
        DRAW_IMAGE_XY_COL("drawImage", Image.class, Integer.TYPE, Integer.TYPE, Color.class, ImageObserver.class),
        DRAW_IMAGE_XYWH("drawImage", Image.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, ImageObserver.class),
        DRAW_IMAGE_XYWH_COL("drawImage", Image.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Color.class, ImageObserver.class),
        DRAW_LINE("drawLine", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE),
        DRAW_OVAL("drawOval", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE),
        DRAW_POLYGON("drawPolygon", int[].class, int[].class, Integer.TYPE),
        DRAW_POLYLINE("drawPolyline", int[].class, int[].class, Integer.TYPE),
        DRAW_RENDERABLE_IMAGE("drawRenderableImage", RenderableImage.class, AffineTransform.class),
        DRAW_RENDERED_IMAGE("drawRenderedImage", RenderedImage.class, AffineTransform.class),
        DRAW_ROUND_RECT("drawRoundRect", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE),
        DRAW_SHAPE("draw", Shape.class),
        DRAW_STRING_XY("drawString", String.class, Float.TYPE, Float.TYPE),
        DRAW_STRING_ITER_XY("drawString", AttributedCharacterIterator.class, Float.TYPE, Float.TYPE),
        FILL("fill", Shape.class),
        FILL_ARC("fillArc", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE),
        FILL_OVAL("fillOval", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE),
        FILL_POLYGON("fillPolygon", int[].class, int[].class, Integer.TYPE),
        FILL_RECT("fillRect", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE),
        FILL_ROUND_RECT("fillRoundRect", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);

        private String methodName;
        private Class<?>[] paramTypes;

        private OpType(String methodName, Class<?> ... types) {
            this.methodName = methodName;
            this.paramTypes = new Class[types.length];
            System.arraycopy(types, 0, this.paramTypes, 0, types.length);
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String getFullMethodName() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.methodName);
            sb.append("(");
            if (this.paramTypes.length > 0) {
                sb.append(this.paramTypes[0].getSimpleName());
                for (int i = 1; i < this.paramTypes.length; ++i) {
                    sb.append(", ");
                    sb.append(this.paramTypes[i].getSimpleName());
                }
            }
            sb.append(")");
            return sb.toString();
        }

        public int getNumArgs() {
            return this.paramTypes.length;
        }

        public Class<?>[] getArgTypes() {
            Class[] copy = new Class[this.paramTypes.length];
            System.arraycopy(this.paramTypes, 0, copy, 0, this.paramTypes.length);
            return copy;
        }
    }

    public static enum PaintMode {
        PAINT,
        XOR;

    }
}

