/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYSeries;

public class CSVExporter {
    public static void writeCSVRows(XYChart chart, String path2Dir) {
        for (XYSeries xySeries : chart.getSeriesMap().values()) {
            CSVExporter.writeCSVRows(xySeries, path2Dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeCSVRows(XYSeries series, String path2Dir) {
        File newFile = new File(path2Dir + series.getName() + ".csv");
        Writer out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(newFile), "UTF8"));
            String csv = CSVExporter.join(series.getXData(), ",") + System.getProperty("line.separator");
            out.write(csv);
            csv = CSVExporter.join(series.getYData(), ",") + System.getProperty("line.separator");
            out.write(csv);
            if (series.getExtraValues() != null) {
                csv = CSVExporter.join(series.getExtraValues(), ",") + System.getProperty("line.separator");
                out.write(csv);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String join(double[] seriesData, String separator) {
        StringBuilder sb = new StringBuilder(256);
        sb.append(seriesData[0]);
        for (int i = 1; i < seriesData.length; ++i) {
            if (separator != null) {
                sb.append(separator);
            }
            sb.append(seriesData[i]);
        }
        return sb.toString();
    }

    public static void writeCSVColumns(XYChart chart, String path2Dir) {
        for (XYSeries xySeries : chart.getSeriesMap().values()) {
            CSVExporter.writeCSVColumns(xySeries, path2Dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeCSVColumns(XYSeries series, String path2Dir) {
        File newFile = new File(path2Dir + series.getName() + ".csv");
        Writer out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(newFile), "UTF8"));
            double[] xData = series.getXData();
            double[] yData = series.getYData();
            double[] errorBarData = series.getExtraValues();
            for (int i = 0; i < xData.length; ++i) {
                StringBuilder sb = new StringBuilder();
                sb.append(xData[i]).append(",");
                sb.append(yData[i]).append(",");
                if (errorBarData != null) {
                    sb.append(errorBarData[i]).append(",");
                }
                sb.setLength(sb.length() - 1);
                sb.append(System.getProperty("line.separator"));
                out.write(sb.toString());
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

