/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.dissolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import org.locationtech.jts.dissolve.DissolveEdgeGraph;
import org.locationtech.jts.dissolve.DissolveHalfEdge;
import org.locationtech.jts.edgegraph.HalfEdge;
import org.locationtech.jts.edgegraph.MarkHalfEdge;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;

public class LineDissolver {
    private Geometry result;
    private GeometryFactory factory;
    private DissolveEdgeGraph graph;
    private List lines = new ArrayList();
    private Stack nodeEdgeStack = new Stack();
    private DissolveHalfEdge ringStartEdge;

    public static Geometry dissolve(Geometry g2) {
        LineDissolver d2 = new LineDissolver();
        d2.add(g2);
        return d2.getResult();
    }

    public LineDissolver() {
        this.graph = new DissolveEdgeGraph();
    }

    public void add(Geometry geometry) {
        geometry.apply(new GeometryComponentFilter(){

            @Override
            public void filter(Geometry component) {
                if (component instanceof LineString) {
                    LineDissolver.this.add((LineString)component);
                }
            }
        });
    }

    public void add(Collection geometries) {
        for (Geometry geometry : geometries) {
            this.add(geometry);
        }
    }

    private void add(LineString lineString) {
        if (this.factory == null) {
            this.factory = lineString.getFactory();
        }
        CoordinateSequence seq = lineString.getCoordinateSequence();
        boolean doneStart = false;
        for (int i = 1; i < seq.size(); ++i) {
            DissolveHalfEdge e2 = (DissolveHalfEdge)this.graph.addEdge(seq.getCoordinate(i - 1), seq.getCoordinate(i));
            if (e2 == null || doneStart) continue;
            e2.setStart();
            doneStart = true;
        }
    }

    public Geometry getResult() {
        if (this.result == null) {
            this.computeResult();
        }
        return this.result;
    }

    private void computeResult() {
        Collection edges = this.graph.getVertexEdges();
        for (HalfEdge e2 : edges) {
            if (MarkHalfEdge.isMarked(e2)) continue;
            this.process(e2);
        }
        this.result = this.factory.buildGeometry(this.lines);
    }

    private void process(HalfEdge e2) {
        HalfEdge eNode = e2.prevNode();
        if (eNode == null) {
            eNode = e2;
        }
        this.stackEdges(eNode);
        this.buildLines();
    }

    private void buildLines() {
        while (!this.nodeEdgeStack.empty()) {
            HalfEdge e2 = (HalfEdge)this.nodeEdgeStack.pop();
            if (MarkHalfEdge.isMarked(e2)) continue;
            this.buildLine(e2);
        }
    }

    private void updateRingStartEdge(DissolveHalfEdge e2) {
        if (!e2.isStart() && !(e2 = (DissolveHalfEdge)e2.sym()).isStart()) {
            return;
        }
        if (this.ringStartEdge == null) {
            this.ringStartEdge = e2;
            return;
        }
        if (e2.orig().compareTo(this.ringStartEdge.orig()) < 0) {
            this.ringStartEdge = e2;
        }
    }

    private void buildLine(HalfEdge eStart) {
        CoordinateList line = new CoordinateList();
        DissolveHalfEdge e2 = (DissolveHalfEdge)eStart;
        this.ringStartEdge = null;
        MarkHalfEdge.markBoth(e2);
        line.add(e2.orig().copy(), false);
        while (e2.sym().degree() == 2) {
            this.updateRingStartEdge(e2);
            DissolveHalfEdge eNext = (DissolveHalfEdge)e2.next();
            if (eNext == eStart) {
                this.buildRing(this.ringStartEdge);
                return;
            }
            line.add(eNext.orig().copy(), false);
            e2 = eNext;
            MarkHalfEdge.markBoth(e2);
        }
        line.add(e2.dest().clone(), false);
        this.stackEdges(e2.sym());
        this.addLine(line);
    }

    private void buildRing(HalfEdge eStartRing) {
        HalfEdge eNext;
        CoordinateList line = new CoordinateList();
        HalfEdge e2 = eStartRing;
        line.add(e2.orig().copy(), false);
        while (e2.sym().degree() == 2 && (eNext = e2.next()) != eStartRing) {
            line.add(eNext.orig().copy(), false);
            e2 = eNext;
        }
        line.add(e2.dest().copy(), false);
        this.addLine(line);
    }

    private void addLine(CoordinateList line) {
        this.lines.add(this.factory.createLineString(line.toCoordinateArray()));
    }

    private void stackEdges(HalfEdge node) {
        HalfEdge e2 = node;
        do {
            if (MarkHalfEdge.isMarked(e2)) continue;
            this.nodeEdgeStack.add(e2);
        } while ((e2 = e2.oNext()) != node);
    }
}

