/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.math;

public class Matrix {
    private static void swapRows(double[][] m3, int i, int j) {
        if (i == j) {
            return;
        }
        for (int col = 0; col < m3[0].length; ++col) {
            double temp = m3[i][col];
            m3[i][col] = m3[j][col];
            m3[j][col] = temp;
        }
    }

    private static void swapRows(double[] m3, int i, int j) {
        if (i == j) {
            return;
        }
        double temp = m3[i];
        m3[i] = m3[j];
        m3[j] = temp;
    }

    public static double[] solve(double[][] a2, double[] b2) {
        int n = b2.length;
        if (a2.length != n || a2[0].length != n) {
            throw new IllegalArgumentException("Matrix A is incorrectly sized");
        }
        for (int i = 0; i < n; ++i) {
            int j;
            int maxElementRow = i;
            for (j = i + 1; j < n; ++j) {
                if (!(Math.abs(a2[j][i]) > Math.abs(a2[maxElementRow][i]))) continue;
                maxElementRow = j;
            }
            if (a2[maxElementRow][i] == 0.0) {
                return null;
            }
            Matrix.swapRows(a2, i, maxElementRow);
            Matrix.swapRows(b2, i, maxElementRow);
            j = i + 1;
            while (j < n) {
                double rowFactor = a2[j][i] / a2[i][i];
                for (int k = n - 1; k >= i; --k) {
                    double[] dArray = a2[j];
                    int n2 = k;
                    dArray[n2] = dArray[n2] - a2[i][k] * rowFactor;
                }
                int n3 = j++;
                b2[n3] = b2[n3] - b2[i] * rowFactor;
            }
        }
        double[] solution = new double[n];
        for (int j = n - 1; j >= 0; --j) {
            double t = 0.0;
            for (int k = j + 1; k < n; ++k) {
                t += a2[j][k] * solution[k];
            }
            solution[j] = (b2[j] - t) / a2[j][j];
        }
        return solution;
    }
}

