/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.algorithm.Distance;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Triangle;
import org.locationtech.jts.geomgraph.Label;
import org.locationtech.jts.geomgraph.Position;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.operation.buffer.OffsetCurveBuilder;

public class OffsetCurveSetBuilder {
    private Geometry inputGeom;
    private double distance;
    private OffsetCurveBuilder curveBuilder;
    private List curveList = new ArrayList();

    public OffsetCurveSetBuilder(Geometry inputGeom, double distance, OffsetCurveBuilder curveBuilder) {
        this.inputGeom = inputGeom;
        this.distance = distance;
        this.curveBuilder = curveBuilder;
    }

    public List getCurves() {
        this.add(this.inputGeom);
        return this.curveList;
    }

    private void addCurve(Coordinate[] coord, int leftLoc, int rightLoc) {
        if (coord == null || coord.length < 2) {
            return;
        }
        NodedSegmentString e2 = new NodedSegmentString(coord, new Label(0, 1, leftLoc, rightLoc));
        this.curveList.add(e2);
    }

    private void add(Geometry g2) {
        if (g2.isEmpty()) {
            return;
        }
        if (g2 instanceof Polygon) {
            this.addPolygon((Polygon)g2);
        } else if (g2 instanceof LineString) {
            this.addLineString((LineString)g2);
        } else if (g2 instanceof Point) {
            this.addPoint((Point)g2);
        } else if (g2 instanceof MultiPoint) {
            this.addCollection((MultiPoint)g2);
        } else if (g2 instanceof MultiLineString) {
            this.addCollection((MultiLineString)g2);
        } else if (g2 instanceof MultiPolygon) {
            this.addCollection((MultiPolygon)g2);
        } else if (g2 instanceof GeometryCollection) {
            this.addCollection((GeometryCollection)g2);
        } else {
            throw new UnsupportedOperationException(g2.getClass().getName());
        }
    }

    private void addCollection(GeometryCollection gc) {
        for (int i = 0; i < gc.getNumGeometries(); ++i) {
            Geometry g2 = gc.getGeometryN(i);
            this.add(g2);
        }
    }

    private void addPoint(Point p) {
        if (this.distance <= 0.0) {
            return;
        }
        Coordinate[] coord = p.getCoordinates();
        Coordinate[] curve = this.curveBuilder.getLineCurve(coord, this.distance);
        this.addCurve(curve, 2, 0);
    }

    private void addLineString(LineString line) {
        if (this.curveBuilder.isLineOffsetEmpty(this.distance)) {
            return;
        }
        Coordinate[] coord = CoordinateArrays.removeRepeatedPoints(line.getCoordinates());
        if (CoordinateArrays.isRing(coord) && !this.curveBuilder.getBufferParameters().isSingleSided()) {
            this.addRingBothSides(coord, this.distance);
        } else {
            Coordinate[] curve = this.curveBuilder.getLineCurve(coord, this.distance);
            this.addCurve(curve, 2, 0);
        }
    }

    private void addPolygon(Polygon p) {
        double offsetDistance = this.distance;
        int offsetSide = 1;
        if (this.distance < 0.0) {
            offsetDistance = -this.distance;
            offsetSide = 2;
        }
        LinearRing shell = p.getExteriorRing();
        Coordinate[] shellCoord = CoordinateArrays.removeRepeatedPoints(shell.getCoordinates());
        if (this.distance < 0.0 && this.isErodedCompletely(shell, this.distance)) {
            return;
        }
        if (this.distance <= 0.0 && shellCoord.length < 3) {
            return;
        }
        this.addRingSide(shellCoord, offsetDistance, offsetSide, 2, 0);
        for (int i = 0; i < p.getNumInteriorRing(); ++i) {
            LinearRing hole = p.getInteriorRingN(i);
            Coordinate[] holeCoord = CoordinateArrays.removeRepeatedPoints(hole.getCoordinates());
            if (this.distance > 0.0 && this.isErodedCompletely(hole, -this.distance)) continue;
            this.addRingSide(holeCoord, offsetDistance, Position.opposite(offsetSide), 0, 2);
        }
    }

    private void addRingBothSides(Coordinate[] coord, double distance) {
        this.addRingSide(coord, distance, 1, 2, 0);
        this.addRingSide(coord, distance, 2, 0, 2);
    }

    private void addRingSide(Coordinate[] coord, double offsetDistance, int side, int cwLeftLoc, int cwRightLoc) {
        if (offsetDistance == 0.0 && coord.length < 4) {
            return;
        }
        int leftLoc = cwLeftLoc;
        int rightLoc = cwRightLoc;
        if (coord.length >= 4 && Orientation.isCCW(coord)) {
            leftLoc = cwRightLoc;
            rightLoc = cwLeftLoc;
            side = Position.opposite(side);
        }
        Coordinate[] curve = this.curveBuilder.getRingCurve(coord, side, offsetDistance);
        this.addCurve(curve, leftLoc, rightLoc);
    }

    private boolean isErodedCompletely(LinearRing ring, double bufferDistance) {
        Coordinate[] ringCoord = ring.getCoordinates();
        if (ringCoord.length < 4) {
            return bufferDistance < 0.0;
        }
        if (ringCoord.length == 4) {
            return this.isTriangleErodedCompletely(ringCoord, bufferDistance);
        }
        Envelope env = ring.getEnvelopeInternal();
        double envMinDimension = Math.min(env.getHeight(), env.getWidth());
        return bufferDistance < 0.0 && 2.0 * Math.abs(bufferDistance) > envMinDimension;
    }

    private boolean isTriangleErodedCompletely(Coordinate[] triangleCoord, double bufferDistance) {
        Triangle tri = new Triangle(triangleCoord[0], triangleCoord[1], triangleCoord[2]);
        Coordinate inCentre = tri.inCentre();
        double distToCentre = Distance.pointToSegment(inCentre, tri.p0, tri.p1);
        return distToCentre < Math.abs(bufferDistance);
    }
}

