/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.File;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import kafka.log.FileMessageSet;
import kafka.log.Log$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetIndex$;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.message.NoCompressionCodec$;
import kafka.tools.DumpLogSegments$;
import kafka.tools.DumpLogSegments$$anonfun$kafka$tools$DumpLogSegments$;
import kafka.utils.IteratorTemplate;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DumpLogSegments$
implements ScalaObject {
    public static final DumpLogSegments$ MODULE$;

    static {
        new DumpLogSegments$();
    }

    public void main(String[] args) {
        OptionParser parser = new OptionParser();
        OptionSpecBuilder printOpt = parser.accepts("print-data-log", "if set, printing the messages content when dumping data logs");
        OptionSpecBuilder verifyOpt = parser.accepts("verify-index-only", "if set, just verify the index log without printing its content");
        ArgumentAcceptingOptionSpec<String> filesOpt = parser.accepts("files", "REQUIRED: The comma separated list of data and index log files to be dumped").withRequiredArg().describedAs("file1, file2, ...").ofType(String.class);
        ArgumentAcceptingOptionSpec<Integer> maxMessageSizeOpt = parser.accepts("max-message-size", "Size of largest message.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(0x500000), (Integer[])((Object[])new Integer[0]));
        OptionSpecBuilder deepIterationOpt = parser.accepts("deep-iteration", "if set, uses deep instead of shallow iteration");
        OptionSet options = parser.parse(args);
        if (!options.has(filesOpt)) {
            System.err.println(new StringBuilder().append((Object)"Missing required argument \"").append(filesOpt).append((Object)"\"").toString());
            parser.printHelpOn(System.err);
            System.exit(1);
        }
        boolean print$1 = options.has(printOpt);
        boolean verifyOnly$1 = options.has(verifyOpt);
        String[] files = options.valueOf(filesOpt).split(",");
        int maxMessageSize$1 = options.valueOf(maxMessageSizeOpt);
        boolean isDeepIteration$1 = options.has(deepIterationOpt);
        HashMap misMatchesForIndexFilesMap$1 = new HashMap();
        HashMap nonConsecutivePairsForLogFilesMap$1 = new HashMap();
        Predef$.MODULE$.refArrayOps((Object[])files).foreach(new anonfun.main.1(print$1, verifyOnly$1, maxMessageSize$1, isDeepIteration$1, misMatchesForIndexFilesMap$1, nonConsecutivePairsForLogFilesMap$1));
        misMatchesForIndexFilesMap$1.foreach(new anonfun.main.2());
        nonConsecutivePairsForLogFilesMap$1.foreach(new anonfun.main.3());
    }

    public final void kafka$tools$DumpLogSegments$$dumpIndex(File file$2, boolean verifyOnly$2, HashMap misMatchesForIndexFilesMap$2, int maxMessageSize$2) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            Object object = new Object();
            try {
                long startOffset = Predef$.MODULE$.augmentString(file$2.getName().split("\\.")[0]).toLong();
                String logFileName = new StringBuilder().append((Object)file$2.getAbsolutePath().split("\\.")[0]).append((Object)Log$.MODULE$.LogFileSuffix()).toString();
                File logFile = new File(logFileName);
                FileMessageSet messageSet$1 = new FileMessageSet(logFile, false);
                OffsetIndex index$1 = new OffsetIndex(file$2, startOffset, OffsetIndex$.MODULE$.init$default$3());
                Predef$.MODULE$.intWrapper(0).until(index$1.entries()).foreach$mVc$sp(new anonfun$kafka$tools$DumpLogSegments$$dumpIndex$1(file$2, verifyOnly$2, misMatchesForIndexFilesMap$2, maxMessageSize$2, messageSet$1, index$1, object));
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                BoxedUnit cfr_ignored_0 = (BoxedUnit)nonLocalReturnControl2.value();
            }
            return;
        }
        throw nonLocalReturnControl2;
    }

    public final void kafka$tools$DumpLogSegments$$dumpLog(File file$1, boolean printContents$1, HashMap nonConsecutivePairsForLogFilesMap$2, boolean isDeepIteration$2) {
        long startOffset = Predef$.MODULE$.augmentString(file$1.getName().split("\\.")[0]).toLong();
        Predef$.MODULE$.println(new StringBuilder().append((Object)"Starting offset: ").append(BoxesRunTime.boxToLong(startOffset)).toString());
        FileMessageSet messageSet = new FileMessageSet(file$1, false);
        LongRef validBytes$1 = new LongRef(0L);
        LongRef lastOffset$1 = new LongRef(-1L);
        messageSet.foreach(new anonfun$kafka$tools$DumpLogSegments$$dumpLog$1(file$1, printContents$1, nonConsecutivePairsForLogFilesMap$2, isDeepIteration$2, validBytes$1, lastOffset$1));
        long trailingBytes = (long)messageSet.sizeInBytes() - validBytes$1.elem;
        if (trailingBytes > 0L) {
            Predef$.MODULE$.println(Predef$.MODULE$.augmentString("Found %d invalid bytes at the end of %s").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(trailingBytes), file$1.getName()})));
        }
    }

    public final Iterator kafka$tools$DumpLogSegments$$getIterator(MessageAndOffset messageAndOffset, boolean isDeepIteration) {
        Iterator<MessageAndOffset> iterator2;
        if (isDeepIteration) {
            Message message = messageAndOffset.message();
            CompressionCodec compressionCodec = message.compressionCodec();
            NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
            CompressionCodec compressionCodec2 = compressionCodec;
            iterator2 = !(noCompressionCodec$ != null ? !noCompressionCodec$.equals(compressionCodec2) : compressionCodec2 != null) ? this.getSingleMessageIterator(messageAndOffset) : ByteBufferMessageSet$.MODULE$.decompress(message).iterator();
        } else {
            iterator2 = this.getSingleMessageIterator(messageAndOffset);
        }
        return iterator2;
    }

    private IteratorTemplate<MessageAndOffset> getSingleMessageIterator(MessageAndOffset messageAndOffset$1) {
        return new anon.1(messageAndOffset$1);
    }

    private DumpLogSegments$() {
        MODULE$ = this;
    }
}

