/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.quality.functions;

import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.quality.AbstractQFSimpleStatisticBased;

public class RelativeGainQF
extends AbstractQFSimpleStatisticBased {
    private static final String ID = "RelativeGainQF";
    private static final String NAME = "Relative Gain";

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public double evaluateNum(double sgMean, double subgroupSize, double definedPopulationCount, double populationMean) {
        return Double.NaN;
    }

    @Override
    public AbstractQFSimpleStatisticBased clone() {
        return new RelativeGainQF();
    }

    @Override
    public boolean isApplicable(SG subgroup) {
        return subgroup.getTarget() != null && subgroup.getTarget().isBoolean();
    }

    @Override
    public double evaluateBin(double subgroupSize, double subgroupPositives, double definedPopulationCount, double populationPositives) {
        double p = subgroupPositives / subgroupSize;
        double p0 = populationPositives / definedPopulationCount;
        if (p0 == 1.0) {
            return p == 1.0 ? 0.0 : Double.NEGATIVE_INFINITY;
        }
        return (p - p0) / ((1.0 - p0) * p0);
    }
}

