/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class ProgressBarPopupUpdater {
    private static int capacity = 1;
    private static int currentProgress = 0;
    private static int relativeProgress = 0;

    public static void init(int capacity) {
        ProgressBarPopupUpdater.capacity = capacity;
        currentProgress = 0;
        relativeProgress = 0;
    }

    public static void init(File file) throws IOException {
        if (!file.toString().endsWith(".arff")) {
            throw new IOException("Please use this method only with ARFF files!");
        }
        BufferedReader buffy = new BufferedReader(new FileReader(file));
        String input = buffy.readLine();
        int attributeCount = 0;
        boolean foundOne = false;
        while (input != null) {
            if (input.toLowerCase().startsWith("@attribute")) {
                foundOne = true;
                ++attributeCount;
            } else if (foundOne) break;
            input = buffy.readLine();
        }
        ProgressBarPopupUpdater.init(attributeCount);
        buffy.close();
    }

    public static void updateProgress() {
        ProgressBarPopupUpdater.setRelativeProgress(++currentProgress * 100 / capacity);
    }

    public static void setRelativeProgress(int relativeProgress) {
        ProgressBarPopupUpdater.relativeProgress = relativeProgress;
    }

    public static int getRelativeProgress() {
        return relativeProgress;
    }
}

