/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.meta;

import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Instance;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import moa.classifiers.Classifier;
import moa.classifiers.core.statisticaltests.StatisticalTest;
import moa.classifiers.drift.SingleClassifierDrift;
import moa.core.MiscUtils;
import moa.options.ClassOption;

public class RCD
extends SingleClassifierDrift {
    private static final long serialVersionUID = 1L;
    public ClassOption statisticalTestOption = new ClassOption("statisticalTest", 'a', "Non-parametric multivariate statistical test to use.", StatisticalTest.class, "KNN");
    public FloatOption similarityBetweenDistributionsOption = new FloatOption("similarityBetweenDistributions", 's', "The minimum percentual similarity between distributions (p-value).", 0.01, 0.0, 1.0);
    public IntOption bufferSizeOption = new IntOption("bufferSize", 'b', "The size of the buffer that represents the distributions.", 400, 1, Integer.MAX_VALUE);
    public IntOption testFrequencyOption = new IntOption("testFrequency", 't', "In the testing phase, test for best stored classifier after how many instances.", 400, 1, Integer.MAX_VALUE);
    public IntOption classifiersSizeOption = new IntOption("classifiersSize", 'c', "The maximum amount of classifiers to store. 0 means unlimited.", 15, 0, Integer.MAX_VALUE);
    public IntOption threadSizeOption = new IntOption("threadSize", 'm', "The thread pool size, indicating how many simultaneous tests are allowed.", 4, 1, Integer.MAX_VALUE);
    public IntOption quantityClassifiersTestOption = new IntOption("quantityClassifiersTest", 'q', "Quantity of identified classifiers to check.", 1, 1, Integer.MAX_VALUE);
    private List<ClassifierKS> classifiers;
    protected List<Instance> currentChunk;
    protected List<Instance> currentChunk2;
    protected List<Instance> testChunk;
    protected int bufferSize;
    protected int previousState;
    protected int index;

    @Override
    public void resetLearningImpl() {
        super.resetLearningImpl();
        this.classifiers = new ArrayList<ClassifierKS>();
        this.bufferSize = this.bufferSizeOption.getValue();
        this.currentChunk = null;
        this.currentChunk2 = null;
        this.testChunk = null;
        this.previousState = Integer.MIN_VALUE;
        this.index = 0;
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        int trueClass = (int)inst.classValue();
        boolean prediction = MiscUtils.maxIndex(this.classifier.getVotesForInstance(inst)) == trueClass;
        this.driftDetectionMethod.input(prediction ? 0.0 : 1.0);
        this.ddmLevel = 0;
        if (this.driftDetectionMethod.getChange()) {
            this.ddmLevel = 2;
        }
        if (this.driftDetectionMethod.getWarningZone()) {
            this.ddmLevel = 1;
        }
        switch (this.ddmLevel) {
            case 1: {
                ++this.warningDetected;
                switch (this.previousState) {
                    case 0: {
                        this.newclassifier.resetLearning();
                        this.currentChunk2 = new ArrayList<Instance>();
                    }
                }
                this.newclassifier.trainOnInstance(inst);
                this.addInstance(this.currentChunk2, inst);
                this.previousState = 1;
                break;
            }
            case 2: {
                ++this.changeDetected;
                switch (this.previousState) {
                    case 1: {
                        ClassifierKS cs = this.getPreviousClassifier(this.classifier, this.currentChunk2);
                        if (cs == null) {
                            this.classifier = this.newclassifier;
                            this.newclassifier = ((Classifier)this.getPreparedClassOption(this.baseLearnerOption)).copy();
                            this.classifiers.add(new ClassifierKS(this.classifier, this.currentChunk2));
                            this.currentChunk = this.currentChunk2;
                            int maxSize = this.classifiersSizeOption.getValue();
                            if (this.classifiers.size() > maxSize && maxSize > 0) {
                                this.classifiers.remove(0);
                            }
                        } else {
                            this.classifier = cs.getClassifier();
                            this.currentChunk = cs.getInstances();
                        }
                        this.currentChunk2 = null;
                        this.newclassifier.resetLearning();
                    }
                }
                this.previousState = 2;
                break;
            }
            case 0: {
                switch (this.previousState) {
                    case 0: 
                    case 2: {
                        break;
                    }
                    case 1: {
                        this.currentChunk2 = null;
                        break;
                    }
                    default: {
                        this.currentChunk = new ArrayList<Instance>();
                        this.classifiers.add(new ClassifierKS(this.classifier, this.currentChunk));
                    }
                }
                this.addInstance(this.currentChunk, inst);
                this.previousState = 0;
            }
        }
        this.classifier.trainOnInstance(inst);
    }

    private void addInstance(List<Instance> instances, Instance instance) {
        if (instances.size() >= this.bufferSize) {
            instances.remove(0);
        }
        instances.add(instance);
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        if (this.testChunk == null) {
            this.testChunk = new ArrayList<Instance>();
        }
        this.addInstance(this.testChunk, inst);
        if (this.index++ == this.testFrequencyOption.getValue()) {
            this.index = 0;
            ClassifierKS cs = this.getPreviousClassifier(this.classifier, this.testChunk);
            if (cs != null) {
                this.classifier = cs.getClassifier();
            }
        }
        return this.classifier.getVotesForInstance(inst);
    }

    private ClassifierKS getPreviousClassifier(Classifier classifier, List<Instance> instances) {
        ClassifierKS cs;
        ExecutorService threadPool = Executors.newFixedThreadPool(this.threadSizeOption.getValue());
        int SIZE = this.classifiers.size();
        HashMap<Integer, Future<Double>> futures = new HashMap<Integer, Future<Double>>();
        for (int i = 0; i < SIZE && (cs = this.classifiers.get(i)) != null; ++i) {
            if (cs.getClassifier() == classifier) continue;
            StatisticalTest st = (StatisticalTest)this.getPreparedClassOption(this.statisticalTestOption);
            StatisticalTest temp = (StatisticalTest)st.copy();
            temp.set(instances, cs.getInstances());
            futures.put(i, threadPool.submit(temp));
        }
        ClassifierKS cks = null;
        int qtd = this.quantityClassifiersTestOption.getValue();
        double maxPValue = this.similarityBetweenDistributionsOption.getValue();
        try {
            for (int i = 0; i < SIZE && qtd > 0; ++i) {
                double p;
                Future f = (Future)futures.get(i);
                if (f == null || !((p = ((Double)f.get()).doubleValue()) < maxPValue)) continue;
                maxPValue = p;
                cks = this.classifiers.get(i);
                --qtd;
            }
        }
        catch (InterruptedException e) {
            System.out.println("Processing interrupted.");
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Error computing statistical test.", e);
        }
        threadPool.shutdownNow();
        return cks;
    }

    private class ClassifierKS
    implements Serializable {
        private final Classifier classifier;
        private final List<Instance> instances;

        public ClassifierKS(Classifier classifier, List<Instance> instances) {
            this.classifier = classifier;
            this.instances = instances;
        }

        public Classifier getClassifier() {
            return this.classifier;
        }

        public List<Instance> getInstances() {
            return this.instances;
        }
    }
}

