CREATE OR REPLACE PROCEDURE timeseries.ts_insert()
AS $$
BEGIN
  INSERT INTO timeseries.catalog
  SELECT tmp_ts_updates.ts_key
  FROM tmp_ts_updates
  LEFT OUTER JOIN timeseries.catalog ON (timeseries.catalog.ts_key = tmp_ts_updates.ts_key)
  WHERE timeseries.catalog.ts_key IS NULL;
END ;
$$
LANGUAGE plpgsql ;


-- I guess this is preferred cause we don't need
-- DYNAMIC SQL here.
CREATE OR REPLACE PROCEDURE timeseries.ts_insert()
AS $$
LANGUAGE SQL
BEGIN
  INSERT INTO timeseries.catalog
  SELECT tmp_ts_updates.ts_key
  FROM tmp_ts_updates
  LEFT OUTER JOIN timeseries.catalog ON (timeseries.catalog.ts_key = tmp_ts_updates.ts_key)
  WHERE timeseries.catalog.ts_key IS NULL;
END 
$$;

INSERT INTO timeseries.timeseries_main (ts_data) VALUES ('{"frequency":12,"time":["1988-01-01","1988-02-01","1988-03-01","1988-04-01","1988-05-01","1988-06-01","1988-07-01","1988-08-01","1988-09-01","1988-10-01","1988-11-01","1988-12-01","1989-01-01","1989-02-01","1989-03-01","1989-04-01","1989-05-01","1989-06-01","1989-07-01","1989-08-01","1989-09-01","1989-10-01","1989-11-01","1989-12-01","1990-01-01","1990-02-01","1990-03-01","1990-04-01","1990-05-01","1990-06-01","1990-07-01","1990-08-01","1990-09-01","1990-10-01","1990-11-01","1990-12-01"],"value":[0.893485501874238,-0.688892364967614,-0.229749839287251,-0.922924874350429,0.124839254189283,-0.120733925141394,-0.624176191631705,0.0208369852043688,-0.608169273473322,-0.298081449232996,-0.189186305738986,0.227694534230977,0.967893334105611,-0.594695906620473,0.322527747135609,0.496914902701974,0.72737086750567,0.758888437412679,-0.744613007176667,0.377339070197195,-0.925579272676259,-0.484392250422388,0.989371605217457,0.172056411392987,0.804336180444807,-0.842539105098695,0.546138289850205,0.177073403261602,0.39682179549709,0.684014794416726,0.912440008018166,-0.0407210686244071,-0.00314307166263461,0.942819355987012,0.666346053592861,0.357420871965587]}')
