/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchmodel;

import dr.evolution.tree.NodeRef;
import dr.evomodel.branchmodel.BranchModel;
import dr.evomodel.substmodel.FrequencyModel;
import dr.evomodel.substmodel.SubstitutionModel;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Variable;
import java.util.LinkedHashMap;
import java.util.List;

public class RandomBranchAssignmentModel
extends AbstractModel
implements BranchModel {
    public static final boolean DEBUG = true;
    public static final String RANDOM_BRANCH_ASSIGNMENT_MODEL = "randomBranchAssignmentModel";
    private final TreeModel treeModel;
    private final List<SubstitutionModel> substitutionModels;
    private LinkedHashMap<NodeRef, Integer> branchAssignmentMap;

    public RandomBranchAssignmentModel(TreeModel treeModel, List<SubstitutionModel> list) {
        super(RANDOM_BRANCH_ASSIGNMENT_MODEL);
        this.treeModel = treeModel;
        this.substitutionModels = list;
        int n = treeModel.getNodeCount();
        int n2 = list.size();
        this.branchAssignmentMap = new LinkedHashMap();
        for (int i = 0; i < n; ++i) {
            NodeRef nodeRef = treeModel.getNode(i);
            int n3 = Integer.MAX_VALUE;
            n3 = nodeRef.toString().equalsIgnoreCase("node 0, height=0.0: SimSeq1") || nodeRef.toString().equalsIgnoreCase("node 1, height=0.0: SimSeq2") || nodeRef.toString().equalsIgnoreCase("node 4, height=22.0") ? 0 : 1;
            this.branchAssignmentMap.put(nodeRef, n3);
        }
    }

    @Override
    public BranchModel.Mapping getBranchModelMapping(NodeRef nodeRef) {
        final int n = this.branchAssignmentMap.get(nodeRef);
        return new BranchModel.Mapping(){

            @Override
            public int[] getOrder() {
                return new int[]{n};
            }

            @Override
            public double[] getWeights() {
                return new double[]{1.0};
            }
        };
    }

    @Override
    public List<SubstitutionModel> getSubstitutionModels() {
        return this.substitutionModels;
    }

    @Override
    public SubstitutionModel getRootSubstitutionModel() {
        int n = this.branchAssignmentMap.get(this.treeModel.getRoot());
        return this.substitutionModels.get(n);
    }

    @Override
    public FrequencyModel getRootFrequencyModel() {
        return this.getRootSubstitutionModel().getFrequencyModel();
    }

    @Override
    public boolean requiresMatrixConvolution() {
        return false;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.fireModelChanged();
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }
}

