/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchratemodel;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.branchratemodel.AbstractBranchRateModel;
import dr.evomodel.tree.TreeModel;
import dr.evomodel.tree.TreeParameterModel;
import dr.inference.distribution.ParametricDistributionModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.MathUtils;

public class ContinuousBranchRates
extends AbstractBranchRateModel {
    private final ParametricDistributionModel distributionModel;
    final TreeParameterModel rateCategoryQuantiles;
    private final double[] rates;
    private boolean normalize = false;
    private double normalizeBranchRateTo = Double.NaN;
    private double scaleFactor = 1.0;
    private TreeModel treeModel;
    private boolean updateScaleFactor = false;
    private boolean updateRates = true;

    public ContinuousBranchRates(TreeModel treeModel, Parameter parameter, ParametricDistributionModel parametricDistributionModel) {
        this(treeModel, parameter, parametricDistributionModel, false, Double.NaN);
    }

    public ContinuousBranchRates(TreeModel treeModel, Parameter parameter, ParametricDistributionModel parametricDistributionModel, boolean bl, double d) {
        super("continuousBranchRates");
        this.rateCategoryQuantiles = new TreeParameterModel(treeModel, parameter, false);
        this.rates = new double[treeModel.getNodeCount()];
        this.normalize = bl;
        this.treeModel = treeModel;
        this.distributionModel = parametricDistributionModel;
        this.normalizeBranchRateTo = d;
        Parameter.DefaultBounds defaultBounds = new Parameter.DefaultBounds(1.0, 0.0, parameter.getDimension());
        parameter.addBounds(defaultBounds);
        this.randomizeRates();
        this.addModel(parametricDistributionModel);
        this.addModel(this.rateCategoryQuantiles);
        if (bl) {
            this.addModel(this.treeModel);
            this.updateScaleFactor = true;
        }
        this.updateRates = true;
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.distributionModel) {
            this.updateRates = true;
            this.fireModelChanged();
        } else if (model == this.rateCategoryQuantiles) {
            this.updateRates = true;
            this.fireModelChanged(null, n);
        } else if (model == this.treeModel && this.normalize) {
            this.updateScaleFactor = true;
        }
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
        this.updateRates = true;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public double getBranchRate(Tree tree, NodeRef nodeRef) {
        assert (!tree.isRoot(nodeRef)) : "root node doesn't have a rate!";
        if (this.updateRates) {
            this.computeRates();
        }
        if (this.updateScaleFactor) {
            this.computeFactor();
        }
        return this.rates[nodeRef.getNumber()] * this.scaleFactor;
    }

    private void randomizeRates() {
        for (int i = 0; i < this.treeModel.getNodeCount(); ++i) {
            if (this.treeModel.isRoot(this.treeModel.getNode(i))) continue;
            double d = MathUtils.nextDouble();
            this.rateCategoryQuantiles.setNodeValue(this.treeModel, this.treeModel.getNode(i), d);
        }
        this.updateRates = false;
    }

    private void computeRates() {
        for (int i = 0; i < this.treeModel.getNodeCount(); ++i) {
            if (this.treeModel.isRoot(this.treeModel.getNode(i))) continue;
            this.rates[this.treeModel.getNode((int)i).getNumber()] = this.distributionModel.quantile(this.rateCategoryQuantiles.getNodeValue(this.treeModel, this.treeModel.getNode(i)));
        }
        this.updateRates = false;
    }

    private void computeFactor() {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.treeModel.getNodeCount(); ++i) {
            NodeRef nodeRef = this.treeModel.getNode(i);
            if (this.treeModel.isRoot(nodeRef)) continue;
            d2 += this.treeModel.getBranchLength(nodeRef);
        }
        this.scaleFactor = this.normalizeBranchRateTo / (d / d2);
        this.updateScaleFactor = false;
    }
}

