/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.basta;

import dr.evolution.alignment.SimpleAlignment;
import dr.evolution.alignment.SimpleSiteList;
import dr.evolution.datatype.DataType;
import dr.evolution.datatype.GeneralDataType;
import dr.evolution.datatype.Nucleotides;
import dr.evolution.io.NewickImporter;
import dr.evolution.sequence.Sequence;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.Date;
import dr.evolution.util.Taxa;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.evolution.util.Units;
import dr.evomodel.branchratemodel.DefaultBranchRateModel;
import dr.evomodel.coalescent.basta.StructuredCoalescentLikelihood;
import dr.evomodel.substmodel.FrequencyModel;
import dr.evomodel.substmodel.SVSComplexSubstitutionModel;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Parameter;
import dr.math.MathUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Logger;

public class BASTADensityTester {
    private static final String DEME = "deme";
    private static String[][] sequences = new String[][]{{"AB192965Japan2004", "AF071228Spain1997", "AF105975Portugal1995", "AF189018Indonesia2005"}, {"ATGTGGGATCCACTTCTAAATGAATTTCCTGAATCTGTTCACGGATTTCGTTGTATGTTAGCTATTAAATATTTGCAGTCCGTTGAGGAAACTTACGAGCCCAATACATTGGGCCACGATTTAATTAGGGATCTTATATCTGTTGTAAGGGCCCGTGACTATGTCGAAGCGACCAGGCGATATAATCATTTCCACGCCCGCCTCGAAGGTTCGCCGAAGGCTGAACTTCGACAGCCCATACAGCAGCCGTGCTGCTGTCCCCATTGTCCAAGGCACAA---ACAAGCGACGATCATGGACGTACAGGCCCATGTACCGGAAGCCCAGAATATACAGAATGTATCGAAGCCCTGATGTTCCTCGTGGATGTGAAGGCCCATGTAAAGTCCAGTCTTATGAGCAACGGGATGATATTAAGCATACTGGTATTGTTCGTTGTGTTAGTGATGTTACTCGTGGATCTGGAATTACTCACAGAGTGGGTAAGAGGTTCTGTGTTAAATCGATATATTTTTTAGGTAAAGTCTGGATGGATGAAAATATCAAGAAGCAGAATCACACTAATCAGGTCATGTTCTTCTTGGTTCGTGATAGAAGGCCCTATGGAAACAGCCCAATGGATTTTGGACAGGTTTTTAATATGTTCGATAATGAGCCCAGTACCGCAACTGTGAAGAATGATTTGCGGGATAGGTTTCAAGTGATGAGGAAATTTCATGCTACAGTTATTGGTGGGCCCTCTGGAATGAAGGAACAGGCATTAGTTAAGAGATTTTTTAGAATTAACAGTCATGTAACTT-----ATAATCAT-CAGGAGGCAGCCAAGTATGAGAACCATACTGAAAACGCCTTGTTATTGTATATGGCATGTACGCATGCCTCTAATCCAGTGTATGCAACTATGAAAATACGCATCTATTTCTATGATTCAATATCAAATTAA", "ATGTGGGATCCACTTCTAAATGAATTTCCTGAATCTGTTCACGGATTTCGTTGTATGTTAGCTATTAAATATTTGCAGTCCGTTGAGGAAACTTACGAGCCCAATACATTGGGCCACGATTTAATTAGGGATCTTATATCTGTTGTAAGGGCCCGTGACTATGTCGAAGCGACCAGGCGATATAATCATTTCCACGCCCGCCTCGAAGGTTCGCCGAAGGCTGAACTTCGACAGCCCATACAGCAGCCGTGCTGCTGTCCCCATTGTCCAAGGCACAA---ACAAGCGACGATCATGGACGTACAGGCCCATGTACCGGAAGCCCAGAATATACAGAATGTATCGAAGCACTGATGTTCCCCGTGGATGTGAAGGCCCATGTAAAGTACAGTCTTATGAGCAACGGGATGATATTAAGCATACTGGTATTGTTCGTTGTGTTAGTGATGTTACTCGTGGATCTGGAATTACTCACAGAGTGGGTAAGAGGTTCTGTGTTAAATCGATATATTTTTTAGGTAAAGTCTGGATGGATGAAAATATCAAGAAGCAGAACCACACTAATCAGGTCATGTTCTTCTTGGTCCGTGATAGAAGGCCCTATGGAAACAGCCCAATGGATTTTGGACAGGTTTTTAATATGTTCGATAATGAGCCCAGTACCGCAACAGTGAAGAATGATTTGCGGGATAGGTTTCAAGTGATGAGGAAATTTCATGCTACAGTTATTGGTGGGCCCTCTGGAATGAAGGAACAGGCATTAGTTAAGAGGTTTTTTAGAATTAACAGTCATGTAACTT-----ATAATCAT-CAGGAGGCAGCCAAGTACGAGAACCATACTGAAAACGCCTTGTTATTGTATATGGCATGTACGCATGCCTCTAATCCAGTGTATGCTACTATGAAAATACGCATCTATTTCTATGATTCAATATCAAATTAA", "ATGTGGGATCCACTTCTAAATGAATTTCCTGAATCTGTTCACGGATTTCGTTGTATGTTAGCTATTAAATATTTGCAGTCCGTTGAGGAAACTTACGAGCCCAATACATTGGGCCACGATTTAATTAGGGATCTTATATCTGTTGTAAGGGCCCGTGACTATGTCGAAGCGACCAGGCGATATAATCATTTCCACGCCCGCCTCGAAGGTTCGCCGAAGGCTGAACTTCGACAGCCCATACAGCAGCCGTGCTGCTGTCCCCATTGTCCAAGGCACAA---ACAAGCGACGATCATGGACGTACAGGCCCATGTACCGGAAGCCCAGAATATACAGAATGTATCGAAGCCCTGATGTTCCCCGTGGATGTGAAGGCCCATGTAAAGTACAGTCTTATGAGCAACGGGATGATATTAAGCATACTGGTATTGTTCGTTGTGTTAGTGATGTTACTCGTGGATCTGGAATTACTCACAGAGTGGGTAAGAGGTTCTGTGTTAAATCGATATATTTTTTAGGTAAAGTCTGGATGGATGAAAATATCAAGAAGCAGAATCACACTAATCAGGTCATGTTCTTCTTGGTCCGTGATAGAAGGCCCTATGGAAACAGCCCAATGGATTTTGGACAGGTTTTTAATATGTTCGATAATGAGCCCAGTACCGCAACAGTGAAGAATGATTTGCGGGATAGGTTTCAAGTGATGAGGAAATTTCATGCTACAGTTATTGGTGGGCCCTCTGGAATGAAGGAACAGGCATTAGTTAAGAGATTTTTTAGAATTAACAGTCATGTAACTT-----ATAATCAT-CAGGAGGCAGCCAAGTACGAGAACCATACTGAAAACGCCTTGTTATTGTATATGGCATGTACGCATGCCTCTAATCCAGTGTATGCAACTATGAAAATACGCATCTATTTCTATGATTCAATATCAAATTAA", "ATGTGGGATCCTCTTTTAAACGAATTTCCGGATTCTGTTCACGGTTTTCGGTGTATGCTCGCAATAAAGTATTTGCAAGGCGTTGAAGCAACCTACGCCCCTGATACTGTCGGTTACGACCTAGTTCGAGATCTGATCTCAGTTGTTCGTGCGAGCAATTATGCTGAAGCGTGCCGGAGATATAGCCTTTTCCGGTCCCGTATCGAAAGTACGCCGTCGTCTCAATTACGACAGCCCAGGTACCAGCCGTGCTGCTGTACTCACTGCCCTCGGCATAA---ATCGAAAGAAGTCTTGGACTTCTCGGCCTATGTACCGGAAGCCCAGGATTTACCGGATGTACCGAACAGCTGATGTCCCTAGGGGATGTGAAGGTCCTTGCAAGATTCAATCCTTTGAATCTCGACATGATATTGCTCACACCGGTAAGGTTATGTGTGTGACGGATGTTACTCGTGGCGGTGGTTTAACCCACCGTACTGGGAAGAGATTTTGCGTTAAGTCCCTCTATATCCTTGGCAAAATCTGGATGGATGAAAATATCAAGACTAAGAATCACACTAACACGGTCATGTTCTATGTTGTTCGGGATCGTAGACCCTATGGTA-C-TCCT-CAAGATTTTGGACAAGTGTTTAACATGTTCGATAACGAACCTAGCACTGCAACTGTCAAGAATGATCTTCGAGATCGGTTTCAAGTTTTGCGGAAGTTCACGGCAACTGTTGTTGGTGGTCAGTATGCTTGTAAGGAACAAACGTTAGTTAGGAAGTTCATGAGATTGAACAATTATGTTGTTT-----ACAACCAT-CAGGAAACCGCAAAATATGAGAATCATACAGAGAATGCTCTGTTATTGTACATGGCATCTACGCATGCCTCTAACCCTGTGTATGCAACTTTGAAAATTCGGATCTATTTTTATGATTCGATAACAAATTAA"}};
    private static String[][] sequencesTwo = new String[][]{{"AB192965Japan2004", "AF071228Spain1997", "AF105975Portugal1995", "AF189018Indonesia2005", "AJ842306France2004"}, {"ATGTGGGATCCACTTCTAAATGAATTTCCTGAATCTGTTCACGGATTTCGTTGTATGTTAGCTATTAAATATTTGCAGTCCGTTGAGGAAACTTACGAGCCCAATACATTGGGCCACGATTTAATTAGGGATCTTATATCTGTTGTAAGGGCCCGTGACTATGTCGAAGCGACCAGGCGATATAATCATTTCCACGCCCGCCTCGAAGGTTCGCCGAAGGCTGAACTTCGACAGCCCATACAGCAGCCGTGCTGCTGTCCCCATTGTCCAAGGCACAA---ACAAGCGACGATCATGGACGTACAGGCCCATGTACCGGAAGCCCAGAATATACAGAATGTATCGAAGCCCTGATGTTCCTCGTGGATGTGAAGGCCCATGTAAAGTCCAGTCTTATGAGCAACGGGATGATATTAAGCATACTGGTATTGTTCGTTGTGTTAGTGATGTTACTCGTGGATCTGGAATTACTCACAGAGTGGGTAAGAGGTTCTGTGTTAAATCGATATATTTTTTAGGTAAAGTCTGGATGGATGAAAATATCAAGAAGCAGAATCACACTAATCAGGTCATGTTCTTCTTGGTTCGTGATAGAAGGCCCTATGGAAACAGCCCAATGGATTTTGGACAGGTTTTTAATATGTTCGATAATGAGCCCAGTACCGCAACTGTGAAGAATGATTTGCGGGATAGGTTTCAAGTGATGAGGAAATTTCATGCTACAGTTATTGGTGGGCCCTCTGGAATGAAGGAACAGGCATTAGTTAAGAGATTTTTTAGAATTAACAGTCATGTAACTT-----ATAATCAT-CAGGAGGCAGCCAAGTATGAGAACCATACTGAAAACGCCTTGTTATTGTATATGGCATGTACGCATGCCTCTAATCCAGTGTATGCAACTATGAAAATACGCATCTATTTCTATGATTCAATATCAAATTAA", "ATGTGGGATCCACTTCTAAATGAATTTCCTGAATCTGTTCACGGATTTCGTTGTATGTTAGCTATTAAATATTTGCAGTCCGTTGAGGAAACTTACGAGCCCAATACATTGGGCCACGATTTAATTAGGGATCTTATATCTGTTGTAAGGGCCCGTGACTATGTCGAAGCGACCAGGCGATATAATCATTTCCACGCCCGCCTCGAAGGTTCGCCGAAGGCTGAACTTCGACAGCCCATACAGCAGCCGTGCTGCTGTCCCCATTGTCCAAGGCACAA---ACAAGCGACGATCATGGACGTACAGGCCCATGTACCGGAAGCCCAGAATATACAGAATGTATCGAAGCACTGATGTTCCCCGTGGATGTGAAGGCCCATGTAAAGTACAGTCTTATGAGCAACGGGATGATATTAAGCATACTGGTATTGTTCGTTGTGTTAGTGATGTTACTCGTGGATCTGGAATTACTCACAGAGTGGGTAAGAGGTTCTGTGTTAAATCGATATATTTTTTAGGTAAAGTCTGGATGGATGAAAATATCAAGAAGCAGAACCACACTAATCAGGTCATGTTCTTCTTGGTCCGTGATAGAAGGCCCTATGGAAACAGCCCAATGGATTTTGGACAGGTTTTTAATATGTTCGATAATGAGCCCAGTACCGCAACAGTGAAGAATGATTTGCGGGATAGGTTTCAAGTGATGAGGAAATTTCATGCTACAGTTATTGGTGGGCCCTCTGGAATGAAGGAACAGGCATTAGTTAAGAGGTTTTTTAGAATTAACAGTCATGTAACTT-----ATAATCAT-CAGGAGGCAGCCAAGTACGAGAACCATACTGAAAACGCCTTGTTATTGTATATGGCATGTACGCATGCCTCTAATCCAGTGTATGCTACTATGAAAATACGCATCTATTTCTATGATTCAATATCAAATTAA", "ATGTGGGATCCACTTCTAAATGAATTTCCTGAATCTGTTCACGGATTTCGTTGTATGTTAGCTATTAAATATTTGCAGTCCGTTGAGGAAACTTACGAGCCCAATACATTGGGCCACGATTTAATTAGGGATCTTATATCTGTTGTAAGGGCCCGTGACTATGTCGAAGCGACCAGGCGATATAATCATTTCCACGCCCGCCTCGAAGGTTCGCCGAAGGCTGAACTTCGACAGCCCATACAGCAGCCGTGCTGCTGTCCCCATTGTCCAAGGCACAA---ACAAGCGACGATCATGGACGTACAGGCCCATGTACCGGAAGCCCAGAATATACAGAATGTATCGAAGCCCTGATGTTCCCCGTGGATGTGAAGGCCCATGTAAAGTACAGTCTTATGAGCAACGGGATGATATTAAGCATACTGGTATTGTTCGTTGTGTTAGTGATGTTACTCGTGGATCTGGAATTACTCACAGAGTGGGTAAGAGGTTCTGTGTTAAATCGATATATTTTTTAGGTAAAGTCTGGATGGATGAAAATATCAAGAAGCAGAATCACACTAATCAGGTCATGTTCTTCTTGGTCCGTGATAGAAGGCCCTATGGAAACAGCCCAATGGATTTTGGACAGGTTTTTAATATGTTCGATAATGAGCCCAGTACCGCAACAGTGAAGAATGATTTGCGGGATAGGTTTCAAGTGATGAGGAAATTTCATGCTACAGTTATTGGTGGGCCCTCTGGAATGAAGGAACAGGCATTAGTTAAGAGATTTTTTAGAATTAACAGTCATGTAACTT-----ATAATCAT-CAGGAGGCAGCCAAGTACGAGAACCATACTGAAAACGCCTTGTTATTGTATATGGCATGTACGCATGCCTCTAATCCAGTGTATGCAACTATGAAAATACGCATCTATTTCTATGATTCAATATCAAATTAA", "ATGTGGGATCCTCTTTTAAACGAATTTCCGGATTCTGTTCACGGTTTTCGGTGTATGCTCGCAATAAAGTATTTGCAAGGCGTTGAAGCAACCTACGCCCCTGATACTGTCGGTTACGACCTAGTTCGAGATCTGATCTCAGTTGTTCGTGCGAGCAATTATGCTGAAGCGTGCCGGAGATATAGCCTTTTCCGGTCCCGTATCGAAAGTACGCCGTCGTCTCAATTACGACAGCCCAGGTACCAGCCGTGCTGCTGTACTCACTGCCCTCGGCATAA---ATCGAAAGAAGTCTTGGACTTCTCGGCCTATGTACCGGAAGCCCAGGATTTACCGGATGTACCGAACAGCTGATGTCCCTAGGGGATGTGAAGGTCCTTGCAAGATTCAATCCTTTGAATCTCGACATGATATTGCTCACACCGGTAAGGTTATGTGTGTGACGGATGTTACTCGTGGCGGTGGTTTAACCCACCGTACTGGGAAGAGATTTTGCGTTAAGTCCCTCTATATCCTTGGCAAAATCTGGATGGATGAAAATATCAAGACTAAGAATCACACTAACACGGTCATGTTCTATGTTGTTCGGGATCGTAGACCCTATGGTA-C-TCCT-CAAGATTTTGGACAAGTGTTTAACATGTTCGATAACGAACCTAGCACTGCAACTGTCAAGAATGATCTTCGAGATCGGTTTCAAGTTTTGCGGAAGTTCACGGCAACTGTTGTTGGTGGTCAGTATGCTTGTAAGGAACAAACGTTAGTTAGGAAGTTCATGAGATTGAACAATTATGTTGTTT-----ACAACCAT-CAGGAAACCGCAAAATATGAGAATCATACAGAGAATGCTCTGTTATTGTACATGGCATCTACGCATGCCTCTAACCCTGTGTATGCAACTTTGAAAATTCGGATCTATTTTTATGATTCGATAACAAATTAA", "ATGTGGGACCCACTTCTAAATGAATTTCCTGAATCTGTTCACGGATTTCGTTGTATGTTAGCTATTAAATATTTGCAGTCCGTTGAGGAAACTTACGAGCCCAATACATTGGGCCACGATTTAATTAGGGATCTTATATCTGTTGTAAGGGCCCGTGACTATGTCGAAGCGACCAGGCGATATAATCATTTCCACGCCCGTCTCGAAGGTTCGCCGAAGGCTGAACTTCGACAGCCCATACAGCAGCCGTGCTGCTGTCCCCATTGTCCAAGGCACAA---ACAAGCGACGATCATGGACGTACAGGCCCATGTACCGAAAGCCCAGAATATACAGAATGTATCGAAGCCCTGATGTTCCCCGTGGATGTGAAGGCCCATGTAAAGTCCAGTCTTATGAGCAACGGGATGATATTAAGCACACTGGTATTGTTCGTTGTGTTAGTGATGTTACTCGTGGATCTGGAATTACTCACAGAGTGGGTAAGAGGTTCTGTGTTAAATCGATATATTTTTTAGGTAAAGTCTGGATGGATGAAAATATCAAGAAGCAGAATCACACTAATCAGGTCATGTTCTTTT-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------"}};
    private static String[][] sequencesThree = new String[][]{{"AB192965Japan2004", "AF071228Spain1997", "AF105975Portugal1995", "AF189018Indonesia2005", "AJ842306France2004", "FM212660Cameroon2007"}, {"ATGTGGGATCCACTTCTAAATGAATTTCCTGAATCTGTTCACGGATTTCGTTGTATGTTAGCTATTAAATATTTGCAGTCCGTTGAGGAAACTTACGAGCCCAATACATTGGGCCACGATTTAATTAGGGATCTTATATCTGTTGTAAGGGCCCGTGACTATGTCGAAGCGACCAGGCGATATAATCATTTCCACGCCCGCCTCGAAGGTTCGCCGAAGGCTGAACTTCGACAGCCCATACAGCAGCCGTGCTGCTGTCCCCATTGTCCAAGGCACAA---ACAAGCGACGATCATGGACGTACAGGCCCATGTACCGGAAGCCCAGAATATACAGAATGTATCGAAGCCCTGATGTTCCTCGTGGATGTGAAGGCCCATGTAAAGTCCAGTCTTATGAGCAACGGGATGATATTAAGCATACTGGTATTGTTCGTTGTGTTAGTGATGTTACTCGTGGATCTGGAATTACTCACAGAGTGGGTAAGAGGTTCTGTGTTAAATCGATATATTTTTTAGGTAAAGTCTGGATGGATGAAAATATCAAGAAGCAGAATCACACTAATCAGGTCATGTTCTTCTTGGTTCGTGATAGAAGGCCCTATGGAAACAGCCCAATGGATTTTGGACAGGTTTTTAATATGTTCGATAATGAGCCCAGTACCGCAACTGTGAAGAATGATTTGCGGGATAGGTTTCAAGTGATGAGGAAATTTCATGCTACAGTTATTGGTGGGCCCTCTGGAATGAAGGAACAGGCATTAGTTAAGAGATTTTTTAGAATTAACAGTCATGTAACTT-----ATAATCAT-CAGGAGGCAGCCAAGTATGAGAACCATACTGAAAACGCCTTGTTATTGTATATGGCATGTACGCATGCCTCTAATCCAGTGTATGCAACTATGAAAATACGCATCTATTTCTATGATTCAATATCAAATTAA", "ATGTGGGATCCACTTCTAAATGAATTTCCTGAATCTGTTCACGGATTTCGTTGTATGTTAGCTATTAAATATTTGCAGTCCGTTGAGGAAACTTACGAGCCCAATACATTGGGCCACGATTTAATTAGGGATCTTATATCTGTTGTAAGGGCCCGTGACTATGTCGAAGCGACCAGGCGATATAATCATTTCCACGCCCGCCTCGAAGGTTCGCCGAAGGCTGAACTTCGACAGCCCATACAGCAGCCGTGCTGCTGTCCCCATTGTCCAAGGCACAA---ACAAGCGACGATCATGGACGTACAGGCCCATGTACCGGAAGCCCAGAATATACAGAATGTATCGAAGCACTGATGTTCCCCGTGGATGTGAAGGCCCATGTAAAGTACAGTCTTATGAGCAACGGGATGATATTAAGCATACTGGTATTGTTCGTTGTGTTAGTGATGTTACTCGTGGATCTGGAATTACTCACAGAGTGGGTAAGAGGTTCTGTGTTAAATCGATATATTTTTTAGGTAAAGTCTGGATGGATGAAAATATCAAGAAGCAGAACCACACTAATCAGGTCATGTTCTTCTTGGTCCGTGATAGAAGGCCCTATGGAAACAGCCCAATGGATTTTGGACAGGTTTTTAATATGTTCGATAATGAGCCCAGTACCGCAACAGTGAAGAATGATTTGCGGGATAGGTTTCAAGTGATGAGGAAATTTCATGCTACAGTTATTGGTGGGCCCTCTGGAATGAAGGAACAGGCATTAGTTAAGAGGTTTTTTAGAATTAACAGTCATGTAACTT-----ATAATCAT-CAGGAGGCAGCCAAGTACGAGAACCATACTGAAAACGCCTTGTTATTGTATATGGCATGTACGCATGCCTCTAATCCAGTGTATGCTACTATGAAAATACGCATCTATTTCTATGATTCAATATCAAATTAA", "ATGTGGGATCCACTTCTAAATGAATTTCCTGAATCTGTTCACGGATTTCGTTGTATGTTAGCTATTAAATATTTGCAGTCCGTTGAGGAAACTTACGAGCCCAATACATTGGGCCACGATTTAATTAGGGATCTTATATCTGTTGTAAGGGCCCGTGACTATGTCGAAGCGACCAGGCGATATAATCATTTCCACGCCCGCCTCGAAGGTTCGCCGAAGGCTGAACTTCGACAGCCCATACAGCAGCCGTGCTGCTGTCCCCATTGTCCAAGGCACAA---ACAAGCGACGATCATGGACGTACAGGCCCATGTACCGGAAGCCCAGAATATACAGAATGTATCGAAGCCCTGATGTTCCCCGTGGATGTGAAGGCCCATGTAAAGTACAGTCTTATGAGCAACGGGATGATATTAAGCATACTGGTATTGTTCGTTGTGTTAGTGATGTTACTCGTGGATCTGGAATTACTCACAGAGTGGGTAAGAGGTTCTGTGTTAAATCGATATATTTTTTAGGTAAAGTCTGGATGGATGAAAATATCAAGAAGCAGAATCACACTAATCAGGTCATGTTCTTCTTGGTCCGTGATAGAAGGCCCTATGGAAACAGCCCAATGGATTTTGGACAGGTTTTTAATATGTTCGATAATGAGCCCAGTACCGCAACAGTGAAGAATGATTTGCGGGATAGGTTTCAAGTGATGAGGAAATTTCATGCTACAGTTATTGGTGGGCCCTCTGGAATGAAGGAACAGGCATTAGTTAAGAGATTTTTTAGAATTAACAGTCATGTAACTT-----ATAATCAT-CAGGAGGCAGCCAAGTACGAGAACCATACTGAAAACGCCTTGTTATTGTATATGGCATGTACGCATGCCTCTAATCCAGTGTATGCAACTATGAAAATACGCATCTATTTCTATGATTCAATATCAAATTAA", "ATGTGGGATCCTCTTTTAAACGAATTTCCGGATTCTGTTCACGGTTTTCGGTGTATGCTCGCAATAAAGTATTTGCAAGGCGTTGAAGCAACCTACGCCCCTGATACTGTCGGTTACGACCTAGTTCGAGATCTGATCTCAGTTGTTCGTGCGAGCAATTATGCTGAAGCGTGCCGGAGATATAGCCTTTTCCGGTCCCGTATCGAAAGTACGCCGTCGTCTCAATTACGACAGCCCAGGTACCAGCCGTGCTGCTGTACTCACTGCCCTCGGCATAA---ATCGAAAGAAGTCTTGGACTTCTCGGCCTATGTACCGGAAGCCCAGGATTTACCGGATGTACCGAACAGCTGATGTCCCTAGGGGATGTGAAGGTCCTTGCAAGATTCAATCCTTTGAATCTCGACATGATATTGCTCACACCGGTAAGGTTATGTGTGTGACGGATGTTACTCGTGGCGGTGGTTTAACCCACCGTACTGGGAAGAGATTTTGCGTTAAGTCCCTCTATATCCTTGGCAAAATCTGGATGGATGAAAATATCAAGACTAAGAATCACACTAACACGGTCATGTTCTATGTTGTTCGGGATCGTAGACCCTATGGTA-C-TCCT-CAAGATTTTGGACAAGTGTTTAACATGTTCGATAACGAACCTAGCACTGCAACTGTCAAGAATGATCTTCGAGATCGGTTTCAAGTTTTGCGGAAGTTCACGGCAACTGTTGTTGGTGGTCAGTATGCTTGTAAGGAACAAACGTTAGTTAGGAAGTTCATGAGATTGAACAATTATGTTGTTT-----ACAACCAT-CAGGAAACCGCAAAATATGAGAATCATACAGAGAATGCTCTGTTATTGTACATGGCATCTACGCATGCCTCTAACCCTGTGTATGCAACTTTGAAAATTCGGATCTATTTTTATGATTCGATAACAAATTAA", "ATGTGGGACCCACTTCTAAATGAATTTCCTGAATCTGTTCACGGATTTCGTTGTATGTTAGCTATTAAATATTTGCAGTCCGTTGAGGAAACTTACGAGCCCAATACATTGGGCCACGATTTAATTAGGGATCTTATATCTGTTGTAAGGGCCCGTGACTATGTCGAAGCGACCAGGCGATATAATCATTTCCACGCCCGTCTCGAAGGTTCGCCGAAGGCTGAACTTCGACAGCCCATACAGCAGCCGTGCTGCTGTCCCCATTGTCCAAGGCACAA---ACAAGCGACGATCATGGACGTACAGGCCCATGTACCGAAAGCCCAGAATATACAGAATGTATCGAAGCCCTGATGTTCCCCGTGGATGTGAAGGCCCATGTAAAGTCCAGTCTTATGAGCAACGGGATGATATTAAGCACACTGGTATTGTTCGTTGTGTTAGTGATGTTACTCGTGGATCTGGAATTACTCACAGAGTGGGTAAGAGGTTCTGTGTTAAATCGATATATTTTTTAGGTAAAGTCTGGATGGATGAAAATATCAAGAAGCAGAATCACACTAATCAGGTCATGTTCTTTT-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------", "ATGTGGGATCCACTCCTAAATGAATTTCCTGAATCTGTTCACGGATTTCGTTGTATGTTAGCTATTAAATATTTGCAGGCCGTTGAAGAAACGTATGAGCCCAATACTTTGGGCCACGATTTAATTAGGGATCTTATATCTGTTGTAAGGGCCCGTGACTATGTCGAAGCGACCCGGCGATATAATCATTTCCACGCCCGTCTCGAAGGTTCGCCGAAGGCTGAACTTCGACAGCCCATACAGCAGCCGTGCTGCTGCCCCCATTGTCCAAGGCATAA---ACAAGCGACGGTCATGGACGTACAGGCCCATGTACCGAAAGCCCAGAATATACAGAATGTATCGAAGCCCTGATGTTCCCCGTGGATGTGAAGGCCCATGTAAGGTCCAATCGTATGAGCAACGGGATGACATTAAGCATACTGGTATTGTTCGTTGTGTTAGCGATGTTACTCGTGGTTCCGGTATTACCCACAGAGTGGGTAAGAGGTTCTGCGTTAAGTCCATATACTTTTTAGGTAAAGTCTGGATGGATGAAAATATCAAAAAGCAGAACCATACTAATCAAGTCATGTTCTTCTTGGTCCGTGATAGAAGGCCCTATGGAAACAGCCCAATGGATTTTGGACAGGTTTTTAATATGTTCGATAATGAGCCCAGTACCGCAACAGTGAAGAATGATCTCAGGGATAGGTTTCAAGTGATGAGGAAATTTCATGCTACCGTGATTGGTGGTCCGTCTGGTATGAAGGAACAGGCTTTAGTTAAGAGATTCTTTAGAATTAACAGTCATGTAACTT-----ATAATCAT-CAGGAGGCAGCTAAGTACGAGAATCATACTGAAAACGCCTTGTTATTGTATATGGCATGTACGCATGCCTCTAACCCAGTGTATGCAACTATGAAAATACGCATATATTTCTATGATTCAATATCAAATTAA"}};

    private static TreeModel createSpecifiedTree(String string) throws Exception {
        NewickImporter newickImporter = new NewickImporter(string);
        Tree tree = newickImporter.importTree(null);
        return new TreeModel(tree);
    }

    private static SimpleAlignment createAlignment(Object[][] objectArray, DataType dataType) {
        SimpleAlignment simpleAlignment = new SimpleAlignment();
        simpleAlignment.setDataType(dataType);
        Taxon[] taxonArray = new Taxon[objectArray[0].length];
        System.out.println("Taxon len = " + objectArray[0].length);
        System.out.println("Alignment len = " + objectArray[1].length);
        if (objectArray.length > 2) {
            System.out.println("Date len = " + objectArray[2].length);
        }
        for (int i = 0; i < objectArray[0].length; ++i) {
            Serializable serializable;
            taxonArray[i] = new Taxon(objectArray[0][i].toString());
            if (objectArray.length > 2) {
                serializable = new Date((Double)objectArray[2][i], Units.Type.YEARS, (Boolean)objectArray[3][0]);
                taxonArray[i].setDate((Date)serializable);
            }
            serializable = new Sequence(objectArray[1][i].toString());
            serializable.setTaxon(taxonArray[i]);
            serializable.setDataType(dataType);
            simpleAlignment.addSequence((Sequence)serializable);
        }
        return simpleAlignment;
    }

    public static void main(String[] stringArray) {
        TreeModel treeModel;
        MathUtils.setSeed(666L);
        Logger logger = Logger.getLogger("dr");
        logger.setUseParentHandlers(false);
        System.out.println("EXAMPLE 1: 4 taxa with 2 demes");
        SimpleAlignment simpleAlignment = BASTADensityTester.createAlignment(sequences, Nucleotides.INSTANCE);
        try {
            treeModel = BASTADensityTester.createSpecifiedTree("(((AB192965Japan2004:0.42343888910376215,AF189018Indonesia2005:1.4234388891037622)5:9.725099517053918,AF071228Spain1997:3.14853840615768)6:1.7275747971782511,AF105975Portugal1995:2.8761132033359313)");
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to parse Newick tree");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Asia");
        arrayList.add("West_Medit");
        GeneralDataType generalDataType = new GeneralDataType(arrayList);
        Taxa taxa = new Taxa();
        Taxon taxon = new Taxon(sequences[0][0]);
        taxon.setAttribute(DEME, arrayList.get(0));
        taxa.addTaxon(taxon);
        Taxon taxon2 = new Taxon(sequences[0][1]);
        taxon2.setAttribute(DEME, arrayList.get(1));
        taxa.addTaxon(taxon2);
        Taxon taxon3 = new Taxon(sequences[0][2]);
        taxon3.setAttribute(DEME, arrayList.get(1));
        taxa.addTaxon(taxon3);
        Taxon taxon4 = new Taxon(sequences[0][3]);
        taxon4.setAttribute(DEME, arrayList.get(0));
        taxa.addTaxon(taxon4);
        int[] nArray = new int[sequences[0].length];
        nArray[0] = 0;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 0;
        SimpleSiteList simpleSiteList = new SimpleSiteList(generalDataType, taxa);
        simpleSiteList.addPattern(nArray);
        double[] dArray = new double[]{0.5, 0.5};
        FrequencyModel frequencyModel = new FrequencyModel((DataType)generalDataType, dArray);
        Parameter.Default default_ = new Parameter.Default("migration rates", 2);
        default_.setParameterValue(0, 1.0);
        default_.setParameterValue(1, 1.0);
        Parameter.Default default_2 = new Parameter.Default("population sizes", 2);
        default_2.setParameterValue(0, 1.0);
        default_2.setParameterValue(1, 1.0);
        SVSComplexSubstitutionModel sVSComplexSubstitutionModel = new SVSComplexSubstitutionModel("migrationModel", (DataType)generalDataType, frequencyModel, (Parameter)default_, null);
        TaxonList taxonList = null;
        ArrayList<TaxonList> arrayList2 = new ArrayList<TaxonList>();
        int n = 2;
        DefaultBranchRateModel defaultBranchRateModel = new DefaultBranchRateModel();
        StructuredCoalescentLikelihood structuredCoalescentLikelihood = null;
        try {
            structuredCoalescentLikelihood = new StructuredCoalescentLikelihood(treeModel, defaultBranchRateModel, default_2, simpleSiteList, null, "", sVSComplexSubstitutionModel, n, taxonList, arrayList2, false);
        }
        catch (TreeUtils.MissingTaxonException missingTaxonException) {
            System.out.println("Error thrown in test class dr.evomodel.coalescent.basta.SCLikelihoodTester: " + missingTaxonException);
        }
        System.out.println("\nStructured coalescent lnL = " + structuredCoalescentLikelihood.calculateLogLikelihood());
        System.out.println("EXAMPLE 2: 5 taxa (2 identical sampling dates) with 2 demes");
        try {
            treeModel = BASTADensityTester.createSpecifiedTree("((((AB192965Japan2004:0.48972300366304955,AJ842306France2004:0.48972300366304955):1.2052625264106087,AF189018Indonesia2005:2.6949855300736583):6.86618775860274,AF071228Spain1997:1.5611732886763985):1.4313107562768952,AF105975Portugal1995:0.9924840449532937)");
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to parse Newick tree");
        }
        Taxon taxon5 = new Taxon(sequencesTwo[0][4]);
        taxon5.setAttribute(DEME, arrayList.get(1));
        taxa.addTaxon(taxon5);
        nArray = new int[sequencesTwo[0].length];
        nArray[0] = 0;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 0;
        nArray[4] = 1;
        simpleSiteList = new SimpleSiteList(generalDataType, taxa);
        simpleSiteList.addPattern(nArray);
        try {
            structuredCoalescentLikelihood = new StructuredCoalescentLikelihood(treeModel, defaultBranchRateModel, default_2, simpleSiteList, null, "", sVSComplexSubstitutionModel, n, taxonList, arrayList2, false);
        }
        catch (TreeUtils.MissingTaxonException missingTaxonException) {
            System.out.println("Error thrown in test class dr.evomodel.coalescent.basta.SCLikelihoodTester: " + missingTaxonException);
        }
        System.out.println("\nStructured coalescent lnL = " + structuredCoalescentLikelihood.calculateLogLikelihood());
        System.out.println("EXAMPLE 3: 6 taxa (2 identical sampling dates) with 3 demes");
        try {
            treeModel = BASTADensityTester.createSpecifiedTree("(((AB192965Japan2004:4.509764060335954,((AF189018Indonesia2005:1.496797606742874,AJ842306France2004:0.4967976067428741):0.3617175987505199,FM212660Cameroon2007:3.858515205493394):3.6512488548425597):4.957323993357177,AF071228Spain1997:2.4670880536931303):0.9760399779205056,AF105975Portugal1995:1.443128031613636)");
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to parse Newick tree");
        }
        arrayList = new ArrayList();
        arrayList.add("Asia");
        arrayList.add("West_Medit");
        arrayList.add("Africa");
        generalDataType = new GeneralDataType(arrayList);
        taxon.setAttribute(DEME, arrayList.get(0));
        taxon2.setAttribute(DEME, arrayList.get(1));
        taxon3.setAttribute(DEME, arrayList.get(1));
        taxon4.setAttribute(DEME, arrayList.get(0));
        taxon5.setAttribute(DEME, arrayList.get(1));
        Taxon taxon6 = new Taxon(sequencesThree[0][5]);
        taxon6.setAttribute(DEME, arrayList.get(2));
        taxa.addTaxon(taxon6);
        nArray = new int[sequencesThree[0].length];
        nArray[0] = 0;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 0;
        nArray[4] = 1;
        nArray[5] = 2;
        simpleSiteList = new SimpleSiteList(generalDataType, taxa);
        simpleSiteList.addPattern(nArray);
        dArray = new double[]{0.3333333333333333, 0.3333333333333333, 1.0 - dArray[0] - dArray[1]};
        frequencyModel = new FrequencyModel((DataType)generalDataType, dArray);
        default_ = new Parameter.Default("migration rates", 6);
        default_.setParameterValue(0, 1.0);
        default_.setParameterValue(1, 1.0);
        default_.setParameterValue(2, 1.0);
        default_.setParameterValue(3, 1.0);
        default_.setParameterValue(4, 1.0);
        default_.setParameterValue(5, 1.0);
        default_2 = new Parameter.Default("population sizes", 3);
        default_2.setParameterValue(0, 1.0);
        default_2.setParameterValue(1, 1.0);
        default_2.setParameterValue(2, 1.0);
        sVSComplexSubstitutionModel = new SVSComplexSubstitutionModel("migrationModel", (DataType)generalDataType, frequencyModel, (Parameter)default_, null);
        try {
            structuredCoalescentLikelihood = new StructuredCoalescentLikelihood(treeModel, defaultBranchRateModel, default_2, simpleSiteList, null, "", sVSComplexSubstitutionModel, n, taxonList, arrayList2, false);
        }
        catch (TreeUtils.MissingTaxonException missingTaxonException) {
            System.out.println("Error thrown in test class dr.evomodel.coalescent.basta.SCLikelihoodTester: " + missingTaxonException);
        }
        System.out.println("\nStructured coalescent lnL = " + structuredCoalescentLikelihood.calculateLogLikelihood());
        System.out.println("EXAMPLE 4: 6 taxa (2 identical sampling dates) with 3 demes and simple branch lengths");
        try {
            treeModel = BASTADensityTester.createSpecifiedTree("(((AB192965Japan2004:4.5,((AF189018Indonesia2005:1.5,AJ842306France2004:0.5):0.25,FM212660Cameroon2007:3.75):3.75):5.0,AF071228Spain1997:2.5):1.0,AF105975Portugal1995:1.5)");
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to parse Newick tree");
        }
        try {
            structuredCoalescentLikelihood = new StructuredCoalescentLikelihood(treeModel, defaultBranchRateModel, default_2, simpleSiteList, null, "", sVSComplexSubstitutionModel, n, taxonList, arrayList2, false);
        }
        catch (TreeUtils.MissingTaxonException missingTaxonException) {
            System.out.println("Error thrown in test class dr.evomodel.coalescent.basta.SCLikelihoodTester: " + missingTaxonException);
        }
        System.out.println("\nStructured coalescent lnL = " + structuredCoalescentLikelihood.calculateLogLikelihood());
        try {
            treeModel = BASTADensityTester.createSpecifiedTree("(((((AF189018Indonesia2005:1.5,AJ842306France2004:0.5):0.75,AB192965Japan2004:1.25):3.25,FM212660Cameroon2007:7.5):5.0,AF071228Spain1997:2.5):1.0,AF105975Portugal1995:1.5)");
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to parse Newick tree");
        }
        try {
            structuredCoalescentLikelihood = new StructuredCoalescentLikelihood(treeModel, defaultBranchRateModel, default_2, simpleSiteList, null, "", sVSComplexSubstitutionModel, n, taxonList, arrayList2, false);
        }
        catch (TreeUtils.MissingTaxonException missingTaxonException) {
            System.out.println("Error thrown in test class dr.evomodel.coalescent.basta.SCLikelihoodTester: " + missingTaxonException);
        }
        System.out.println("\nStructured coalescent lnL = " + structuredCoalescentLikelihood.calculateLogLikelihood());
    }
}

