/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.speciation;

import dr.evolution.tree.MutableTree;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.util.Taxon;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;
import dr.util.HeapSort;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import jebl.util.FixedBitSet;

public class SpeciesBindings
extends AbstractModel {
    private final GeneTreeInfo[] geneTrees;
    private final Map<Taxon, Integer> taxon2Species = new HashMap<Taxon, Integer>();
    final SPinfo[] species;
    private final double[][] popTimesPair;
    private boolean dirty_pp;
    private final double[][] popTimesSingle;
    private boolean dirty_sg;
    private final boolean verbose = false;

    public SpeciesBindings(SPinfo[] sPinfoArray, TreeModel[] treeModelArray, double[] dArray) {
        super(null);
        int n;
        int n2;
        Object object;
        int n3;
        this.species = sPinfoArray;
        int n4 = sPinfoArray.length;
        for (n3 = 0; n3 < n4; ++n3) {
            object = sPinfoArray[n3].taxa;
            n2 = ((Taxon[])object).length;
            for (int i = 0; i < n2; ++i) {
                Taxon taxon = object[i];
                if (this.taxon2Species.containsKey(taxon)) {
                    throw new Error("Multiple assignments for taxon" + taxon);
                }
                this.taxon2Species.put(taxon, n3);
            }
        }
        this.geneTrees = new GeneTreeInfo[treeModelArray.length];
        for (n3 = 0; n3 < treeModelArray.length; ++n3) {
            object = treeModelArray[n3];
            this.addModel((Model)object);
            this.geneTrees[n3] = new GeneTreeInfo((TreeModel)object, dArray[n3]);
        }
        GeneTreeInfo[] geneTreeInfoArray = this.geneTrees;
        int n5 = geneTreeInfoArray.length;
        for (n2 = 0; n2 < n5; ++n2) {
            GeneTreeInfo geneTreeInfo = geneTreeInfoArray[n2];
            for (int i = 0; i < n4; ++i) {
                if (geneTreeInfo.nLineages(i) != 0) continue;
                throw new Error("Every gene tree must contain at least one tip from each species (" + geneTreeInfo.tree.getId() + "," + sPinfoArray[i].name + ")");
            }
        }
        this.popTimesSingle = new double[n4][];
        for (n = 0; n < this.popTimesSingle.length; ++n) {
            this.popTimesSingle[n] = new double[this.allCoalPointsCount(n)];
        }
        this.dirty_sg = true;
        this.popTimesPair = new double[n4 * (n4 - 1) / 2][];
        n = this.allPairCoalPointsCount();
        for (n5 = 0; n5 < this.popTimesPair.length; ++n5) {
            this.popTimesPair[n5] = new double[n];
        }
        this.dirty_pp = true;
        this.addStatistic(new SpeciesLimits());
    }

    public int nSpecies() {
        return this.species.length;
    }

    public double[][] getPopTimesSingle() {
        if (this.dirty_sg) {
            for (int i = 0; i < this.popTimesSingle.length; ++i) {
                this.getAllCoalPoints(i, this.popTimesSingle[i]);
            }
            this.dirty_sg = false;
        }
        return this.popTimesSingle;
    }

    public double[][] getPopTimesPair() {
        if (this.dirty_pp) {
            int n = this.nSpecies();
            for (int i = 0; i < n - 1; ++i) {
                int n2 = i * (2 * n - i - 3) / 2 - 1;
                for (int j = i + 1; j < n; ++j) {
                    this.getAllPairCoalPoints(i, j, this.popTimesPair[n2 + j]);
                }
            }
        }
        return this.popTimesPair;
    }

    private void getAllPairCoalPoints(int n, int n2, double[] dArray) {
        block0: for (int i = 0; i < this.geneTrees.length; ++i) {
            for (CoalInfo coalInfo : this.geneTrees[i].getCoalInfo()) {
                if ((!coalInfo.sinfo[0].contains(n) || !coalInfo.sinfo[1].contains(n2)) && (!coalInfo.sinfo[1].contains(n) || !coalInfo.sinfo[0].contains(n2))) continue;
                dArray[i] = coalInfo.ctime;
                continue block0;
            }
        }
        HeapSort.sort(dArray);
    }

    private int allCoalPointsCount(int n) {
        int n2 = 0;
        for (GeneTreeInfo geneTreeInfo : this.geneTrees) {
            if (geneTreeInfo.nLineages(n) <= 0) continue;
            n2 += geneTreeInfo.nLineages(n) - 1;
        }
        return n2;
    }

    void getAllCoalPoints(int n, double[] dArray) {
        int n2 = 0;
        for (GeneTreeInfo geneTreeInfo : this.geneTrees) {
            int n3 = geneTreeInfo.nLineages(n) - 1;
            int n4 = n2;
            for (CoalInfo coalInfo : geneTreeInfo.getCoalInfo()) {
                if (!coalInfo.allHas(n)) continue;
                dArray[n2] = coalInfo.ctime;
                ++n2;
            }
            if (n3 < 0 || n4 + n3 != n2 || n3 < 0 && n4 == n2) {
                System.err.println(n3);
            }
            assert (n3 >= 0 && n4 + n3 == n2 || n3 < 0 && n4 == n2);
        }
        assert (n2 == dArray.length);
        HeapSort.sort(dArray);
    }

    private int allPairCoalPointsCount() {
        return this.geneTrees.length;
    }

    public double speciationUpperBound(FixedBitSet fixedBitSet, FixedBitSet fixedBitSet2) {
        double d = Double.MAX_VALUE;
        block0: for (GeneTreeInfo geneTreeInfo : this.getGeneTrees()) {
            for (CoalInfo coalInfo : geneTreeInfo.getCoalInfo()) {
                if (coalInfo.ctime >= d) continue block0;
                if ((coalInfo.sinfo[0].intersectCardinality(fixedBitSet) <= 0 || coalInfo.sinfo[1].intersectCardinality(fixedBitSet2) <= 0) && (coalInfo.sinfo[0].intersectCardinality(fixedBitSet2) <= 0 || coalInfo.sinfo[1].intersectCardinality(fixedBitSet) <= 0)) continue;
                d = coalInfo.ctime;
                continue block0;
            }
        }
        return d;
    }

    public void makeCompatible(double d) {
        for (GeneTreeInfo geneTreeInfo : this.getGeneTrees()) {
            TreeModel treeModel = geneTreeInfo.tree;
            for (int i = 0; i < treeModel.getExternalNodeCount(); ++i) {
                NodeRef nodeRef = treeModel.getExternalNode(i);
                NodeRef nodeRef2 = treeModel.getParent(nodeRef);
                treeModel.setNodeHeight(nodeRef2, d + treeModel.getNodeHeight(nodeRef2));
            }
            MutableTree.Utils.correctHeightsForTips(treeModel);
            geneTreeInfo.wasChanged();
            geneTreeInfo.getCoalInfo();
            geneTreeInfo.wasBacked = false;
        }
    }

    private int collectCoalInfo(Tree tree, NodeRef nodeRef, int n, CoalInfo[] coalInfoArray) {
        coalInfoArray[n] = new CoalInfo(tree.getNodeHeight(nodeRef), tree.getChildCount(nodeRef));
        int n2 = n - 1;
        for (int i = 0; i < 2; ++i) {
            NodeRef nodeRef2 = tree.getChild(nodeRef, i);
            coalInfoArray[n].sinfo[i] = new FixedBitSet(this.nSpecies());
            if (tree.isExternal(nodeRef2)) {
                coalInfoArray[n].sinfo[i].set(this.taxon2Species.get(tree.getNodeTaxon(nodeRef2)));
                assert (tree.getNodeHeight(nodeRef2) == 0.0);
                continue;
            }
            int n3 = this.collectCoalInfo(tree, nodeRef2, n2, coalInfoArray);
            for (int j = 0; j < coalInfoArray[n2].sinfo.length; ++j) {
                coalInfoArray[n].sinfo[i].union(coalInfoArray[n2].sinfo[j]);
            }
            n2 = n3;
        }
        return n2;
    }

    public GeneTreeInfo[] getGeneTrees() {
        return this.geneTrees;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.dirty_sg = true;
        this.dirty_pp = true;
        for (GeneTreeInfo geneTreeInfo : this.geneTrees) {
            if (geneTreeInfo.tree != model) continue;
            geneTreeInfo.wasChanged();
            break;
        }
        this.fireModelChanged(object, n);
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        assert (false);
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
        for (GeneTreeInfo geneTreeInfo : this.geneTrees) {
            if (!geneTreeInfo.restore()) continue;
            this.dirty_sg = true;
            this.dirty_pp = true;
        }
    }

    @Override
    protected void acceptState() {
        for (GeneTreeInfo geneTreeInfo : this.geneTrees) {
            geneTreeInfo.accept();
        }
    }

    public class SpeciesLimits
    extends Statistic.Abstract {
        int nDim;
        int[][] c;

        SpeciesLimits() {
            int n;
            super("SpeciationBounds");
            this.nDim = 0;
            int n2 = SpeciesBindings.this.species.length;
            this.c = new int[n2 + 1][n2 + 1];
            for (n = 0; n < n2 + 1; ++n) {
                this.c[n][0] = 1;
                this.c[n][n] = 1;
            }
            for (n = 0; n < n2 + 1; ++n) {
                for (int i = 1; i < n; ++i) {
                    this.c[n][i] = this.c[n - 1][i - 1] + this.c[n - 1][i];
                }
            }
            for (n = 0; n <= n2 / 2; ++n) {
                this.nDim += this.c[n2][n];
            }
        }

        @Override
        public int getDimension() {
            return this.nDim;
        }

        private double boundOnRoot() {
            double d = Double.MAX_VALUE;
            int n = SpeciesBindings.this.species.length;
            block0: for (GeneTreeInfo geneTreeInfo : SpeciesBindings.this.getGeneTrees()) {
                for (CoalInfo coalInfo : geneTreeInfo.getCoalInfo()) {
                    if (coalInfo.sinfo[0].cardinality() != n && coalInfo.sinfo[1].cardinality() != n) continue;
                    d = Math.min(d, coalInfo.ctime);
                    continue block0;
                }
            }
            return d;
        }

        @Override
        public double getStatisticValue(int n) {
            int n2;
            int n3;
            if (n == 0) {
                return this.boundOnRoot();
            }
            int n4 = SpeciesBindings.this.species.length;
            int n5 = 0;
            for (n3 = 0; n3 <= n4 / 2 && n >= n5 + (n2 = this.c[n4][n3]); ++n3) {
                n5 += n2;
            }
            n2 = n - n5;
            FixedBitSet fixedBitSet = new FixedBitSet(n4);
            FixedBitSet fixedBitSet2 = new FixedBitSet(n4);
            int n6 = n4;
            for (int i = 0; i < n4; ++i) {
                if (n3 == 0) {
                    fixedBitSet2.set(i);
                    continue;
                }
                if (n2 < this.c[n6 - 1][n3 - 1]) {
                    fixedBitSet.set(i);
                    --n3;
                } else {
                    fixedBitSet2.set(i);
                    n2 -= this.c[n6 - 1][n3];
                }
                --n6;
            }
            return SpeciesBindings.this.speciationUpperBound(fixedBitSet, fixedBitSet2);
        }
    }

    public class GeneTreeInfo {
        public final TreeModel tree;
        private final int[] lineagesCount;
        private CoalInfo[] cList;
        private CoalInfo[] savedcList;
        private boolean dirty;
        private boolean wasBacked;
        private final double popFactor;

        GeneTreeInfo(TreeModel treeModel, double d) {
            this.tree = treeModel;
            this.popFactor = d;
            this.lineagesCount = new int[SpeciesBindings.this.species.length];
            Arrays.fill(this.lineagesCount, 0);
            for (int i = 0; i < this.lineagesCount.length; ++i) {
                for (Taxon taxon : SpeciesBindings.this.species[i].taxa) {
                    if (treeModel.getTaxonIndex(taxon) < 0) continue;
                    int n = i;
                    this.lineagesCount[n] = this.lineagesCount[n] + 1;
                }
            }
            this.cList = new CoalInfo[treeModel.getExternalNodeCount() - 1];
            this.savedcList = new CoalInfo[this.cList.length];
            this.wasChanged();
            this.getCoalInfo();
            this.wasBacked = false;
        }

        int nLineages(int n) {
            return this.lineagesCount[n];
        }

        public CoalInfo[] getCoalInfo() {
            if (this.dirty) {
                this.swap();
                SpeciesBindings.this.collectCoalInfo(this.tree, this.tree.getRoot(), this.cList.length - 1, this.cList);
                HeapSort.sort(this.cList);
                this.dirty = false;
                this.wasBacked = true;
            }
            return this.cList;
        }

        private void swap() {
            CoalInfo[] coalInfoArray = this.cList;
            this.cList = this.savedcList;
            this.savedcList = coalInfoArray;
        }

        void wasChanged() {
            this.dirty = true;
            this.wasBacked = false;
        }

        boolean restore() {
            if (this.wasBacked) {
                this.swap();
                this.wasBacked = false;
                this.dirty = false;
                return true;
            }
            return false;
        }

        void accept() {
            this.wasBacked = false;
        }

        public double popFactor() {
            return this.popFactor;
        }
    }

    class CoalInfo
    implements Comparable<CoalInfo> {
        final double ctime;
        final FixedBitSet[] sinfo;

        CoalInfo(double d, int n) {
            this.ctime = d;
            this.sinfo = new FixedBitSet[n];
        }

        @Override
        public int compareTo(CoalInfo coalInfo) {
            return coalInfo.ctime < this.ctime ? 1 : (coalInfo.ctime > this.ctime ? -1 : 0);
        }

        public boolean allHas(int n) {
            for (FixedBitSet fixedBitSet : this.sinfo) {
                if (fixedBitSet.contains(n)) continue;
                return false;
            }
            return true;
        }
    }

    public static class SPinfo
    extends Taxon {
        public final String name;
        private final Taxon[] taxa;

        public SPinfo(String string, Taxon[] taxonArray) {
            super(string);
            this.name = string;
            this.taxa = taxonArray;
        }
    }
}

