/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel;

import dr.evomodel.substmodel.DifferentiableSubstitutionModel;
import dr.evomodel.substmodel.DifferentiableSubstitutionModelUtil;
import dr.math.matrixAlgebra.WrappedMatrix;

public interface DifferentialMassProvider {
    public double[] getDifferentialMassMatrix(double var1);

    public static class DifferentialWrapper
    implements DifferentialMassProvider {
        private final DifferentiableSubstitutionModel baseModel;
        private final WrtParameter wrt;

        public DifferentialWrapper(DifferentiableSubstitutionModel differentiableSubstitutionModel, WrtParameter wrtParameter) {
            this.baseModel = differentiableSubstitutionModel;
            this.wrt = wrtParameter;
        }

        @Override
        public double[] getDifferentialMassMatrix(double d) {
            WrappedMatrix wrappedMatrix = this.baseModel.getInfinitesimalDifferentialMatrix(this.wrt);
            return DifferentiableSubstitutionModelUtil.getDifferentialMassMatrix(d, this.baseModel.getDataType().getStateCount(), wrappedMatrix, this.baseModel.getEigenDecomposition());
        }

        public static interface WrtParameter {
            public double getRate(int var1);

            public double getNormalizationDifferential();
        }
    }
}

