/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.transmission;

import dr.evolution.colouring.DefaultBranchColouring;
import dr.evolution.colouring.DefaultTreeColouring;
import dr.evolution.colouring.TreeColouring;
import dr.evolution.colouring.TreeColouringProvider;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.util.Taxon;
import dr.evolution.util.Units;
import dr.evoxml.util.XMLUnits;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class TransmissionHistoryModel
extends AbstractModel
implements TreeColouringProvider,
Units {
    public static String TRANSMISSION_HISTORY_MODEL = "transmissionHistory";
    public static String TRANSMISSION = "transmission";
    public static String DONOR = "donor";
    public static String RECIPIENT = "recipient";
    private Units.Type units;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{XMLUnits.UNITS_RULE, new ElementRule(TRANSMISSION, new XMLSyntaxRule[]{new ElementRule(Parameter.class), new ElementRule(DONOR, new XMLSyntaxRule[]{new ElementRule(Taxon.class)}), new ElementRule(RECIPIENT, new XMLSyntaxRule[]{new ElementRule(Taxon.class)})}, 1, Integer.MAX_VALUE)};

        @Override
        public String getParserName() {
            return TRANSMISSION_HISTORY_MODEL;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Units.Type type = XMLUnits.Utils.getUnitsAttr(xMLObject);
            TransmissionHistoryModel transmissionHistoryModel = new TransmissionHistoryModel(type);
            for (int i = 0; i < xMLObject.getChildCount(); ++i) {
                Taxon taxon;
                XMLObject xMLObject2 = (XMLObject)xMLObject.getChild(i);
                if (!xMLObject2.getName().equals(TRANSMISSION)) continue;
                Taxon taxon2 = (Taxon)xMLObject2.getElementFirstChild(DONOR);
                if (taxon2.equals(taxon = (Taxon)xMLObject2.getElementFirstChild(RECIPIENT))) {
                    throw new XMLParseException("Donor and recipient in TransmissionHistoryModel are the same: " + taxon2);
                }
                Parameter parameter = (Parameter)xMLObject2.getChild(Parameter.class);
                transmissionHistoryModel.addTransmission(taxon2, taxon, parameter);
            }
            return transmissionHistoryModel;
        }

        @Override
        public String getParserDescription() {
            return "Defines a transmission history";
        }

        @Override
        public Class getReturnType() {
            return TransmissionHistoryModel.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private List<TransmissionEvent> transmissionEvents = new ArrayList<TransmissionEvent>();
    private Map<Taxon, TransmissionEvent> transmissionEventMap = new HashMap<Taxon, TransmissionEvent>();
    private List<Taxon> hosts = new ArrayList<Taxon>();

    public TransmissionHistoryModel(Units.Type type) {
        this(TRANSMISSION_HISTORY_MODEL, type);
    }

    public TransmissionHistoryModel(String string, Units.Type type) {
        super(string);
        this.setUnits(type);
    }

    private void addTransmission(Taxon taxon, Taxon taxon2, Parameter parameter) {
        if (taxon.equals(taxon2)) {
            throw new RuntimeException("Donor and recipient are the same, " + taxon);
        }
        if (parameter != null) {
            this.addVariable(parameter);
        }
        TransmissionEvent transmissionEvent = new TransmissionEvent(taxon, taxon2, parameter);
        this.transmissionEvents.add(transmissionEvent);
        this.transmissionEventMap.put(taxon2, transmissionEvent);
        if (!this.hosts.contains(taxon)) {
            this.hosts.add(taxon);
        }
        if (!this.hosts.contains(taxon2)) {
            this.hosts.add(taxon2);
        }
        Logger.getLogger("dr.evomodel").info("Transmission from " + taxon + " to " + taxon2 + (parameter != null ? "at " + parameter.getParameterValue(0) : ""));
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    public int getTransmissionEventCount() {
        return this.transmissionEvents.size();
    }

    public TransmissionEvent getTransmissionEvent(int n) {
        return this.transmissionEvents.get(n);
    }

    public TransmissionEvent getTransmissionEventToHost(Taxon taxon) {
        return this.transmissionEventMap.get(taxon);
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public final void setUnits(Units.Type type) {
        this.units = type;
    }

    @Override
    public final Units.Type getUnits() {
        return this.units;
    }

    public Taxon getHost(int n) {
        return this.hosts.get(n);
    }

    public int getHostIndex(Taxon taxon) {
        return this.hosts.indexOf(taxon);
    }

    public int getHostCount() {
        return this.hosts.size();
    }

    @Override
    public TreeColouring getTreeColouring(Tree tree) {
        DefaultTreeColouring defaultTreeColouring = new DefaultTreeColouring(this.getHostCount(), tree);
        this.createTreeColouring(tree, tree.getRoot(), defaultTreeColouring);
        return defaultTreeColouring;
    }

    private Taxon createTreeColouring(Tree tree, NodeRef nodeRef, DefaultTreeColouring defaultTreeColouring) {
        Serializable serializable;
        Taxon taxon;
        Taxon taxon2 = null;
        if (tree.isExternal(nodeRef)) {
            taxon = (Taxon)tree.getNodeTaxon(nodeRef).getAttribute("host");
            if (taxon == null) {
                throw new RuntimeException("One or more of the viruses tree's taxa are missing the 'host' attribute");
            }
        } else {
            Taxon taxon3;
            serializable = this.createTreeColouring(tree, tree.getChild(nodeRef, 0), defaultTreeColouring);
            if (serializable != (taxon3 = this.createTreeColouring(tree, tree.getChild(nodeRef, 1), defaultTreeColouring))) {
                throw new RuntimeException("Two children have different hosts at coalescent event");
            }
            taxon = serializable;
        }
        if ((serializable = tree.getParent(nodeRef)) != null) {
            DefaultBranchColouring defaultBranchColouring;
            double d = tree.getNodeHeight(nodeRef);
            double d2 = tree.getNodeHeight((NodeRef)serializable);
            TransmissionEvent transmissionEvent = this.getTransmissionEventToHost(taxon);
            if (transmissionEvent != null && transmissionEvent.getTransmissionTime() < d2) {
                if (transmissionEvent.getTransmissionTime() < d) {
                    throw new RuntimeException("Transmission event is before the node");
                }
                ArrayList<Taxon> arrayList = new ArrayList<Taxon>();
                ArrayList<Double> arrayList2 = new ArrayList<Double>();
                taxon2 = taxon;
                while (transmissionEvent != null && transmissionEvent.getTransmissionTime() < d2) {
                    arrayList.add(taxon2);
                    arrayList2.add(transmissionEvent.getTransmissionTime());
                    taxon2 = transmissionEvent.donor;
                    transmissionEvent = this.getTransmissionEventToHost(taxon2);
                }
                int n = this.getHostIndex(taxon);
                int n2 = this.getHostIndex(taxon2);
                defaultBranchColouring = new DefaultBranchColouring(n2, n);
                for (int i = arrayList.size() - 1; i >= 0; --i) {
                    int n3 = this.getHostIndex((Taxon)arrayList.get(i));
                    double d3 = (Double)arrayList2.get(i);
                    defaultBranchColouring.addEvent(n3, d3);
                }
            } else {
                int n = this.getHostIndex(taxon);
                defaultBranchColouring = new DefaultBranchColouring(n, n);
                taxon2 = taxon;
            }
            defaultTreeColouring.setBranchColouring(nodeRef, defaultBranchColouring);
        }
        return taxon2;
    }

    class TransmissionEvent {
        Taxon donor;
        Taxon recipient;
        Parameter timeParameter = null;

        public TransmissionEvent(Taxon taxon, Taxon taxon2, Parameter parameter) {
            this.donor = taxon;
            this.recipient = taxon2;
            this.timeParameter = parameter;
        }

        public double getTransmissionTime() {
            return this.timeParameter.getParameterValue(0);
        }

        public Taxon getDonor() {
            return this.donor;
        }

        public Taxon getRecipient() {
            return this.recipient;
        }
    }
}

