/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Bounds;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;

public class StarTreeModel
extends TreeModel {
    private boolean maxTipHeightKnown = false;
    private boolean savedMaxTipHeightKnown;
    private double maxTipHeight = 5.0;
    private double savedMaxTipHeight;
    private Parameter rootHeightParameter = null;
    private TreeModel sharedRoot = null;

    public StarTreeModel(String string, Tree tree) {
        super(string, tree);
    }

    @Override
    public void setupHeightBounds() {
        if (this.heightBoundsSetup) {
            throw new IllegalArgumentException("Node height bounds set up twice");
        }
        for (int i = 0; i < this.getNodeCount(); ++i) {
            this.setupHeightBounds((TreeModel.Node)this.getNode(i));
        }
        this.heightBoundsSetup = true;
    }

    private void setupHeightBounds(TreeModel.Node node) {
        node.heightParameter.addBounds(new StarTreeNodeHeightBounds(node.heightParameter));
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        TreeModel.TreeChangedEvent treeChangedEvent;
        if (model == this.sharedRoot && object instanceof TreeModel.TreeChangedEvent && (treeChangedEvent = (TreeModel.TreeChangedEvent)object).getParameter() == this.sharedRoot.getRootHeightParameter()) {
            this.pushTreeChangedEvent();
        }
    }

    @Override
    public void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.rootHeightParameter) {
            this.pushTreeChangedEvent();
        } else {
            TreeModel.Node node = this.getNodeOfParameter((Parameter)variable);
            if (node.isRoot()) {
                this.pushTreeChangedEvent();
            } else if (node.isExternal()) {
                this.maxTipHeightKnown = false;
                this.pushTreeChangedEvent();
            } else {
                throw new IllegalArgumentException("Can not sample internal nodes in StarTree");
            }
            super.handleVariableChangedEvent(variable, n, changeType);
        }
    }

    @Override
    public double getNodeHeight(NodeRef nodeRef) {
        TreeModel.Node node = (TreeModel.Node)nodeRef;
        if (!node.isExternal()) {
            if (this.rootHeightParameter != null) {
                return this.rootHeightParameter.getParameterValue(0);
            }
            if (this.sharedRoot != null) {
                return this.sharedRoot.getNodeHeight(this.sharedRoot.getRoot());
            }
            return ((TreeModel.Node)this.getRoot()).getHeight();
        }
        return node.getHeight();
    }

    public void setSharedRootHeightParameter(TreeModel treeModel) {
        this.sharedRoot = treeModel;
        this.addModel(treeModel);
    }

    @Override
    public void storeState() {
        super.storeState();
        this.savedMaxTipHeight = this.maxTipHeight;
        this.savedMaxTipHeightKnown = this.maxTipHeightKnown;
    }

    @Override
    public void restoreState() {
        super.restoreState();
        this.maxTipHeight = this.savedMaxTipHeight;
        this.maxTipHeightKnown = this.savedMaxTipHeightKnown;
    }

    private double getMaxTipHeight() {
        if (!this.maxTipHeightKnown) {
            this.maxTipHeight = this.getNodeHeight(this.getExternalNode(0));
            for (int i = 1; i < this.getExternalNodeCount(); ++i) {
                double d = this.getNodeHeight(this.getExternalNode(i));
                if (!(d > this.maxTipHeight)) continue;
                this.maxTipHeight = d;
            }
            this.maxTipHeightKnown = true;
        }
        return this.maxTipHeight;
    }

    private class StarTreeNodeHeightBounds
    implements Bounds<Double> {
        private Parameter nodeHeightParameter = null;

        public StarTreeNodeHeightBounds(Parameter parameter) {
            this.nodeHeightParameter = parameter;
        }

        @Override
        public Double getUpperLimit(int n) {
            TreeModel.Node node = StarTreeModel.this.getNodeOfParameter(this.nodeHeightParameter);
            if (node.isRoot()) {
                return Double.POSITIVE_INFINITY;
            }
            return StarTreeModel.this.getNodeHeight(StarTreeModel.this.getRoot());
        }

        @Override
        public Double getLowerLimit(int n) {
            TreeModel.Node node = StarTreeModel.this.getNodeOfParameter(this.nodeHeightParameter);
            if (node.isExternal()) {
                return 0.0;
            }
            return StarTreeModel.this.getMaxTipHeight();
        }

        @Override
        public int getBoundsDimension() {
            return 1;
        }
    }
}

