/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.preorder;

import dr.evomodel.treedatalikelihood.preorder.ProcessSimulationDelegate;
import dr.math.matrixAlgebra.WrappedVector;
import dr.math.matrixAlgebra.missingData.MissingOps;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class ConditionalVarianceAndTransform2 {
    private final DenseMatrix64F sBar;
    private final DenseMatrix64F affineTransform;
    private final int[] missingIndices;
    private final int[] notMissingIndices;
    private final double[] tempStorage;
    private final int numMissing;
    private final int numNotMissing;
    private static final boolean DEBUG = false;
    private double[][] cholesky = null;
    private DenseMatrix64F sBarInv = null;

    public ConditionalVarianceAndTransform2(DenseMatrix64F denseMatrix64F, int[] nArray, int[] nArray2) {
        assert (nArray.length + nArray2.length == denseMatrix64F.getNumRows());
        assert (nArray.length + nArray2.length == denseMatrix64F.getNumCols());
        this.missingIndices = nArray;
        this.notMissingIndices = nArray2;
        DenseMatrix64F denseMatrix64F2 = new DenseMatrix64F(nArray2.length, nArray2.length);
        MissingOps.gatherRowsAndColumns(denseMatrix64F, denseMatrix64F2, nArray2, nArray2);
        DenseMatrix64F denseMatrix64F3 = new DenseMatrix64F(nArray2.length, nArray2.length);
        CommonOps.invert(denseMatrix64F2, denseMatrix64F3);
        DenseMatrix64F denseMatrix64F4 = new DenseMatrix64F(nArray.length, nArray2.length);
        MissingOps.gatherRowsAndColumns(denseMatrix64F, denseMatrix64F4, nArray, nArray2);
        DenseMatrix64F denseMatrix64F5 = new DenseMatrix64F(nArray.length, nArray2.length);
        CommonOps.mult(denseMatrix64F4, denseMatrix64F3, denseMatrix64F5);
        DenseMatrix64F denseMatrix64F6 = new DenseMatrix64F(nArray.length, nArray.length);
        CommonOps.multTransB(denseMatrix64F5, denseMatrix64F4, denseMatrix64F6);
        this.sBar = new DenseMatrix64F(nArray.length, nArray.length);
        MissingOps.gatherRowsAndColumns(denseMatrix64F, this.sBar, nArray, nArray);
        CommonOps.subtract((D1Matrix64F)this.sBar, (D1Matrix64F)denseMatrix64F6, (D1Matrix64F)this.sBar);
        this.affineTransform = denseMatrix64F5;
        this.tempStorage = new double[nArray.length];
        this.numMissing = nArray.length;
        this.numNotMissing = nArray2.length;
    }

    public WrappedVector getConditionalMean(double[] dArray, int n, double[] dArray2, int n2) {
        int n3;
        double[] dArray3 = new double[this.numMissing];
        double[] dArray4 = new double[this.numNotMissing];
        for (n3 = 0; n3 < this.numNotMissing; ++n3) {
            int n4 = this.notMissingIndices[n3];
            dArray4[n3] = dArray[n + n4] - dArray2[n2 + n4];
        }
        for (n3 = 0; n3 < this.numMissing; ++n3) {
            double d = 0.0;
            for (int i = 0; i < this.numNotMissing; ++i) {
                d += this.affineTransform.unsafe_get(n3, i) * dArray4[i];
            }
            dArray3[n3] = dArray2[n2 + this.missingIndices[n3]] + d;
        }
        return new WrappedVector.Raw(dArray3, 0, this.numMissing);
    }

    final double[][] getConditionalCholesky() {
        if (this.cholesky == null) {
            this.cholesky = ProcessSimulationDelegate.AbstractContinuousTraitDelegate.getCholeskyOfVariance(this.sBar.data, this.missingIndices.length);
        }
        return this.cholesky;
    }

    public final DenseMatrix64F getConditionalVariance() {
        return this.sBar;
    }

    final DenseMatrix64F getConditionalPrecision() {
        if (this.sBarInv == null) {
            this.sBarInv = new DenseMatrix64F(this.numMissing, this.numMissing);
            CommonOps.invert(this.sBar, this.sBarInv);
        }
        return this.sBarInv;
    }

    final double[] getTemporaryStorage() {
        return this.tempStorage;
    }
}

