/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.inference.operators.EllipticalSliceOperator;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.SimpleMCMCOperator;

public abstract class InvariantOperator
extends SimpleMCMCOperator
implements GibbsOperator {
    private double pathParameter = 1.0;
    private final Parameter parameter;
    private final Likelihood likelihood;
    private final boolean checkLikelihood;
    private static final boolean DEBUG = false;
    private static final double tolerance = 0.1;

    private InvariantOperator(Parameter parameter, Likelihood likelihood, double d, boolean bl) {
        this.parameter = parameter;
        this.likelihood = likelihood;
        this.checkLikelihood = bl;
        this.setWeight(d);
    }

    public String getPerformanceSuggestion() {
        return null;
    }

    @Override
    public String getOperatorName() {
        return "dirtyLikelihood";
    }

    @Override
    public double doOperation() {
        double d;
        double d2 = 0.0;
        if (this.checkLikelihood && this.likelihood != null) {
            d2 = this.likelihood.getLogLikelihood();
        }
        if (this.pathParameter == 1.0) {
            this.transform(this.parameter);
        }
        if (this.checkLikelihood && this.likelihood != null && Math.abs(d2 - (d = this.likelihood.getLogLikelihood())) > 0.1) {
            String string = "Likelihood is not invariant to transformation:\nBefore: " + d2 + "\nAfter : " + d + "\n";
            throw new RuntimeException(string);
        }
        return 0.0;
    }

    @Override
    public void setPathParameter(double d) {
        this.pathParameter = d;
    }

    protected abstract void transform(Parameter var1);

    public int getStepCount() {
        return 1;
    }

    public static class Rotation
    extends InvariantOperator {
        private final boolean translationInvariant;
        private final boolean rotationInvariant;
        private final int dim;

        public Rotation(Parameter parameter, int n, double d, Likelihood likelihood, boolean bl, boolean bl2, boolean bl3) {
            super(parameter, likelihood, d, bl3);
            this.dim = n;
            this.translationInvariant = bl;
            this.rotationInvariant = bl2;
        }

        @Override
        protected void transform(Parameter parameter) {
            double[] dArray = parameter.getParameterValues();
            EllipticalSliceOperator.transformPoint(dArray, this.translationInvariant, this.rotationInvariant, this.dim);
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                parameter.setParameterValueQuietly(i, dArray[i]);
            }
            parameter.fireParameterChangedEvent();
        }
    }
}

