/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import dr.math.GammaFunction;
import dr.math.Integral;
import dr.math.LogTricks;
import dr.math.UnivariateFunction;

public class GeneralisedGaussLaguerreQuadrature
implements Integral {
    private double B;
    private double alpha;
    private final int noPoints;
    private final double[] abscissae;
    private final double[] coefficients;

    public GeneralisedGaussLaguerreQuadrature(double d, double d2, int n) {
        this.B = d;
        this.alpha = d2;
        this.noPoints = n;
        this.abscissae = new double[n];
        this.coefficients = new double[n];
        this.setupArrays();
    }

    public GeneralisedGaussLaguerreQuadrature(int n) {
        this.noPoints = n;
        this.abscissae = new double[n];
        this.coefficients = new double[n];
    }

    public void setB(double d) {
        this.B = d;
        this.setupArrays();
    }

    public void setAlpha(double d) {
        this.alpha = d;
        this.setupArrays();
    }

    public void setAlphaAndB(double d, double d2) {
        this.alpha = d;
        this.B = d2;
        this.setupArrays();
    }

    private void setupArrays() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i < this.noPoints; ++i) {
            if (i == 0) {
                d = (1.0 + this.alpha) * (3.0 + 0.92 * this.alpha) / (1.0 + 2.4 * (double)this.noPoints + 1.8 * this.alpha);
            } else if (i == 1) {
                d += (15.0 + 6.25 * this.alpha) / (1.0 + 0.9 * this.alpha + 2.5 * (double)this.noPoints);
            } else {
                double d6 = i - 1;
                d += ((1.0 + 2.55 * d6) / (1.9 * d6) + 1.26 * d6 * this.alpha / (1.0 + 3.5 * d6)) * (d - this.abscissae[i - 2]) / (1.0 + 0.3 * this.alpha);
            }
            boolean bl = true;
            for (int j = 0; j < 10; ++j) {
                d2 = 1.0;
                d3 = 0.0;
                for (int k = 0; k < this.noPoints; ++k) {
                    d4 = d3;
                    d3 = d2;
                    d2 = (((double)(2 * k + 1) + this.alpha - d) * d3 - ((double)k + this.alpha) * d4) / (double)(k + 1);
                }
                double d7 = d;
                d5 = ((double)this.noPoints * d2 - ((double)this.noPoints + this.alpha) * d3) / d;
                if (!(Math.abs((d = d7 - d2 / d5) - d7) <= 1.0E-14)) continue;
                bl = false;
                break;
            }
            if (bl) {
                throw new RuntimeException("Too many iterations");
            }
            this.abscissae[i] = d;
            this.coefficients[i] = -Math.exp(GammaFunction.lnGamma(this.alpha + (double)this.noPoints) - GammaFunction.lnGamma(this.noPoints)) / (d5 * (double)this.noPoints * d3);
        }
    }

    @Override
    public double integrate(UnivariateFunction univariateFunction, double d, double d2) {
        if (d2 != Double.POSITIVE_INFINITY) {
            throw new RuntimeException("Gauss-Laguerre quadrature is for integration with an infinite upper limit");
        }
        return this.integrate(univariateFunction, d);
    }

    public double logIntegrate(UnivariateFunction univariateFunction, double d, double d2) {
        if (d2 != Double.POSITIVE_INFINITY) {
            throw new RuntimeException("Gauss-Laguerre quadrature is for integration with an infinite upper limit");
        }
        return this.logIntegrate(univariateFunction, d);
    }

    public double integrate(UnivariateFunction univariateFunction, double d) {
        double d2 = 0.0;
        for (int i = 0; i < this.noPoints; ++i) {
            d2 += this.coefficients[i] * univariateFunction.evaluate(this.abscissae[i] / this.B + d);
        }
        return d2 *= 1.0 / Math.pow(this.B, this.alpha + 1.0);
    }

    public double logIntegrate(UnivariateFunction univariateFunction, double d) {
        try {
            double d2 = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < this.noPoints; ++i) {
                d2 = LogTricks.logSum(d2, Math.log(this.coefficients[i]) + ((UnivariateFunction.AbstractLogEvaluatableUnivariateFunction)univariateFunction).logEvaluate(d + this.abscissae[i] / this.B));
            }
            return d2 += -(this.alpha + 1.0) * Math.log(this.B);
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException(univariateFunction.toString() + " has no logEvaluate method");
        }
    }
}

