/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.inbound;

import com.amazon.jdbc.communications.interfaces.AbstractInboundMessage;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.core.IPGLogger;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.nio.ByteBuffer;

public class CopyData
extends AbstractInboundMessage
implements PGConstants {
    private int m_position = 0;
    private final byte[] m_data;

    public CopyData(ByteBuffer byteBuffer, int n, IPGLogger iPGLogger) throws ErrorException {
        try {
            this.m_data = new byte[n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            LogUtilities.logFatal("OutOfMemoryError:CopyData:Size=" + n + ":" + outOfMemoryError.getMessage(), (ILogger)iPGLogger);
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), outOfMemoryError.getMessage() + ":DataRowColumn:Size=" + n, (Throwable)outOfMemoryError);
            throw errorException;
        }
        this.read(byteBuffer);
        if (iPGLogger.isExternalLoggerEnabled()) {
            this.logMessageContent(iPGLogger);
        }
    }

    public void read(ByteBuffer byteBuffer) {
        int n = this.m_data.length - this.m_position;
        if (byteBuffer.remaining() < this.m_data.length - this.m_position) {
            n = byteBuffer.remaining();
        }
        byteBuffer.get(this.m_data, this.m_position, n);
        this.m_position += n;
    }

    public int getPosition() {
        return this.m_position;
    }

    public byte[] getData() {
        return this.m_data;
    }

    public boolean isCopyComplete() {
        return this.m_position == this.m_data.length;
    }

    public void logMessageContent(IPGLogger iPGLogger) {
        String string = "<=BE CopyData(" + this.m_data.length + ")";
        iPGLogger.logDebugExternal(string);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nCopyData: data - ");
        stringBuilder.append(new String(this.m_data));
        return stringBuilder.toString();
    }
}

