/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.stats.correlation;

import uk.ac.rhul.cs.stats.StatsUtils;
import uk.ac.rhul.cs.stats.datastructures.PairedData;
import uk.ac.rhul.cs.stats.descriptive.MeanVar;
import uk.ac.rhul.cs.stats.tests.SignificanceTest;

public class LinearCorrelation
implements SignificanceTest {
    protected PairedData data = null;
    protected Double cachedR = null;

    public LinearCorrelation(PairedData data) {
        this.data = data;
        this.cachedR = null;
    }

    public static double correlationCoeff(PairedData data) {
        return new LinearCorrelation(data).getR();
    }

    public int getN() {
        return this.data.getN();
    }

    public double getR() {
        if (this.cachedR != null) {
            return this.cachedR;
        }
        double[] x = this.data.getX();
        double[] y = this.data.getY();
        MeanVar mvX = new MeanVar(x);
        MeanVar mvY = new MeanVar(y);
        double meanX = mvX.getMean();
        double meanY = mvY.getMean();
        double cov = 0.0;
        int n = this.data.getN();
        for (int i = 0; i < n; ++i) {
            cov += (x[i] - meanX) * (y[i] - meanY);
        }
        this.cachedR = (cov /= (double)(n - 1)) / (mvX.getSd() * mvY.getSd());
        return this.cachedR;
    }

    public double getSP() {
        double r = this.getR();
        int n = this.getN();
        if (n <= 1) {
            return Double.NaN;
        }
        if (r >= 1.0 || r <= -1.0) {
            return 2.2E-16;
        }
        if (n <= 3) {
            return 1.0;
        }
        double f = 0.5 * Math.log1p(2.0 * r / (1.0 - r));
        double z = Math.sqrt(this.getN() - 3) * f;
        return 2.0 * StatsUtils.getZProbability(z);
    }

    public double getTestStatistic() {
        return this.getR();
    }
}

