/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.listener;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import net.sourceforge.jclec.AlgorithmEvent;
import net.sourceforge.jclec.IAlgorithmListener;
import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.IFitness;
import net.sourceforge.jclec.IIndividual;
import net.sourceforge.jclec.algorithm.PopulationAlgorithm;
import net.sourceforge.jclec.util.IndividualStatistics;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.builder.EqualsBuilder;

public class PopulationReporter
implements IAlgorithmListener,
IConfigure {
    private static final long serialVersionUID = -6866004037911080430L;
    private String reportTitle;
    private int reportFrequency;
    private boolean reportOnConsole;
    private boolean reportOnFile;
    private boolean saveCompletePopulation;
    private File reportFile;
    private FileWriter reportFileWriter;
    private File reportDirectory;

    public final String getReportTitle() {
        return this.reportTitle;
    }

    public final void setReportTitle(String reportTitle) {
        this.reportTitle = reportTitle;
    }

    public final int getReportFrequency() {
        return this.reportFrequency;
    }

    public final void setReportFrequency(int reportFrequency) {
        this.reportFrequency = reportFrequency;
    }

    public boolean isReportOnCconsole() {
        return this.reportOnConsole;
    }

    public final void setReportOnCconsole(boolean reportOnCconsole) {
        this.reportOnConsole = reportOnCconsole;
    }

    public final boolean isReportOnFile() {
        return this.reportOnFile;
    }

    public final void setReportOnFile(boolean reportOnFile) {
        this.reportOnFile = reportOnFile;
    }

    public final boolean isSaveCompletePopulation() {
        return this.saveCompletePopulation;
    }

    public final void setSaveCompletePopulation(boolean saveCompletePopulation) {
        this.saveCompletePopulation = saveCompletePopulation;
    }

    @Override
    public void configure(Configuration settings) {
        String reportTitle = settings.getString("report-title", "untitled");
        this.setReportTitle(reportTitle);
        int reportFrequency = settings.getInt("report-frequency", 10);
        this.setReportFrequency(reportFrequency);
        boolean reportOnConsole = settings.getBoolean("report-on-console", true);
        this.setReportOnCconsole(reportOnConsole);
        boolean reportOnFile = settings.getBoolean("report-on-file", false);
        this.setReportOnFile(reportOnFile);
        boolean saveCompletePopulation = settings.getBoolean("save-complete-population", false);
        this.setSaveCompletePopulation(saveCompletePopulation);
    }

    @Override
    public void algorithmStarted(AlgorithmEvent event) {
        String dateString = new Date(System.currentTimeMillis()).toString().replace(':', '.');
        String actualReportTitle = String.valueOf(this.reportTitle) + dateString;
        if (this.saveCompletePopulation) {
            this.reportDirectory = new File(actualReportTitle);
            if (!this.reportDirectory.mkdir()) {
                throw new RuntimeException("Error creating report directory");
            }
        }
        if (this.reportOnFile) {
            this.reportFile = new File(String.valueOf(actualReportTitle) + ".report.txt");
            try {
                this.reportFileWriter = new FileWriter(this.reportFile);
                this.reportFileWriter.flush();
                this.reportFileWriter.write(String.valueOf(dateString) + "\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.doIterationReport((PopulationAlgorithm)event.getAlgorithm(), true);
    }

    @Override
    public void iterationCompleted(AlgorithmEvent event) {
        this.doIterationReport((PopulationAlgorithm)event.getAlgorithm(), false);
    }

    @Override
    public void algorithmFinished(AlgorithmEvent event) {
        this.doIterationReport((PopulationAlgorithm)event.getAlgorithm(), true);
        if (this.reportOnFile && this.reportFile != null) {
            try {
                this.reportFileWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void algorithmTerminated(AlgorithmEvent e) {
    }

    public boolean equals(Object other) {
        if (other instanceof PopulationReporter) {
            PopulationReporter cother = (PopulationReporter)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.reportTitle, cother.reportTitle);
            eb.append(this.reportFrequency, cother.reportFrequency);
            eb.append(this.reportOnConsole, cother.reportOnConsole);
            eb.append(this.reportOnFile, cother.reportOnFile);
            eb.append(this.saveCompletePopulation, cother.saveCompletePopulation);
            return eb.isEquals();
        }
        return false;
    }

    protected void doIterationReport(PopulationAlgorithm algorithm, boolean force) {
        Comparator<IFitness> comparator = algorithm.getEvaluator().getComparator();
        List<IIndividual> inhabitants = algorithm.getInhabitants();
        int generation = algorithm.getGeneration();
        if (!force && generation % this.reportFrequency != 0) {
            return;
        }
        if (this.saveCompletePopulation) {
            String filename = "generation" + generation + ".individuals.txt";
            File file = new File(this.reportDirectory, filename);
            try {
                FileWriter filewriter = new FileWriter(file);
                for (IIndividual ind : inhabitants) {
                    filewriter.flush();
                    filewriter.write(ind + "\n");
                }
                filewriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        StringBuffer sb = new StringBuffer("Generation " + generation + " Report\n");
        IIndividual best = IndividualStatistics.bestIndividual(inhabitants, comparator);
        sb.append("Best individual: " + best + "\n");
        IIndividual worst = IndividualStatistics.worstIndividual(inhabitants, comparator);
        sb.append("Worst individual: " + worst + "\n");
        IIndividual median = IndividualStatistics.medianIndividual(inhabitants, comparator);
        sb.append("Median individual: " + median + "\n");
        double[] avgvar = IndividualStatistics.averageFitnessAndFitnessVariance(inhabitants);
        sb.append("Average fitness = " + avgvar[0] + "\n");
        sb.append("Fitness variance = " + avgvar[1] + "\n");
        if (this.reportOnConsole) {
            System.out.println(sb.toString());
        }
        if (this.reportOnFile) {
            try {
                this.reportFileWriter.write(sb.toString());
                this.reportFileWriter.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

