/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Thrift;

import java.io.IOException;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Thrift.BaseD;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Thrift.BaseR;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Thrift.GA;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Thrift.Individuo;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Thrift.myDataset;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Thrift.parseParameters;
import org.core.Fichero;
import org.core.Randomize;

public class Thrift {
    myDataset train;
    myDataset val;
    myDataset test;
    String outputTr;
    String outputTst;
    String outputEvo;
    String outputTh;
    long seed;
    int populationSize;
    int nEvaluations;
    int nLabels;
    double crossProb;
    double mutProb;
    int n_genes;
    BaseD baseDatos;
    BaseR baseReglas;
    private boolean somethingWrong = false;

    public Thrift() {
    }

    public Thrift(parseParameters parameters) {
        this.train = new myDataset();
        this.val = new myDataset();
        this.test = new myDataset();
        try {
            System.out.println("\nReading the training set: " + parameters.getTrainingInputFile());
            this.train.readRegressionSet(parameters.getTrainingInputFile(), true);
            System.out.println("\nReading the validation set: " + parameters.getValidationInputFile());
            this.val.readRegressionSet(parameters.getValidationInputFile(), false);
            System.out.println("\nReading the test set: " + parameters.getTestInputFile());
            this.test.readRegressionSet(parameters.getTestInputFile(), false);
        }
        catch (IOException e) {
            System.err.println("There was a problem while reading the input data-sets: " + e);
            this.somethingWrong = true;
        }
        this.somethingWrong = this.somethingWrong || this.train.hasMissingAttributes();
        this.outputTr = parameters.getTrainingOutputFile();
        this.outputTst = parameters.getTestOutputFile();
        this.outputEvo = parameters.getOutputFile(0);
        this.outputTh = parameters.getOutputFile(1);
        this.seed = Long.parseLong(parameters.getParameter(0));
        this.nLabels = Integer.parseInt(parameters.getParameter(1));
        this.populationSize = Integer.parseInt(parameters.getParameter(2));
        this.nEvaluations = Integer.parseInt(parameters.getParameter(3));
        this.crossProb = Double.parseDouble(parameters.getParameter(4));
        this.mutProb = Double.parseDouble(parameters.getParameter(5));
    }

    public void execute() {
        if (this.somethingWrong) {
            System.err.println("An error was found, either the data-set has missing values.");
            System.err.println("Please remove the examples with missing data or apply a MV preprocessing.");
            System.err.println("Aborting the program");
        } else {
            Randomize.setSeed(this.seed);
            this.n_genes = 1;
            for (int i = 0; i < this.train.getnInputs(); ++i) {
                this.n_genes *= this.nLabels;
            }
            this.crossProb = this.crossProb * (double)this.populationSize - 0.5;
            this.mutProb /= (double)this.n_genes;
            this.baseDatos = new BaseD(this.nLabels, this.train.getnVars(), this.train.devuelveRangos());
            this.baseDatos.Semantica();
            this.baseReglas = new BaseR(this.n_genes, this.baseDatos, this.train);
            GA genetico = new GA(this.train, this.test, this.baseDatos, this.baseReglas, this.populationSize, this.nEvaluations, this.n_genes, this.crossProb, this.mutProb, this.outputEvo);
            Individuo solucion = genetico.lanzar();
            this.generaSalida(solucion);
            this.doOutput(this.val, this.outputTr);
            this.doOutput(this.test, this.outputTst);
            System.out.println("Algorithm Finished");
        }
    }

    private void doOutput(myDataset dataset, String filename) {
        String output = new String("");
        output = dataset.copyHeader();
        for (int i = 0; i < dataset.getnData(); ++i) {
            output = output + dataset.getOutputAsReal(i) + " " + this.classificationOutput(dataset.getExample(i)) + "\n";
        }
        Fichero.escribeFichero(filename, output);
    }

    private double classificationOutput(double[] example) {
        return this.baseReglas.FLC(example, this.baseReglas.n_reglas);
    }

    private void generaSalida(Individuo solucion) {
        int n_reg = this.baseReglas.decodifica(solucion.getGene());
        String salida = new String("");
        salida = salida + "Numero de reglas: " + n_reg + "\n\n";
        salida = salida + this.baseReglas.BRtoString();
        double ec_tra = GA.Error(this.val, n_reg);
        double ec_tst = GA.Error(this.test, n_reg);
        int Trials_mejor = GA.dameTrials();
        salida = salida + "\nECMtra: " + ec_tra + ",  ECMtst: " + ec_tst + ",  EMS: " + Trials_mejor + "\n";
        for (int i = 0; i < this.train.getnInputs(); ++i) {
            salida = salida + "Variable de entrada = " + (i + 1) + "\n";
            salida = salida + "Numero de etiquetas = " + this.baseDatos.getnLabels(i) + "\n";
            salida = salida + "Universo de discurso = [" + this.baseDatos.getExtremoInf(i) + "," + this.baseDatos.getExtremoSup(i) + "]\n\n";
        }
        salida = salida + "Variable de salida = 1\n";
        salida = salida + "Numero de etiquetas = " + this.baseDatos.getnLabels(this.baseDatos.n_var_estado - 1) + "\n";
        salida = salida + "Universo de discurso = [" + this.baseDatos.getExtremoInf(this.baseDatos.n_var_estado - 1) + "," + this.baseDatos.getExtremoSup(this.baseDatos.n_var_estado - 1) + "]\n\n";
        salida = salida + "\n\nBase de Datos inicial: \n";
        salida = salida + this.baseDatos.printString();
        salida = salida + "\n--------------------------------------------------------------------\n\n";
        Fichero.escribeFichero(this.outputTh, salida);
        System.out.println("ECMtra: " + ec_tra + ", ECMtst: " + ec_tst + ", #R: " + n_reg + ", EMS: " + Trials_mejor);
    }
}

