/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.muc;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import opennlp.tools.formats.muc.DocumentSplitterStream;
import opennlp.tools.formats.muc.MucCorefContentHandler;
import opennlp.tools.formats.muc.RawCorefSample;
import opennlp.tools.formats.muc.SgmlParser;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MucCorefSampleStream
extends FilterObjectStream<String, RawCorefSample> {
    private final Tokenizer tokenizer;
    private List<RawCorefSample> documents = new ArrayList<RawCorefSample>();

    public MucCorefSampleStream(Tokenizer tokenizer, ObjectStream<String> documents) {
        super(new DocumentSplitterStream(documents));
        this.tokenizer = tokenizer;
    }

    @Override
    public RawCorefSample read() throws IOException {
        String document;
        if (this.documents.isEmpty() && (document = (String)this.samples.read()) != null) {
            new SgmlParser().parse(new StringReader(document), new MucCorefContentHandler(this.tokenizer, this.documents));
        }
        if (this.documents.size() > 0) {
            return this.documents.remove(0);
        }
        return null;
    }
}

