## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.width = 9,
  fig.height = 5,
  out.width = "100%"
)


library(archipelago)

## -----------------------------------------------------------------------------
data("vsat_pval", package = "archipelago")
data("variant_pval", package = "archipelago")

head(vsat_pval)
head(variant_pval)

## -----------------------------------------------------------------------------
p_basic <- archipelago_plot(
  df1 = vsat_pval,
  df2 = variant_pval,
  output_path = tempfile(),
  output_raw  = tempfile()
)

p_basic

## -----------------------------------------------------------------------------
p_theme <- archipelago_plot(
  df1 = vsat_pval,
  df2 = variant_pval,
  color_theme = "alice",
  output_path = tempfile(),
  output_raw  = tempfile()
)

p_theme

## -----------------------------------------------------------------------------
custom_colors <- c("#9abfd8", "#cac1f3", "#371c4b", "#2a5b7f")

p_custom <- archipelago_plot(
  df1 = vsat_pval,
  df2 = variant_pval,
  add_title = TRUE,
  plot_title = "Custom Archipelago Plot",
  add_subtitle = TRUE,
  plot_subtitle = "Variant set and variant signals",
  show_legend = TRUE,
  legend_position = "bottom",
  chr_ticks = TRUE,
  point_size = 0.6,
  point_size_large = 1.2,
  custom_colors = custom_colors,
  color_labels = c(
    "Chromosome A",
    "Chromosome B",
    "Highlighted variants",
    "Variant set result"
  ),
  crit_val_VSAT = 0.05 / 300,
  crit_val_single_variant = 5e-8,
  annotate_thresholds = TRUE,
  fig_width = 10,
  fig_height = 5,
  output_path = tempfile(),
  output_raw  = tempfile(),
  file_type = "pdf"
)

p_custom

