/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1.Rinterface.arules;

import eu.kliegr.ac1.PruningEnum;
import eu.kliegr.ac1.RuleLearningAlgEnum;
import eu.kliegr.ac1.RuleLearningConfig;
import eu.kliegr.ac1.data.AttributeValue;
import eu.kliegr.ac1.data.DataTable;
import eu.kliegr.ac1.data.parsers.CSVparser;
import eu.kliegr.ac1.rule.Data;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Collection;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RuleLearning {
    private static final Logger LOGGER = Logger.getLogger(RuleLearning.class.getName());

    public static String formatrCBArscript(RuleLearningConfig conf) throws Exception {
        StringBuilder Rcode = new StringBuilder();
        Rcode.append("library(methods) # this has to be explicitly loaded when executing via Rscript \n");
        Rcode.append("library(arules) # load lib + \n");
        Rcode.append("library(rCBA) # load lib + \n");
        Rcode.append("train <- read.csv(\"").append(conf.getDataPath()).append("\",header=TRUE, check.names=FALSE, sep = \"").append(conf.getCSVSeparator()).append("\") # load csv + \n");
        Rcode.append("train[train==\"\"] <-NA \n");
        if (conf.getIDcolumnName() != null) {
            Rcode.append("train <- subset( train, select = -c (").append(conf.getIDcolumnName()).append(") ) # remove id column\n");
        }
        Rcode.append("output <- rCBA::build(train)\n");
        Rcode.append("rules <- output$model\n");
        Rcode.append("write.csv(rules, \"").append(conf.getOutputPath()).append("\", row.names=TRUE,quote = TRUE)\n");
        Rcode.append("cat(paste(\"confidence,support,maxlen\n\",output$confidence,\",\",output$support,\",\",output$maxlen),file=\"").append(conf.getOutputPath("opt")).append("\")");
        return Rcode.toString();
    }

    public static Data learnRules(RuleLearningConfig conf) throws Exception {
        String Rcode;
        String scriptName;
        LOGGER.log(Level.INFO, "Input CSV {0}", conf.getDataPath());
        Data rmi = CSVparser.parseFromCSVwithHeader(conf.getDataPath(), conf.getTargetAttribute(), conf.getAttributeType(), conf.getIDcolumnName(), conf.getCSVSeparator());
        DataTable train = rmi.getDataTable();
        float minSup = train.getMinSupportThreshold(1000);
        Collection<AttributeValue> targetAttValues = train.getTargetAttribute().getAllValues();
        String targetAttName = train.getTargetAttribute().getName();
        String scriptID = Integer.toString(ThreadLocalRandom.current().nextInt(1, 1000000));
        if (conf.getAlgorithm() == RuleLearningAlgEnum.arules | conf.getAlgorithm() == RuleLearningAlgEnum.arulesrCBApruning) {
            scriptName = "temp/arules_" + scriptID + ".R";
            Rcode = RuleLearning.formatArulesRscript(conf, targetAttValues, targetAttName, minSup, conf.getAlgorithm());
        } else if (conf.getAlgorithm() == RuleLearningAlgEnum.rCBAauto) {
            scriptName = "temp/rcba_" + scriptID + ".R";
            Rcode = RuleLearning.formatrCBArscript(conf);
        } else if (conf.getAlgorithm() == RuleLearningAlgEnum.arcCBA) {
            scriptName = "temp/arccba_" + scriptID + ".R";
            Rcode = RuleLearning.formatARCrscript(conf);
        } else {
            throw new Exception("Unsupported algorithm");
        }
        File Rscript = new File(scriptName);
        FileOutputStream os = new FileOutputStream(Rscript);
        PrintStream printStream = new PrintStream(os);
        printStream.print(Rcode);
        printStream.close();
        RuleLearning.execRscript(Rscript.getAbsolutePath(), conf.getOutputPath());
        return rmi;
    }

    private static String formatArulesRscript(RuleLearningConfig conf, Collection<AttributeValue> targetAttValues, String targetAttName, float minSup, RuleLearningAlgEnum alg) {
        StringBuilder Rcode = new StringBuilder();
        Rcode.append("library(methods) # this has to be explicitly loaded when executing via Rscript \n");
        Rcode.append("library(R.utils) # load lib + \n");
        Rcode.append("library(arules) # load lib + \n");
        if (alg == RuleLearningAlgEnum.arulesrCBApruning) {
            Rcode.append("library(rCBA)\n");
        }
        Rcode.append("train <- read.csv(\"").append(conf.getDataPath()).append("\",header=TRUE, check.names=FALSE, sep = \"").append(conf.getCSVSeparator()).append("\") # load csv + \n");
        Rcode.append("train[train==\"\"] <-NA \n");
        if (conf.getIDcolumnName() != null) {
            Rcode.append("train <- subset( train, select = -c (").append(conf.getIDcolumnName()).append(") ) # remove id column\n");
        }
        Rcode.append("txns <- as(train,\"transactions\")\n");
        Rcode.append("conf=").append(conf.getMinConfidence()).append("\n");
        LOGGER.log(Level.INFO, "Ignoring set minSup, using autodetected value:{0}", Float.valueOf(minSup));
        Rcode.append("confEpsilon=").append(conf.getConfEpsilon()).append("\n");
        Rcode.append("maxExecTimeIter=").append(conf.getMaxExecTimeIter()).append("\n");
        Rcode.append("maxExecTimeTotal=").append(conf.getMaxExecTimeTotal()).append("\n");
        Rcode.append("support=").append(minSup).append("\n");
        Rcode.append("minlen=").append(conf.getMinLen()).append("\n");
        Rcode.append("maxlen=").append(conf.getMaxLen()).append("\n");
        Rcode.append("targetRuleCount=").append(conf.getTargetRuleCount()).append("\n");
        StringBuilder arulesLine = new StringBuilder();
        arulesLine.append("rules <- apriori(txns, parameter = list(confidence = conf");
        arulesLine.append(", support= support");
        arulesLine.append(", minlen= minlen");
        arulesLine.append(", maxlen= maxlen");
        arulesLine.append("),appearance = list(rhs = c(");
        int counter = 0;
        for (AttributeValue val : targetAttValues) {
            arulesLine.append("\"");
            arulesLine.append(targetAttName);
            arulesLine.append("=");
            arulesLine.append(val.getValue());
            arulesLine.append("\"");
            if (++counter >= targetAttValues.size()) continue;
            arulesLine.append(", ");
        }
        arulesLine.append("),default=\"lhs\"));");
        Rcode.append("iteration_time_limit_exceeded=0\nflag=TRUE\n start.time <- Sys.time()\nlastrulecount <- -1\nwhile(flag)\n{\n    tryCatch(\n    {\n        rules <- evalWithTimeout({##arulesline##},timeout=maxExecTimeIter, onTimeout=\"error\");\n        rulecount=length(rules)\n        print(paste(\"Rule count:  \",rulecount))\n        if (rulecount >= targetRuleCount)\n        {\n            flag<<-FALSE\n            print(paste(\"Target rule count satisfied:  \",targetRuleCount))\n        }\n        else{\n           exectime = Sys.time() -start.time \nif (exectime > maxExecTimeTotal)\n             {\n               print(paste(\"Max execution time exceeded:  \",maxlen))\n               flag<<-FALSE\n            }\n            else if (maxlen < dim(train)[2]-1 & lastrulecount!=rulecount)\n            {                \n                maxlen<<-maxlen+1\nlastrulecount  <- rulecount\n                print(paste(\"Increasing maxlen to:  \",maxlen))\n            }\n            else if (conf > confEpsilon){                \n                conf<<-conf-confEpsilon\n                print(paste(\"Decreasing confidence to:  \",conf))\nlastrulecount  <-  -1\n            }\n            else{\n                print(\"All options exhausted\")\n                flag<<-FALSE\n            }\n        }\n\n    }, error= function(err)\n    {\n        print(paste(\"Individual exec time exceeded:  \",err))\n iteration_time_limit_exceeded=iteration_time_limit_exceeded+1\nexectime = Sys.time() -start.time \n             if (exectime > maxExecTimeTotal)\n        {\n          print(paste(\"Max execution time exceeded:  \",maxlen))\n          flag=FALSE\n        } \n else if (maxlen > 1)\n        {\n            maxlen<<-maxlen-1\n            print(paste(\"Decreasing maxlen to:  \",maxlen))\n        }\n        else{\n            print(\"All options exhausted - returning no rules\")\n            flag<<-FALSE\n        }        \n    })\n}\n");
        Rcode.append("exectime = Sys.time() -start.time \n");
        if (alg == RuleLearningAlgEnum.arulesrCBApruning) {
            Rcode.append("rules <- rCBA::pruning(train, rules, method=\"m2cba\") \n");
        }
        Rcode.append("write.csv(as(rules,\"data.frame\"), \"").append(conf.getOutputPath()).append("\", row.names=TRUE,quote = TRUE)\n");
        Rcode.append("cat(paste(\"confidence,support,maxlen,totalexectime,number of times local exec time exceeded\n\",conf,\",\",support,\",\",maxlen,\",\",exectime,\",\",iteration_time_limit_exceeded),file=\"").append(conf.getOutputPath("opt")).append("\")");
        return Rcode.toString().replace("##arulesline##", arulesLine);
    }

    private static void execRscript(String scriptPath, String outputPath) throws IOException, Exception, InterruptedException {
        LOGGER.log(Level.INFO, "Started executing R script:{0}", scriptPath);
        Process p = Runtime.getRuntime().exec("Rscript " + scriptPath);
        BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
        while (reader.readLine() != null) {
        }
        p.waitFor();
        int exitValue = p.exitValue();
        if (exitValue != 0) {
            LOGGER.log(Level.INFO, "R exit value {0} (NOT OK)", exitValue);
            throw new Exception("R program execution failed. Program is at " + scriptPath);
        }
        LOGGER.log(Level.INFO, "R exit value {0} (OK)", exitValue);
        LOGGER.log(Level.INFO, "Rules written to {0}", outputPath);
    }

    private static void _execRscript(String scriptPath, String outputPath) throws IOException, Exception, InterruptedException {
        Process p = Runtime.getRuntime().exec("Rscript " + scriptPath);
        p.waitFor();
        int exitValue = p.exitValue();
        if (exitValue != 0) {
            LOGGER.log(Level.INFO, "R exit value {0} (NOT OK)", exitValue);
            throw new Exception("R program execution failed. Program is at " + scriptPath);
        }
        LOGGER.log(Level.INFO, "R exit value {0} (OK)", exitValue);
        LOGGER.log(Level.INFO, "Rules written to {0}", outputPath);
    }

    private static String formatARCrscript(RuleLearningConfig conf) {
        StringBuilder Rcode = new StringBuilder();
        Rcode.append("library(arc) # load lib + \n");
        Object idColumn = conf.getIDcolumnName() == null ? "" : "\"" + conf.getIDcolumnName() + "\"";
        String rulelearning_options = "list(target_rule_count=" + conf.getTargetRuleCount() + ")";
        Object pruning_options = conf.getPruning() == PruningEnum.CBA ? "TRUE" : "FALSE";
        pruning_options = "list(default_rule_pruning=" + (String)pruning_options + ")";
        Rcode.append("cbaCSV(path=\"").append(conf.getDataPath()).append("\",classatt=\"").append(conf.getTargetAttribute()).append("\",idcolumn=").append((String)idColumn).append(",rulelearning_options=").append(rulelearning_options).append(",pruning_options=").append((String)pruning_options).append(",outpath=\"").append(conf.getOutputPath()).append("\")");
        return Rcode.toString();
    }

    private RuleLearning() {
    }
}

