/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices;

import java.util.Arrays;
import java.util.function.DoublePredicate;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.util.IntList;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixException;
import lombok.Generated;
import lombok.NonNull;

public final class MatrixFactory {
    public static FastMatrix rowMatrix(DoubleSeq data) {
        return new FastMatrix(data.toArray(), 1, data.length());
    }

    public static FastMatrix columnMatrix(DoubleSeq data) {
        return new FastMatrix(data.toArray(), data.length(), 1);
    }

    public static FastMatrix rowBind(Matrix ... M) {
        if (M == null) {
            throw new NullPointerException("M is marked non-null but is null");
        }
        int nr = 0;
        int nc = 0;
        for (int i = 0; i < M.length; ++i) {
            if (M[i] == null) continue;
            nr += M[i].getRowsCount();
            if (nc == 0) {
                nc = M[i].getColumnsCount();
                continue;
            }
            if (M[i].getColumnsCount() == nc) continue;
            throw new MatrixException("m_err_dim");
        }
        FastMatrix all = new FastMatrix(nr, nc);
        DataBlockIterator rows = all.rowsIterator();
        for (int i = 0; i < M.length; ++i) {
            if (M[i] == null) continue;
            int ncur = M[i].getRowsCount();
            for (int j = 0; j < ncur; ++j) {
                rows.next().copy(M[i].row(j));
            }
        }
        return all;
    }

    public static FastMatrix columnBind(Matrix ... M) {
        if (M == null) {
            throw new NullPointerException("M is marked non-null but is null");
        }
        int nr = 0;
        int nc = 0;
        for (int i = 0; i < M.length; ++i) {
            if (M[i] == null) continue;
            nc += M[i].getColumnsCount();
            if (nr == 0) {
                nr = M[i].getRowsCount();
                continue;
            }
            if (M[i].getRowsCount() == nr) continue;
            throw new MatrixException("m_err_dim");
        }
        FastMatrix all = new FastMatrix(nr, nc);
        DataBlockIterator cols = all.columnsIterator();
        for (int i = 0; i < M.length; ++i) {
            if (M[i] == null) continue;
            int ncur = M[i].getColumnsCount();
            for (int j = 0; j < ncur; ++j) {
                cols.next().copy(M[i].column(j));
            }
        }
        return all;
    }

    public static FastMatrix select(FastMatrix m, IntList selectedRows, IntList selectedColumns) {
        if (m == null) {
            return null;
        }
        if (selectedRows == null) {
            return MatrixFactory.selectColumns(m, selectedColumns);
        }
        if (selectedColumns == null) {
            return MatrixFactory.selectRows(m, selectedRows);
        }
        FastMatrix s = FastMatrix.make(selectedRows.size(), selectedColumns.size());
        double[] ps = s.getStorage();
        double[] pm = m.getStorage();
        int scur = 0;
        for (int c = 0; c < s.ncols; ++c) {
            DataBlock mcol = m.column(selectedColumns.get(c));
            int mcur = mcol.getStartPosition();
            for (int r = 0; r < s.nrows; ++r) {
                ps[scur++] = pm[mcur + selectedRows.get(r)];
            }
        }
        return s;
    }

    public static FastMatrix selectRows(FastMatrix m, IntList selectedRows) {
        if (m == null) {
            return null;
        }
        if (selectedRows == null) {
            return m;
        }
        FastMatrix s = FastMatrix.make(selectedRows.size(), m.ncols);
        double[] ps = s.getStorage();
        double[] pm = m.getStorage();
        int scur = 0;
        DataBlockIterator cols = m.columnsIterator();
        while (cols.hasNext()) {
            DataBlock mcol = cols.next();
            int mcur = mcol.getStartPosition();
            for (int r = 0; r < s.nrows; ++r) {
                ps[scur++] = pm[mcur + selectedRows.get(r)];
            }
        }
        return s;
    }

    public static FastMatrix selectColumns(FastMatrix m, @NonNull IntList selectedColumns) {
        if (selectedColumns == null) {
            throw new NullPointerException("selectedColumns is marked non-null but is null");
        }
        if (m == null) {
            return null;
        }
        if (selectedColumns == null) {
            return m;
        }
        FastMatrix s = FastMatrix.make(m.nrows, selectedColumns.size());
        double[] ps = s.getStorage();
        int scur = 0;
        for (int c = 0; c < s.ncols; ++c) {
            DataBlock mcol = m.column(selectedColumns.get(c));
            mcol.copyTo(ps, scur);
            scur += s.nrows;
        }
        return s;
    }

    public static FastMatrix selectRows(FastMatrix m, @NonNull int[] selectedRows) {
        if (selectedRows == null) {
            throw new NullPointerException("selectedRows is marked non-null but is null");
        }
        if (m == null) {
            return null;
        }
        if (selectedRows == null) {
            return m;
        }
        FastMatrix s = FastMatrix.make(selectedRows.length, m.ncols);
        double[] ps = s.getStorage();
        double[] pm = m.getStorage();
        int scur = 0;
        DataBlockIterator cols = m.columnsIterator();
        while (cols.hasNext()) {
            DataBlock mcol = cols.next();
            int mcur = mcol.getStartPosition();
            for (int r = 0; r < s.nrows; ++r) {
                ps[scur++] = pm[mcur + selectedRows[r]];
            }
        }
        return s;
    }

    public static FastMatrix selectColumns(FastMatrix m, @NonNull int[] selectedColumns) {
        if (selectedColumns == null) {
            throw new NullPointerException("selectedColumns is marked non-null but is null");
        }
        if (m == null) {
            return null;
        }
        if (selectedColumns == null) {
            return m;
        }
        FastMatrix s = FastMatrix.make(m.nrows, selectedColumns.length);
        double[] ps = s.getStorage();
        int scur = 0;
        for (int c = 0; c < s.ncols; ++c) {
            DataBlock mcol = m.column(selectedColumns[c]);
            mcol.copyTo(ps, scur);
            scur += s.nrows;
        }
        return s;
    }

    public static FastMatrix embed(DoubleSeq x, int dim) {
        int n = x.length();
        if (dim > n) {
            throw new IllegalArgumentException();
        }
        int m = n - dim + 1;
        FastMatrix E = FastMatrix.make(m, dim);
        double[] pe = E.getStorage();
        int i = dim - 1;
        int j = 0;
        while (i >= 0) {
            x.range(i, i + m).copyTo(pe, j);
            --i;
            j += m;
        }
        return E;
    }

    public static FastMatrix embed(FastMatrix X, int dim) {
        int n = X.nrows;
        int q = X.getColumnsCount();
        if (dim > n) {
            throw new IllegalArgumentException();
        }
        int m = n - dim + 1;
        FastMatrix E = FastMatrix.make(m, q * dim);
        double[] pe = E.getStorage();
        int j = 0;
        for (int i = dim - 1; i >= 0; --i) {
            int k = 0;
            while (k < q) {
                X.column(k).range(i, i + m).copyTo(pe, j);
                ++k;
                j += m;
            }
        }
        return E;
    }

    public static FastMatrix delta(FastMatrix X, int lag, int pow) {
        if (X.isEmpty()) {
            return X;
        }
        if (pow <= 0 || lag <= 0) {
            throw new IllegalArgumentException();
        }
        if (pow > 1) {
            return MatrixFactory.delta(MatrixFactory.delta(X, lag, 1), lag, pow - 1);
        }
        int n = X.nrows;
        int m = X.ncols;
        if (n < lag) {
            return FastMatrix.make(0, m);
        }
        FastMatrix D = FastMatrix.make(n - lag, m);
        double[] pd = D.getStorage();
        double[] px = X.getStorage();
        int i = 0;
        int j = 0;
        int k = X.start;
        while (i < m) {
            int rmax = k + D.nrows;
            int r = k;
            while (r < rmax) {
                pd[j] = px[r + lag] - px[r];
                ++r;
                ++j;
            }
            ++i;
            k += X.getColumnIncrement();
        }
        return D;
    }

    public static FastMatrix select(FastMatrix M, int[] selectedRows, int[] selectedColumns) {
        if (selectedRows == null) {
            return MatrixFactory.selectColumns(M, selectedColumns);
        }
        if (selectedColumns == null) {
            return MatrixFactory.selectRows(M, selectedRows);
        }
        FastMatrix m = new FastMatrix(selectedRows.length, selectedColumns.length);
        for (int c = 0; c < selectedRows.length; ++c) {
            for (int r = 0; r < selectedRows.length; ++r) {
                m.set(r, c, M.get(selectedRows[r], selectedColumns[c]));
            }
        }
        return m;
    }

    public static FastMatrix exclude(FastMatrix M, int[] excludedRows, int[] excludedColumns) {
        int cur;
        int i;
        int[] srx = (int[])excludedRows.clone();
        Arrays.sort(srx);
        int[] scx = (int[])excludedColumns.clone();
        Arrays.sort(scx);
        int nrows = M.getRowsCount();
        int ncols = M.getColumnsCount();
        boolean[] rx = new boolean[nrows];
        boolean[] cx = new boolean[ncols];
        int nrx = 0;
        int ncx = 0;
        for (i = 0; i < srx.length; ++i) {
            cur = srx[i];
            if (rx[cur]) continue;
            rx[cur] = true;
            ++nrx;
        }
        for (i = 0; i < scx.length; ++i) {
            cur = scx[i];
            if (cx[cur]) continue;
            cx[cur] = true;
            ++ncx;
        }
        if (nrx == 0 && ncx == 0) {
            return M.deepClone();
        }
        FastMatrix m = new FastMatrix(nrows - nrx, ncols - ncx);
        int nc = 0;
        for (int c = 0; c < ncols; ++c) {
            if (!cx[c]) continue;
            int nr = 0;
            for (int r = 0; r < nrows; ++r) {
                if (!rx[r]) continue;
                m.set(nr, nc, M.get(r, c));
                ++nr;
            }
            ++nc;
        }
        return m;
    }

    public static FastMatrix expand(FastMatrix M, int nr, int[] rowPos, int nc, int[] colPos) {
        if (rowPos.length != nr || colPos.length != nc) {
            throw new MatrixException("m_err_dim");
        }
        FastMatrix m = new FastMatrix(nr, nc);
        int nrows = M.getRowsCount();
        int ncols = M.getColumnsCount();
        for (int c = 0; c < ncols; ++c) {
            for (int r = 0; r < nrows; ++r) {
                m.set(rowPos[r], colPos[c], M.get(r, c));
            }
        }
        return m;
    }

    public static FastMatrix cleanRows(FastMatrix M, @NonNull DoublePredicate pred, @NonNull IntList selection) {
        if (pred == null) {
            throw new NullPointerException("pred is marked non-null but is null");
        }
        if (selection == null) {
            throw new NullPointerException("selection is marked non-null but is null");
        }
        selection.clear();
        DataBlockIterator rows = M.rowsIterator();
        int pos = 0;
        while (rows.hasNext()) {
            if (rows.next().allMatch(pred)) {
                selection.add(pos);
            }
            ++pos;
        }
        if (selection.size() == M.nrows) {
            return M;
        }
        return MatrixFactory.selectRows(M, selection);
    }

    @Generated
    private MatrixFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

