/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.data;

import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class Interval {
    private final double lowerBound;
    private final double upperBound;

    public double getLength() {
        return this.upperBound - this.lowerBound;
    }

    public boolean isPoint() {
        return this.upperBound == this.lowerBound;
    }

    public boolean isValid() {
        return this.upperBound >= this.lowerBound;
    }

    public boolean contains(double pt) {
        return this.lowerBound <= pt && pt <= this.upperBound;
    }

    @Generated
    public Interval(double lowerBound, double upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    @Generated
    public double getLowerBound() {
        return this.lowerBound;
    }

    @Generated
    public double getUpperBound() {
        return this.upperBound;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Interval)) {
            return false;
        }
        Interval other = (Interval)o;
        if (Double.compare(this.getLowerBound(), other.getLowerBound()) != 0) {
            return false;
        }
        return Double.compare(this.getUpperBound(), other.getUpperBound()) == 0;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $lowerBound = Double.doubleToLongBits(this.getLowerBound());
        result = result * 59 + (int)($lowerBound >>> 32 ^ $lowerBound);
        long $upperBound = Double.doubleToLongBits(this.getUpperBound());
        result = result * 59 + (int)($upperBound >>> 32 ^ $upperBound);
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "Interval(lowerBound=" + this.getLowerBound() + ", upperBound=" + this.getUpperBound() + ")";
    }
}

