% Generated by roxygen2: do not edit by hand
\name{dotchart}
\alias{dotchart}
\title{Dot Charts (Cleveland Dot Plots)}
\arguments{
  \item{x}{numeric vector (or matrix) of values to plot}
  \item{labels}{character vector for point labels}
  \item{groups}{factor (same length as `x`) defining groups}
  \item{...}{\{.help [graphical parameters](graphics::par)\}, e.g. `pch`, `col`
}
}

\details{
Basic dot chart of a frequency table
\code{
counts <- xtabs(~ gear, data = mtcars)
dotchart(counts)
}

Label individual observations with custom style
\code{
dotchart(mtcars$mpg, labels = rownames(mtcars), cex = 0.6, color = "steelblue")
}

Grouped dot chart coloured by group
\code{
matching_ndcs <- match(mtcars$cyl, c(4, 6, 8))
cols <- c("firebrick", "gray40", "forestgreen")
labs <- rownames(mtcars)
dotchart(mtcars$mpg, groups = mtcars$cyl, color  = cols[matching_ndcs],
         pch = 19, cex = 0.75, labels = labs)
}}

