/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evolution.tree.Tree;
import dr.evomodel.continuous.FullyConjugateMultivariateTraitLikelihood;
import dr.evomodel.continuous.MultivariateTraitUtils;
import dr.inference.distribution.ParametricMultivariateDistributionModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.distributions.MultivariateNormalDistribution;
import dr.math.distributions.RandomGenerator;

public class TreeTraitNormalDistributionModel
extends AbstractModel
implements ParametricMultivariateDistributionModel,
RandomGenerator {
    private final FullyConjugateMultivariateTraitLikelihood traitModel;
    private double[] mean;
    private double[][] precision;
    private MultivariateNormalDistribution distribution;
    private MultivariateNormalDistribution storedDistribution;
    private boolean distributionKnown;
    private boolean storedDistributionKnown;
    private final boolean conditionOnRoot;
    private double[][] precisionMatrix = null;
    private double[] rootValue;
    private final int dim;

    public TreeTraitNormalDistributionModel(FullyConjugateMultivariateTraitLikelihood fullyConjugateMultivariateTraitLikelihood, Parameter parameter, boolean bl) {
        super("multivariateNormalDistributionModel");
        this.traitModel = fullyConjugateMultivariateTraitLikelihood;
        if (parameter != null) {
            this.rootValue = parameter.getParameterValues();
        }
        this.conditionOnRoot = bl;
        this.dim = fullyConjugateMultivariateTraitLikelihood.getTreeModel().getExternalNodeCount() * fullyConjugateMultivariateTraitLikelihood.getDimTrait();
        this.addModel(fullyConjugateMultivariateTraitLikelihood);
        this.distributionKnown = false;
    }

    public TreeTraitNormalDistributionModel(FullyConjugateMultivariateTraitLikelihood fullyConjugateMultivariateTraitLikelihood, boolean bl) {
        this(fullyConjugateMultivariateTraitLikelihood, null, bl);
    }

    public Tree getTree() {
        return this.traitModel.getTreeModel();
    }

    @Override
    public double logPdf(double[] dArray) {
        this.checkDistribution();
        return this.distribution.logPdf(dArray);
    }

    @Override
    public double[][] getScaleMatrix() {
        this.checkDistribution();
        return this.distribution.getScaleMatrix();
    }

    @Override
    public double[] getMean() {
        this.checkDistribution();
        return this.distribution.getMean();
    }

    @Override
    public String getType() {
        return "TreeTraitMVN";
    }

    public int getDimTrait() {
        return this.traitModel.dimTrait;
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
        this.distributionKnown = false;
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.distributionKnown = false;
    }

    @Override
    protected void storeState() {
        this.storedDistribution = this.distribution;
        this.storedDistributionKnown = this.distributionKnown;
    }

    @Override
    protected void restoreState() {
        this.distributionKnown = this.storedDistributionKnown;
        this.distribution = this.storedDistribution;
    }

    @Override
    protected void acceptState() {
    }

    private void checkDistribution() {
        if (!this.distributionKnown) {
            this.mean = null;
            this.precision = null;
            this.distribution = this.createNewDistribution();
            this.distributionKnown = true;
        }
    }

    private MultivariateNormalDistribution createNewDistribution() {
        return new MultivariateNormalDistribution(this.computeMean(), this.computePrecision());
    }

    private double[] computeMean() {
        if (this.traitModel.strengthOfSelection != null) {
            return MultivariateTraitUtils.computeTreeTraitMeanOU(this.traitModel, this.rootValue, this.conditionOnRoot);
        }
        return MultivariateTraitUtils.computeTreeTraitMean(this.traitModel, this.rootValue, this.conditionOnRoot);
    }

    private double[][] computePrecision() {
        return MultivariateTraitUtils.computeTreeTraitPrecision(this.traitModel, this.conditionOnRoot);
    }

    @Override
    public double[] nextRandom() {
        this.checkDistribution();
        return this.distribution.nextMultivariateNormal();
    }

    @Override
    public double logPdf(Object object) {
        this.checkDistribution();
        return this.distribution.logPdf(object);
    }

    @Override
    public Variable<Double> getLocationVariable() {
        throw new UnsupportedOperationException("Not implemented");
    }
}

