/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.substmodel;

import dr.inference.model.Bounds;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.oldevomodel.substmodel.AbstractNucleotideModel;
import dr.oldevomodel.substmodel.FrequencyModel;

public class NtdBMA
extends AbstractNucleotideModel {
    private Variable<Double> logKappa = null;
    private Variable<Double> logTN = null;
    private Variable<Double> logAC = null;
    private Variable<Double> logAT = null;
    private Variable<Double> logGC = null;
    private Variable<Double> logGT = null;
    private Variable<Integer> modelChoose = null;
    public static final int TN_INDEX = 0;
    public static final int GTR_INDEX = 1;
    public static final int ABSENT = 0;
    public static final int PRESENT = 1;

    public NtdBMA(Variable<Double> variable, Variable<Double> variable2, Variable<Double> variable3, Variable<Double> variable4, Variable<Double> variable5, Variable<Double> variable6, Variable<Integer> variable7, FrequencyModel frequencyModel) {
        super("NucleotideBMA", frequencyModel);
        this.addVariable(variable);
        variable.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
        this.logKappa = variable;
        this.addVariable(variable2);
        variable2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
        this.logTN = variable2;
        this.addVariable(variable3);
        variable3.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
        this.logAC = variable3;
        this.addVariable(variable4);
        variable4.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
        this.logAT = variable4;
        this.addVariable(variable5);
        variable5.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
        this.logGC = variable5;
        this.addVariable(variable6);
        variable6.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
        this.logGT = variable6;
        this.addVariable(variable7);
        variable7.addBounds(new Bounds.Int(variable7, 0, 1));
        this.modelChoose = variable7;
    }

    @Override
    protected void setupRelativeRates() {
        this.relativeRates[1] = Math.exp(this.logKappa.getValue(0) + (double)this.modelChoose.getValue(0).intValue() * this.logTN.getValue(0));
        this.relativeRates[4] = Math.exp(this.logKappa.getValue(0) - (double)this.modelChoose.getValue(0).intValue() * this.logTN.getValue(0));
        this.relativeRates[0] = Math.exp((double)this.modelChoose.getValue(1).intValue() * this.logAC.getValue(0));
        this.relativeRates[2] = Math.exp((double)this.modelChoose.getValue(1).intValue() * this.logAT.getValue(0));
        this.relativeRates[3] = Math.exp((double)this.modelChoose.getValue(1).intValue() * this.logGC.getValue(0));
        this.relativeRates[5] = Math.exp((double)this.modelChoose.getValue(1).intValue() * this.logGT.getValue(0));
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        boolean bl = false;
        if (variable == this.modelChoose) {
            bl = true;
        } else if (variable == this.logKappa) {
            bl = true;
        } else if (variable == this.logTN && this.modelChoose.getValue(0) == 1) {
            bl = true;
        } else if (variable == this.logAC || variable == this.logAT || variable == this.logGC || variable == this.logGT && this.modelChoose.getValue(1) == 1 && this.modelChoose.getValue(0) == 1) {
            bl = true;
        }
        if (bl) {
            super.handleVariableChangedEvent(variable, n, changeType);
        }
        bl = false;
    }
}

