## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----built--------------------------------------------------------------------
message(paste0('Datetime: ',Sys.Date(),':',Sys.time()))

## ----setup, message=FALSE-----------------------------------------------------
library(repfun)
library(dplyr)

## ----envir--------------------------------------------------------------------
tmpdr <- tempdir()
datdir <- file.path(gsub("\\","/",tmpdr,fixed=TRUE),"datdir")
dir.create(datdir,showWarnings=FALSE)
repfun::copydata(datdir)
repfun::rs_setup(D_POPDATA=repfun::adsl %>% 
           dplyr::filter(SAFFL =='Y'),
         D_SUBJID=c("STUDYID","USUBJID"),
         R_ADAMDATA=datdir)

## ----update, out.width="70%"--------------------------------------------------
repfun:::rfenv$G_POPDATA %>% dplyr::mutate(TRT01AN=ifelse(TRT01A=='Placebo',1,ifelse(TRT01A=='Xanomeline Low Dose',2,3))) -> G_POPDATA
attr(G_POPDATA$TRT01AN,"label") <- 'Actual Treatment for Period 01 (n)'

repfun:::rfenv$adamdata$advs.rda() %>% dplyr::filter(ANL01FL=='Y') %>% 
  dplyr::mutate(TRT01AN=ifelse(TRT01A=='Placebo',1,ifelse(TRT01A=='Xanomeline Low Dose',2,3))) %>%
  dplyr::filter(!is.na(AVISITN) & (DTYPE=='AVERAGE')) -> advs2
attr(advs2$TRT01AN,"label") <- 'Actual Treatment for Period 01 (n)'

## ----sumstats1----------------------------------------------------------------
repfun::ru_sumstats(G_POPDATA,
            analysisvars=c("AGE","TRTDURD"),
            groupbyvars=c("STUDYID","TRT01AN"),
            codedecodevarpairs=c("TRT01AN", "TRT01A"),
            totalforvar="TRT01AN", totalid=99,
            totaldecode="Total",
            statsinrowsyn = "Y",
            analysisvardps=list("AGE"=1,"TRTDURD"=2),
            statslist=c("n", "mean", "median", "sd", "min", "max")) %>% 
   dplyr::arrange(tt_avid, TRT01AN,tt_svid) %>% dplyr::select(-tt_result_num) -> basechars

## ----results1-----------------------------------------------------------------
lbls <- sapply(basechars,function(x){attr(x,"label")})
knitr::kable(head(basechars,10), col.names=paste(names(lbls),lbls,sep=" "), 
             caption = "Summary Statistics for Baseline Characteristics")

## ----sumstats2----------------------------------------------------------------
repfun::ru_sumstats(advs2,
            analysisvars=c("AVAL"),
            groupbyvars=c("STUDYID","TRT01AN","PARAMCD","AVISITN"),
            codedecodevarpairs=c("TRT01AN","TRT01A","PARAMCD","PARAM","AVISITN","AVISIT"),
            totalforvar="TRT01AN",
            totalid=99,
            totaldecode="Total",
            statsinrowsyn = "Y",
            analysisvardps=1,
            statslist=c("n","mean","median","sd","min","max")) %>% 
            dplyr::arrange(TRT01AN,PARAMCD,AVISITN, tt_svid) %>%     
            dplyr::select(-c('tt_avnm','tt_avid','tt_result_num')) -> vtlsigns

## ----results2-----------------------------------------------------------------
lbls <- sapply(vtlsigns,function(x){attr(x,"label")})
knitr::kable(head(vtlsigns,10), col.names=paste(names(lbls),lbls,sep=" "), 
             caption = "Summary Statistics for Vital Signs with Constant Precision")

## ----sumstats3----------------------------------------------------------------
decodes <- advs2 %>% distinct(PARAMCD, PARAM)
dcodelst <- split(decodes$PARAM, decodes$PARAMCD)
advs2 %>% dplyr::select(STUDYID,USUBJID,TRT01AN,TRT01A,PARAMCD,AVISITN,AVISIT,AVAL) %>% 
  dplyr::arrange(USUBJID,TRT01AN,TRT01A,AVISITN,AVISIT) %>%
  dplyr::group_by(USUBJID,TRT01AN,TRT01A,AVISITN,AVISIT) %>% 
  tidyr::pivot_wider(names_from=PARAMCD, values_from=AVAL) -> advs2_t
advs2_t <- repfun::ru_labels(advs2_t,varlabels=dcodelst)
repfun::ru_sumstats(advs2_t,
            analysisvars=c("BMI","BSA","DIABP","MAP","PULSE","SYSBP","TEMP","WEIGHT"),
            groupbyvars=c("STUDYID","TRT01AN","AVISITN"),
            codedecodevarpairs=c("TRT01AN","TRT01A","AVISITN","AVISIT"),
            totalforvar="TRT01AN", totalid=99,
            totaldecode="Total",
            statsinrowsyn = "Y",
            analysisvardps=list("BMI"=1,"BSA"=2,"DIABP"=3,"MAP"=4,"PULSE"=1,"SYSBP"=2,
                                "TEMP"=3,"WEIGHT"=4),
            statslist=c("n","mean","median","sd","min","max")) %>% 
  dplyr::left_join(decodes %>% dplyr::mutate(tt_avnm=PARAMCD),by='tt_avnm') %>% 
  dplyr::arrange(tt_avid, TRT01AN, AVISITN, tt_svid) %>%
  dplyr::select(-c('tt_result_num','tt_avnm')) %>% 
  dplyr::arrange(PARAMCD,TRT01AN,AVISITN) -> vtlsigns_t

## ----results3-----------------------------------------------------------------
lbls <- sapply(vtlsigns_t,function(x){attr(x,"label")})
knitr::kable(head(vtlsigns_t,10), col.names=paste(names(lbls),lbls,sep=" "), 
             caption = "Summary Statistics for Vital Signs with Varying Precision")

