/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.siteratemodel;

import dr.evomodel.siteratemodel.SiteRateDelegate;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.distributions.GammaDistribution;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.ArrayList;
import java.util.List;

public class GammaSiteRateDelegate
extends AbstractModel
implements SiteRateDelegate,
Citable {
    private Parameter shapeParameter;
    private Parameter invarParameter;
    private int categoryCount;
    public static final Citation CITATION_YANG94 = new Citation(new Author[]{new Author("Z", "Yang")}, "Maximum likelihood phylogenetic estimation from DNA sequences with variable rates over sites: approximate methods", 1994, "J. Mol. Evol.", 39, 306, 314, Citation.Status.PUBLISHED);

    public GammaSiteRateDelegate(String string, Parameter parameter, int n, Parameter parameter2) {
        super(string);
        this.shapeParameter = parameter;
        if (parameter != null) {
            this.categoryCount = n;
            this.addVariable(parameter);
            parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        } else {
            this.categoryCount = 1;
        }
        this.invarParameter = parameter2;
        if (parameter2 != null) {
            ++this.categoryCount;
            this.addVariable(parameter2);
            parameter2.addBounds(new Parameter.DefaultBounds(1.0, 0.0, 1));
        }
    }

    @Override
    public int getCategoryCount() {
        return this.categoryCount;
    }

    @Override
    public void getCategories(double[] dArray, double[] dArray2) {
        assert (dArray != null && dArray.length == this.categoryCount);
        assert (dArray2 != null && dArray2.length == this.categoryCount);
        int n = 0;
        if (this.invarParameter != null) {
            dArray[0] = 0.0;
            dArray2[0] = this.invarParameter.getParameterValue(0);
            n = 1;
        }
        if (this.shapeParameter != null) {
            double d = this.shapeParameter.getParameterValue(0);
            int n2 = this.categoryCount - n;
            GammaSiteRateDelegate.setEqualRates(dArray, dArray2, d, n2, n);
        } else if (n > 0) {
            dArray[n] = 2.0;
            dArray2[n] = 1.0 - dArray2[0];
        } else {
            dArray[0] = 1.0;
            dArray2[0] = 1.0;
        }
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.listenerHelper.fireModelChanged(this, object, n);
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.listenerHelper.fireModelChanged(this, variable, n);
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.SUBSTITUTION_MODELS;
    }

    @Override
    public String getDescription() {
        return "Discrete gamma-distributed rate heterogeneity model";
    }

    @Override
    public List<Citation> getCitations() {
        ArrayList<Citation> arrayList = new ArrayList<Citation>();
        if (this.shapeParameter != null) {
            arrayList.add(CITATION_YANG94);
        }
        return arrayList;
    }

    public static void setEqualRates(double[] dArray, double[] dArray2, double d, int n, int n2) {
        for (int i = 0; i < n; ++i) {
            dArray[i + n2] = GammaDistribution.quantile((2.0 * (double)i + 1.0) / (2.0 * (double)n), d, 1.0 / d);
            dArray2[i + n2] = 1.0;
        }
        GammaSiteRateDelegate.normalize(dArray, dArray2);
    }

    public static void normalize(double[] dArray, double[] dArray2) {
        int n;
        double d = 0.0;
        double d2 = 0.0;
        for (n = 0; n < dArray.length; ++n) {
            d += dArray[n];
            d2 += dArray2[n];
        }
        d /= (double)dArray.length;
        n = 0;
        while (n < dArray.length) {
            int n2 = n;
            dArray[n2] = dArray[n2] / d;
            int n3 = n++;
            dArray2[n3] = dArray2[n3] / d2;
        }
    }

    public static void main(String[] stringArray) {
        double[] dArray = new double[6];
        double[] dArray2 = new double[6];
        GammaSiteRateDelegate.setEqualRates(dArray, dArray2, 1.0, 6, 0);
        double d = 0.0;
        double d2 = 0.0;
        System.out.println();
        System.out.println("Equal, alpha = 1.0");
        System.out.println("cat\trate\tproportion");
        for (int i = 0; i < 6; ++i) {
            System.out.println(i + "\t" + dArray[i] + "\t" + dArray2[i]);
            d += dArray[i];
            d2 += dArray2[i];
        }
        System.out.println("SUM\t" + d + "\t" + d2);
    }
}

