/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import dr.math.MathUtils;
import dr.math.MinimiserMonitor;
import dr.math.MultivariateFunction;
import dr.math.MultivariateMinimum;

public class DifferentialEvolution
extends MultivariateMinimum {
    public double F = 0.7;
    public double CR = 0.9;
    public int prin = 0;
    private MultivariateFunction f;
    private int currGen;
    private double fx;
    private double[] x;
    private int dimension;
    private int populationSize;
    private double trialCost;
    private double[] costs;
    private double[] trialVector;
    private double[][] currentPopulation;
    private double[][] nextPopulation;
    private int numr;
    private int[] r;

    public DifferentialEvolution(int n) {
        this(n, 5 * n);
    }

    public DifferentialEvolution(int n, int n2) {
        this.dimension = n;
        this.populationSize = n2;
        this.numFun = 0;
        this.currentPopulation = new double[this.populationSize][this.dimension];
        this.nextPopulation = new double[this.populationSize][this.dimension];
        this.costs = new double[this.populationSize];
        this.trialVector = new double[this.dimension];
        this.numr = 3;
        this.r = new int[this.numr];
    }

    @Override
    public void optimize(MultivariateFunction multivariateFunction, double[] dArray, double d, double d2) {
        this.optimize(multivariateFunction, dArray, d, d2, null);
    }

    @Override
    public void optimize(MultivariateFunction multivariateFunction, double[] dArray, double d, double d2, MinimiserMonitor minimiserMonitor) {
        this.f = multivariateFunction;
        this.x = dArray;
        this.firstGeneration();
        this.stopCondition(this.fx, this.x, d, d2, true);
        while (true) {
            boolean bl = this.nextGeneration();
            if (this.maxFun <= 0 || this.numFun <= this.maxFun) {
                if (this.prin > 1 && this.currGen % 20 == 0) {
                    this.printStatistics();
                }
                if (minimiserMonitor != null) {
                    minimiserMonitor.newMinimum(this.fx, dArray);
                }
                if (!bl) continue;
            }
            if (this.stopCondition(this.fx, this.x, d, d2, false) || this.maxFun > 0 && this.numFun > this.maxFun) break;
        }
        if (this.prin > 0) {
            this.printStatistics();
        }
    }

    private void printStatistics() {
        int n;
        double d = 0.0;
        for (int i = 0; i < this.populationSize; ++i) {
            d += this.costs[i];
        }
        d /= (double)this.populationSize;
        double d2 = 0.0;
        for (n = 0; n < this.populationSize; ++n) {
            double d3 = this.costs[n] - d;
            d2 += d3 * d3;
        }
        d2 /= (double)(this.populationSize - 1);
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println("Smallest value: " + this.fx);
        System.out.println();
        for (n = 0; n < this.dimension; ++n) {
            System.out.println("x[" + n + "] = " + this.x[n]);
        }
        System.out.println();
        System.out.println("Current Generation: " + this.currGen);
        System.out.println("Function evaluations: " + this.numFun);
        System.out.println("Populations size (populationSize): " + this.populationSize);
        System.out.println("Average value: " + d);
        System.out.println("Variance: " + d2);
        System.out.println("Weight factor (F): " + this.F);
        System.out.println("Crossing-over (CR): " + this.CR);
        System.out.println();
    }

    private void firstGeneration() {
        this.currGen = 1;
        for (int i = 0; i < this.populationSize; ++i) {
            for (int j = 0; j < this.dimension; ++j) {
                double d = this.f.getLowerBound(j);
                double d2 = this.f.getUpperBound(j);
                double d3 = d2 - d;
                this.currentPopulation[i][j] = d + d3 * MathUtils.nextDouble();
            }
            this.costs[i] = this.f.evaluate(this.currentPopulation[i]);
        }
        this.numFun += this.populationSize;
        this.findSmallestCost();
    }

    private double checkBounds(double d, int n) {
        if (d < this.f.getLowerBound(n)) {
            return this.f.getLowerBound(n);
        }
        if (d > this.f.getUpperBound(n)) {
            return this.f.getUpperBound(n);
        }
        return d;
    }

    private boolean nextGeneration() {
        boolean bl = false;
        int n = 0;
        ++this.currGen;
        for (int i = 0; i < this.populationSize; ++i) {
            int n2;
            int n3;
            this.r[0] = i;
            for (n3 = 1; n3 < this.numr; ++n3) {
                this.r[n3] = this.randomInteger(this.populationSize - n3);
                for (n2 = 0; n2 < n3; ++n2) {
                    if (this.r[n3] < this.r[n2]) continue;
                    int n4 = n3;
                    this.r[n4] = this.r[n4] + 1;
                }
            }
            this.copy(this.trialVector, this.currentPopulation[i]);
            n3 = this.randomInteger(this.dimension);
            for (n2 = 0; n2 < this.dimension; ++n2) {
                if (MathUtils.nextDouble() < this.CR || n2 == this.dimension - 1) {
                    this.trialVector[n3] = this.trialVector[n3] + this.F * (this.x[n3] - this.trialVector[n3]) + this.F * (this.currentPopulation[this.r[1]][n3] - this.currentPopulation[this.r[2]][n3]);
                }
                n3 = (n3 + 1) % this.dimension;
            }
            for (n2 = 0; n2 < this.dimension; ++n2) {
                this.trialVector[n2] = this.checkBounds(this.trialVector[n2], n2);
            }
            this.trialCost = this.f.evaluate(this.trialVector);
            if (this.trialCost < this.costs[i]) {
                this.costs[i] = this.trialCost;
                this.copy(this.nextPopulation[i], this.trialVector);
                if (!(this.trialCost < this.fx)) continue;
                this.fx = this.trialCost;
                n = i;
                bl = true;
                continue;
            }
            this.copy(this.nextPopulation[i], this.currentPopulation[i]);
        }
        this.numFun += this.populationSize;
        if (bl) {
            this.copy(this.x, this.nextPopulation[n]);
        }
        double[][] dArray = this.currentPopulation;
        this.currentPopulation = this.nextPopulation;
        this.nextPopulation = dArray;
        return bl;
    }

    private void findSmallestCost() {
        int n = 0;
        this.fx = this.costs[0];
        for (int i = 1; i < this.populationSize; ++i) {
            if (!(this.costs[i] < this.fx)) continue;
            this.fx = this.costs[i];
            n = i;
        }
        this.copy(this.x, this.currentPopulation[n]);
    }

    private int randomInteger(int n) {
        return MathUtils.nextInt(n);
    }
}

