/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.likelihood;

import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import org.ohdsi.data.GridWithGradientsData;

public class GridWithGradientsLikelihood
extends AbstractModelLikelihood {
    private static final long serialVersionUID = -934094651050122633L;
    private final Parameter beta;
    private final GridWithGradientsData data;
    private boolean likelihoodKnown;
    private double logLikelihood;
    private boolean storedLikelihoodKnown;
    private double storedLogLikelihood;

    public GridWithGradientsLikelihood(Parameter beta, GridWithGradientsData data) {
        super("GridWithGradientsLikelihood");
        this.beta = beta;
        this.data = data;
        this.addVariable((Variable)beta);
        this.likelihoodKnown = false;
    }

    protected void handleVariableChangedEvent(Variable variable, int i, Variable.ChangeType changeType) {
        if (variable == this.beta) {
            this.likelihoodKnown = false;
        }
    }

    protected void storeState() {
        this.storedLikelihoodKnown = this.likelihoodKnown;
        this.storedLogLikelihood = this.logLikelihood;
    }

    protected void restoreState() {
        this.likelihoodKnown = this.storedLikelihoodKnown;
        this.logLikelihood = this.storedLogLikelihood;
    }

    protected void acceptState() {
    }

    public Model getModel() {
        return this;
    }

    private double computeLikelihood() {
        int n = this.data.point.length;
        double x = this.beta.getParameterValue(0);
        if (x < this.data.point[0]) {
            return this.data.value[0] + (x - this.data.point[0]) * Math.max(this.data.derivative[0], 0.0);
        }
        if (x > this.data.point[n - 1]) {
            return this.data.value[n - 1] + (x - this.data.point[n - 1]) * Math.min(this.data.derivative[n - 1], 0.0);
        }
        int i = 0;
        while (i < n - 1) {
            if (x >= this.data.point[i] && x <= this.data.point[i + 1]) {
                double t = (x - this.data.point[i]) / (this.data.point[i + 1] - this.data.point[i]);
                double h00 = 2.0 * Math.pow(t, 3.0) - 3.0 * Math.pow(t, 2.0) + 1.0;
                double h10 = Math.pow(t, 3.0) - 2.0 * Math.pow(t, 2.0) + t;
                double h01 = -2.0 * Math.pow(t, 3.0) + 3.0 * Math.pow(t, 2.0);
                double h11 = Math.pow(t, 3.0) - Math.pow(t, 2.0);
                double dx = this.data.point[i + 1] - this.data.point[i];
                return h00 * this.data.value[i] + h10 * dx * this.data.derivative[i] + h01 * this.data.value[i + 1] + h11 * dx * this.data.derivative[i + 1];
            }
            ++i;
        }
        throw new IllegalArgumentException("x is out of range, and extrapolation failed.");
    }

    public double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.computeLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    public void makeDirty() {
        this.likelihoodKnown = false;
    }

    protected void handleModelChangedEvent(Model arg0, Object arg1, int arg2) {
    }

    public static void main(String[] args) {
        double[] xs;
        double[] point = new double[]{1.1, 2.1};
        double[] value = new double[]{1.0, 1.0};
        double[] derivative = new double[]{0.1, -0.1};
        GridWithGradientsData data = new GridWithGradientsData(point, value, derivative);
        Parameter.Default parameter = new Parameter.Default(0.0);
        GridWithGradientsLikelihood likelihood = new GridWithGradientsLikelihood((Parameter)parameter, data);
        double[] dArray = xs = new double[]{0.0, 1.0, 2.0, 3.0};
        int n = xs.length;
        int n2 = 0;
        while (n2 < n) {
            double x = dArray[n2];
            parameter.setParameterValue(0, x);
            likelihood.makeDirty();
            System.out.println(likelihood.getLogLikelihood());
            ++n2;
        }
    }
}

