/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.special;

import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.modelling.DefaultTransformationType;
import ec.tstoolkit.modelling.RegressionTestSpec;
import ec.tstoolkit.modelling.arima.IPreprocessor;
import ec.tstoolkit.modelling.arima.Method;
import ec.tstoolkit.modelling.arima.NoPreprocessing;
import ec.tstoolkit.modelling.arima.tramo.CalendarSpec;
import ec.tstoolkit.modelling.arima.tramo.EasterSpec;
import ec.tstoolkit.modelling.arima.tramo.OutlierSpec;
import ec.tstoolkit.modelling.arima.tramo.RegressionSpec;
import ec.tstoolkit.modelling.arima.tramo.TradingDaysSpec;
import ec.tstoolkit.modelling.arima.tramo.TramoSpecification;
import ec.tstoolkit.modelling.arima.tramo.TransformSpec;
import ec.tstoolkit.modelling.arima.x13.MovingHolidaySpec;
import ec.tstoolkit.modelling.arima.x13.RegArimaSpecification;
import ec.tstoolkit.timeseries.calendars.LengthOfPeriodType;
import ec.tstoolkit.timeseries.calendars.TradingDaysType;
import ec.tstoolkit.timeseries.regression.OutlierType;
import java.util.Map;
import java.util.Objects;

public class PreprocessingSpecification
implements IProcSpecification,
Cloneable {
    private static final String METHOD = "method";
    private static final String TRANSFORM = "transform";
    private static final String TD = "td";
    private static final String LP = "lp";
    private static final String EASTER = "easter";
    private static final String PRETEST = "pretest";
    private static final String AO = "ao";
    private static final String LS = "ls";
    private static final String TC = "tc";
    private static final String SO = "so";
    public Method method = Method.Tramo;
    public DefaultTransformationType transform = DefaultTransformationType.Auto;
    public TradingDaysType dtype = TradingDaysType.WorkingDays;
    public LengthOfPeriodType ltype = LengthOfPeriodType.LeapYear;
    public boolean easter = true;
    public boolean pretest = true;
    public boolean ao = true;
    public boolean ls = true;
    public boolean tc = true;
    public boolean so = false;

    private IPreprocessor buildTramo(ProcessingContext context) {
        TramoSpecification spec = new TramoSpecification();
        TransformSpec tspec = new TransformSpec();
        tspec.setFunction(this.transform);
        spec.setTransform(tspec);
        RegressionSpec rspec = new RegressionSpec();
        CalendarSpec cspec = new CalendarSpec();
        TradingDaysSpec tdspec = new TradingDaysSpec();
        tdspec.setLeapYear(this.ltype != LengthOfPeriodType.None);
        tdspec.setTradingDaysType(this.dtype);
        tdspec.setTest(this.pretest);
        cspec.setTradingDays(tdspec);
        if (this.easter) {
            EasterSpec espec = new EasterSpec();
            espec.setTest(this.pretest);
            espec.setOption(EasterSpec.Type.Standard);
            cspec.setEaster(espec);
        }
        rspec.setCalendar(cspec);
        spec.setRegression(rspec);
        if (this.ao || this.ls || this.tc || this.so) {
            OutlierSpec ospec = new OutlierSpec();
            if (this.ao) {
                ospec.add(OutlierType.AO);
            }
            if (this.ls) {
                ospec.add(OutlierType.LS);
            }
            if (this.tc) {
                ospec.add(OutlierType.TC);
            }
            if (this.so) {
                ospec.add(OutlierType.SO);
            }
            spec.setOutliers(ospec);
        }
        spec.setUsingAutoModel(false);
        spec.getArima().airline();
        return spec.build(context);
    }

    private IPreprocessor buildX13(ProcessingContext context) {
        RegArimaSpecification spec = new RegArimaSpecification();
        ec.tstoolkit.modelling.arima.x13.TransformSpec tspec = new ec.tstoolkit.modelling.arima.x13.TransformSpec();
        tspec.setFunction(this.transform);
        spec.setTransform(tspec);
        ec.tstoolkit.modelling.arima.x13.RegressionSpec rspec = new ec.tstoolkit.modelling.arima.x13.RegressionSpec();
        ec.tstoolkit.modelling.arima.x13.TradingDaysSpec tdspec = new ec.tstoolkit.modelling.arima.x13.TradingDaysSpec();
        tdspec.setTradingDaysType(this.dtype);
        tdspec.setLengthOfPeriod(this.ltype);
        tdspec.setAutoAdjust(true);
        if (this.pretest) {
            tdspec.setTest(RegressionTestSpec.Remove);
        }
        rspec.setTradingDays(tdspec);
        if (this.easter) {
            rspec.add(MovingHolidaySpec.easterSpec(this.pretest));
        }
        spec.setRegression(rspec);
        if (this.ao || this.ls || this.tc || this.so) {
            ec.tstoolkit.modelling.arima.x13.OutlierSpec ospec = new ec.tstoolkit.modelling.arima.x13.OutlierSpec();
            if (this.ao) {
                ospec.add(OutlierType.AO);
            }
            if (this.ls) {
                ospec.add(OutlierType.LS);
            }
            if (this.tc) {
                ospec.add(OutlierType.TC);
            }
            if (this.so) {
                ospec.add(OutlierType.SO);
            }
            spec.setOutliers(ospec);
        }
        spec.setUsingAutoModel(false);
        spec.getArima().airline();
        return spec.build(context);
    }

    public IPreprocessor build(ProcessingContext context) {
        switch (this.method) {
            case Tramo: {
                return this.buildTramo(context);
            }
            case Regarima: {
                return this.buildX13(context);
            }
        }
        return new NoPreprocessing();
    }

    @Override
    public PreprocessingSpecification clone() {
        try {
            return (PreprocessingSpecification)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    @Override
    public InformationSet write(boolean verbose) {
        InformationSet info = new InformationSet();
        info.set(METHOD, this.method.name());
        info.set(TRANSFORM, this.transform.name());
        info.set(TD, this.dtype.name());
        info.set(LP, this.ltype.name());
        info.set(EASTER, Boolean.valueOf(this.easter));
        info.set(PRETEST, Boolean.valueOf(this.pretest));
        info.set(AO, Boolean.valueOf(this.ao));
        info.set(LS, Boolean.valueOf(this.ls));
        info.set(TC, Boolean.valueOf(this.tc));
        info.set(SO, Boolean.valueOf(this.so));
        return info;
    }

    @Override
    public boolean read(InformationSet info) {
        Boolean b;
        String s = info.get(METHOD, String.class);
        if (s != null) {
            this.method = Method.valueOf(s);
        }
        if ((s = info.get(TRANSFORM, String.class)) != null) {
            this.transform = DefaultTransformationType.valueOf(s);
        }
        if ((s = info.get(TD, String.class)) != null) {
            this.dtype = TradingDaysType.valueOf(s);
        }
        if ((s = info.get(LP, String.class)) != null) {
            this.ltype = LengthOfPeriodType.valueOf(s);
        }
        if ((b = info.get(EASTER, Boolean.class)) != null) {
            this.easter = b;
        }
        if ((b = info.get(PRETEST, Boolean.class)) != null) {
            this.pretest = b;
        }
        if ((b = info.get(AO, Boolean.class)) != null) {
            this.ao = b;
        }
        if ((b = info.get(LS, Boolean.class)) != null) {
            this.ls = b;
        }
        if ((b = info.get(TC, Boolean.class)) != null) {
            this.tc = b;
        }
        if ((b = info.get(SO, Boolean.class)) != null) {
            this.so = b;
        }
        return true;
    }

    public boolean equals(PreprocessingSpecification other) {
        return other.method == this.method && other.transform == this.transform && other.dtype == this.dtype && other.ltype == this.ltype && other.easter == this.easter && other.pretest == this.pretest && other.ao == this.ao && other.ls == this.ls && other.tc == this.tc && other.so == this.so;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof PreprocessingSpecification && this.equals((PreprocessingSpecification)obj);
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + Objects.hashCode((Object)this.method);
        hash = 97 * hash + Objects.hashCode((Object)this.transform);
        hash = 97 * hash + Objects.hashCode((Object)this.dtype);
        hash = 97 * hash + Objects.hashCode((Object)this.ltype);
        hash = 97 * hash + (this.easter ? 1 : 0);
        hash = 97 * hash + (this.pretest ? 1 : 0);
        hash = 97 * hash + (this.ao ? 1 : 0);
        hash = 97 * hash + (this.ls ? 1 : 0);
        return hash;
    }

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        dic.put(InformationSet.item(prefix, METHOD), String.class);
        dic.put(InformationSet.item(prefix, TRANSFORM), String.class);
        dic.put(InformationSet.item(prefix, TD), String.class);
        dic.put(InformationSet.item(prefix, LP), String.class);
        dic.put(InformationSet.item(prefix, EASTER), Boolean.class);
        dic.put(InformationSet.item(prefix, PRETEST), Boolean.class);
        dic.put(InformationSet.item(prefix, AO), Boolean.class);
        dic.put(InformationSet.item(prefix, LS), Boolean.class);
        dic.put(InformationSet.item(prefix, TC), Boolean.class);
        dic.put(InformationSet.item(prefix, SO), Boolean.class);
    }
}

