/*
 * Decompiled with CFR 0.152.
 */
package beagle;

public enum BeagleBenchmarkFlag {
    SCALING_NONE(1L, "No scaling"),
    SCALING_ALWAYS(2L, "Scale at every iteration"),
    SCALING_DYNAMIC(4L, "Scale every fixed number of iterations or when a numerical error occurs, and re-use scale factors for subsequent iterations");

    private final long mask;
    private final String meaning;

    private BeagleBenchmarkFlag(long l, String string2) {
        this.mask = l;
        this.meaning = string2;
    }

    public long getMask() {
        return this.mask;
    }

    public String getMeaning() {
        return this.meaning;
    }

    public boolean isSet(long l) {
        return (l & this.mask) != 0L;
    }

    public static String toString(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        for (BeagleBenchmarkFlag beagleBenchmarkFlag : BeagleBenchmarkFlag.values()) {
            if (!beagleBenchmarkFlag.isSet(l)) continue;
            stringBuilder.append(" ").append(beagleBenchmarkFlag.name());
        }
        return stringBuilder.toString();
    }
}

