## ----echo=FALSE, message=FALSE, warning=FALSE---------------------------------
# Ensure the temporary library from R CMD check is visible (esp. on Windows)
libdir <- Sys.getenv("R_LIBS")
if (nzchar(libdir)) {
  parts <- strsplit(libdir, .Platform$path.sep, fixed = TRUE)[[1]]
  .libPaths(unique(c(parts, .libPaths())))
}

# now load your package
suppressPackageStartupMessages(library(ecotourism))


## ----echo=TRUE, eval=TRUE, message=FALSE, warning=FALSE-----------------------
library(dplyr)
library(ecotourism)

data("top_stations")
top_stations |> glimpse()


## ----echo=TRUE, eval=TRUE, message=FALSE, warning=FALSE-----------------------

data("weather")
weather |> glimpse()


## ----echo=TRUE, eval=FALSE, fig.width=6, fig.height=4, message=FALSE, warning=FALSE----
# library(ggplot2)
# library(ggthemes)
# 
# top_stations |> left_join(weather_stations) |>
# ggplot() +
#   geom_sf(data = oz_lga) +
#   geom_point(aes(x = stn_lon, y = stn_lat, color = organism), shape = 17, size = 3) +
#   theme_map()

