## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(ricci)

a <- array(1:(2^3), dim = c(2, 2, 2))

## -----------------------------------------------------------------------------
a %_% .(i, j, k)

## -----------------------------------------------------------------------------
a %_% .(i, j, +k)

## -----------------------------------------------------------------------------
b <- a %_% .(i, +i, k)
b

## -----------------------------------------------------------------------------
c <- a %_% .(i, i, k)
c

## -----------------------------------------------------------------------------
d <- a %_% .(i, j, k) * a %_% .(l, m, n)
d

## -----------------------------------------------------------------------------
e <- a %_% .(i, j, k) * a %_% .(+i, +j, +k)
e

## -----------------------------------------------------------------------------
f <- a %_% .(i, j, k) * a %_% .(+i, j, +k)
f

## -----------------------------------------------------------------------------
g <- a %_% .(i, j, k) * a %_% .(i, j, k)
g

## -----------------------------------------------------------------------------
(a %_% .(i, j, k) * a %_% .(l, m, n)) |>
  kron(.(i, l) -> r, .(j, m) -> p, .(k, n) -> q)

## -----------------------------------------------------------------------------
h <- a %_% .(i, j, k) + a %_% .(j, i, k)
h

## -----------------------------------------------------------------------------
a %_% .(i, j, k) |> sym(i, j)
a %_% .(i, j, k) |> sym(i, j, k)

a %_% .(i, j, k) |> asym(i, j)
a %_% .(i, j, k) |> asym(i, j, k)

## -----------------------------------------------------------------------------
g |> as_a(i, j, k)

## -----------------------------------------------------------------------------
as.array(g, .(i, j, k))

