/*
 * Decompiled with CFR 0.152.
 */
package ru.itmo.ctlab.virgo.sgmwcs.solver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ru.itmo.ctlab.virgo.sgmwcs.Signals;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Edge;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Graph;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Node;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Unit;

public class TreeSolver {
    private final Graph g;
    private final Signals s;
    private Set<Unit> withoutRoot;
    private Set<Unit> withRoot;

    public Set<Unit> solutionWithoutRoot() {
        return this.withoutRoot;
    }

    public Set<Unit> solutionWithRoot() {
        return this.withRoot;
    }

    public TreeSolver(Graph g, Signals s) {
        this.g = g;
        this.s = s;
    }

    public Solution solveRooted(Node root) {
        return this.solve(root, null, Collections.emptySet());
    }

    private Solution solve(Node root, Node parent, Set<Integer> parentSets) {
        List<Node> nodes = this.g.neighborListOf(root);
        assert (parent == null || nodes.contains(parent));
        HashSet<Unit> rootSet = new HashSet<Unit>();
        rootSet.add(root);
        Solution nonEmpty = new Solution(rootSet);
        Solution empty = new Solution();
        if (parent != null) {
            Edge e = this.g.getEdge(root, parent);
            nodes.remove(parent);
            rootSet.add(e);
        }
        if (nodes.isEmpty()) {
            Unit[] unitArray = new Unit[]{root};
            if (this.s.minSum(unitArray) < 0.0 && parentSets.containsAll(this.s.positiveUnitSets(nonEmpty.units))) {
                return empty;
            }
        }
        ArrayList<Solution> childSols = new ArrayList<Solution>();
        HashSet<Integer> signals = new HashSet<Integer>(nonEmpty.sets());
        signals.addAll(parentSets);
        for (Node node : nodes) {
            childSols.add(this.solve(node, root, signals));
        }
        for (Solution childSol : childSols) {
            HashSet<Integer> childSets = new HashSet<Integer>(childSol.sets());
            childSets.addAll(signals);
            if (!(this.s.weightSum(childSets) >= this.s.weightSum(signals))) continue;
            nonEmpty.units.addAll(childSol.units);
        }
        return nonEmpty;
    }

    class Solution {
        Set<Unit> units;

        Solution() {
            this.units = new HashSet<Unit>();
        }

        Set<Integer> sets() {
            return TreeSolver.this.s.unitSets(this.units);
        }

        Solution(Set<Unit> units) {
            this.units = units;
        }
    }
}

