/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.TreeUtils;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.evomodel.substmodel.SubstitutionModel;
import dr.evomodel.tree.TreeModel;
import dr.inference.hmc.GradientWrtParameterProvider;
import dr.inference.hmc.HessianWrtParameterProvider;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.GammaFunction;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CTMCScalePrior
extends AbstractModelLikelihood
implements GradientWrtParameterProvider,
HessianWrtParameterProvider,
Citable {
    private final Parameter ctmcScale;
    private final TreeModel treeModel;
    private Set<Taxon> taxa = null;
    private double treeLength;
    private double storedTreeLength;
    private boolean treeLengthKnown;
    private double logLikelihood;
    private double storedLogLikelihood;
    private boolean likelihoodKnown;
    private final boolean reciprocal;
    private final SubstitutionModel substitutionModel;
    private final boolean trial;
    private static final double shape = 0.5;
    private static final double logGammaOneHalf = GammaFunction.lnGamma(0.5);
    public static Citation CITATION = new Citation(new Author[]{new Author("MAR", "Ferreira"), new Author("MA", "Suchard")}, "Bayesian analysis of elapsed times in continuous-time Markov chains", 2008, "Canadian Journal of Statistics", 36, 355, 368, Citation.Status.PUBLISHED);

    public CTMCScalePrior(String string, Parameter parameter, TreeModel treeModel, TaxonList taxonList, boolean bl, SubstitutionModel substitutionModel, boolean bl2) {
        super(string);
        this.ctmcScale = parameter;
        this.treeModel = treeModel;
        this.addVariable(parameter);
        if (taxonList != null && taxonList.getTaxonCount() < treeModel.getTaxonCount()) {
            this.taxa = new HashSet<Taxon>();
            for (Taxon taxon : taxonList) {
                this.taxa.add(taxon);
            }
        }
        this.addModel(treeModel);
        this.treeLengthKnown = false;
        this.likelihoodKnown = false;
        this.reciprocal = bl;
        this.substitutionModel = substitutionModel;
        if (substitutionModel != null) {
            this.addModel(substitutionModel);
        }
        this.trial = bl2;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.treeLengthKnown = false;
        this.likelihoodKnown = false;
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.treeLengthKnown = false;
        this.likelihoodKnown = false;
    }

    @Override
    protected void storeState() {
        this.storedLogLikelihood = this.logLikelihood;
        this.storedTreeLength = this.treeLength;
    }

    @Override
    protected void restoreState() {
        this.logLikelihood = this.storedLogLikelihood;
        this.treeLength = this.storedTreeLength;
        this.treeLengthKnown = true;
        this.likelihoodKnown = true;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Model getModel() {
        return this;
    }

    private double calculateTrialLikelihood() {
        double d = this.getTreeLength();
        double d2 = -this.secondLargestEigenvalue();
        double d3 = 0.5 * Math.log(d2) - logGammaOneHalf;
        double d4 = 0.0;
        for (int i = 0; i < this.ctmcScale.getDimension(); ++i) {
            double d5 = this.ctmcScale.getParameterValue(i) * d;
            d4 += d3 - 0.5 * Math.log(d5) - d5 * d2;
        }
        return d4;
    }

    private double secondLargestEigenvalue() {
        double[] dArray = this.substitutionModel.getEigenDecomposition().getEigenValues();
        double d = Double.NEGATIVE_INFINITY;
        for (double d2 : dArray) {
            if (!(d2 > d) || !(d2 < 0.0)) continue;
            d = d2;
        }
        return d;
    }

    private double scaledTotalTreeTime() {
        double d = this.getTreeLength();
        if (this.reciprocal) {
            d = 1.0 / d;
        }
        if (this.substitutionModel != null) {
            d *= -this.secondLargestEigenvalue();
        }
        return d;
    }

    @Override
    public double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.calculateLogLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    private double calculateLogLikelihood() {
        if (this.trial) {
            return this.calculateTrialLikelihood();
        }
        double d = this.scaledTotalTreeTime();
        double d2 = 0.5 * Math.log(d) - logGammaOneHalf;
        double d3 = 0.0;
        for (int i = 0; i < this.ctmcScale.getDimension(); ++i) {
            double d4 = this.ctmcScale.getParameterValue(i);
            d3 += d2 - 0.5 * Math.log(d4) - d4 * d;
        }
        return d3;
    }

    private double getTreeLength() {
        if (!this.treeLengthKnown) {
            this.treeLength = this.taxa == null ? TreeUtils.getTreeLength(this.treeModel) : TreeUtils.getSubTreeLength(this.treeModel, this.taxa);
            this.treeLengthKnown = true;
        }
        return this.treeLength;
    }

    @Override
    public void makeDirty() {
        this.treeLengthKnown = false;
        this.likelihoodKnown = false;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.PRIOR_MODELS;
    }

    @Override
    public String getDescription() {
        return "CTMC Scale Reference Prior model";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CITATION);
    }

    @Override
    public Likelihood getLikelihood() {
        return this;
    }

    @Override
    public Parameter getParameter() {
        return this.ctmcScale;
    }

    @Override
    public int getDimension() {
        return this.ctmcScale.getDimension();
    }

    @Override
    public double[] getGradientLogDensity() {
        double[] dArray = new double[this.ctmcScale.getDimension()];
        double d = this.scaledTotalTreeTime();
        for (int i = 0; i < this.ctmcScale.getDimension(); ++i) {
            double d2 = this.ctmcScale.getParameterValue(i);
            dArray[i] = -0.5 / d2 - d;
        }
        return dArray;
    }

    @Override
    public double[] getDiagonalHessianLogDensity() {
        double[] dArray = new double[this.ctmcScale.getDimension()];
        double d = this.scaledTotalTreeTime();
        for (int i = 0; i < this.ctmcScale.getDimension(); ++i) {
            double d2 = this.ctmcScale.getParameterValue(i);
            dArray[i] = 0.5 / (d2 * d2);
        }
        return dArray;
    }

    @Override
    public double[][] getHessianLogDensity() {
        throw new RuntimeException("Not yet implemented.");
    }
}

